/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.data.tag.entity;

import com.google.common.base.Strings;
import infinityitemeditor.data.Data;
import infinityitemeditor.data.base.DataBitField;
import infinityitemeditor.data.base.DataBoolean;
import infinityitemeditor.data.base.DataMap;
import infinityitemeditor.data.base.DataRotation;
import infinityitemeditor.data.tag.TagItemList;
import infinityitemeditor.data.tag.entity.TagEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class TagEntityArmorStand
extends TagEntity<ArmorStandEntity> {
    private final DataBoolean marker;
    private final DataBoolean invisible;
    private final DataBoolean noBasePlate;
    private final DataBoolean noGravity;
    private final DataBoolean showArms;
    private final DataBoolean small;
    private final Pose pose;
    private final DataBitField disabledSlots;

    public TagEntityArmorStand(CompoundNBT nbt) {
        super(new TagItemList(nbt.func_150295_c("ArmorItems", 10), 4), new TagItemList(nbt.func_150295_c("HandItems", 10), 2));
        this.marker = new DataBoolean(nbt.func_74767_n("Marker"));
        this.invisible = new DataBoolean(nbt.func_74767_n("Invisible"));
        this.noBasePlate = new DataBoolean(nbt.func_74767_n("NoBasePlate"));
        this.showArms = new DataBoolean(nbt.func_74767_n("ShowArms"));
        this.small = new DataBoolean(nbt.func_74767_n("Small"));
        this.pose = new Pose(nbt.func_74775_l("Pose"));
        this.noGravity = new DataBoolean(nbt.func_74767_n("NoGravity"));
        this.disabledSlots = new DataBitField(21, nbt.func_74762_e("DisabledSlots"));
    }

    @Override
    public ArmorStandEntity getData() {
        Minecraft mc = Minecraft.func_71410_x();
        ArmorStandEntity stand = new ArmorStandEntity(EntityType.field_200789_c, (World)mc.field_71441_e);
        stand.func_70037_a(this.getNBT());
        return stand;
    }

    @Override
    public boolean isDefault() {
        return this.noGravity.isDefault() && this.marker.isDefault() && this.invisible.isDefault() && this.noBasePlate.isDefault() && this.showArms.isDefault() && this.small.isDefault() && this.pose.isDefault() && this.disabledSlots.isDefault() && super.isDefault();
    }

    @Override
    public CompoundNBT getNBT() {
        CompoundNBT nbt = new CompoundNBT();
        if (!this.marker.isDefault()) {
            nbt.func_218657_a("Marker", (INBT)this.marker.getNBT());
        }
        if (!this.invisible.isDefault()) {
            nbt.func_218657_a("Invisible", (INBT)this.invisible.getNBT());
        }
        if (!this.noBasePlate.isDefault()) {
            nbt.func_218657_a("NoBasePlate", (INBT)this.noBasePlate.getNBT());
        }
        if (!this.showArms.isDefault()) {
            nbt.func_218657_a("ShowArms", (INBT)this.showArms.getNBT());
        }
        if (!this.small.isDefault()) {
            nbt.func_218657_a("Small", (INBT)this.small.getNBT());
        }
        if (!this.noGravity.isDefault()) {
            nbt.func_218657_a("NoGravity", (INBT)this.noGravity.getNBT());
        }
        if (!this.pose.isDefault()) {
            nbt.func_218657_a("Pose", (INBT)this.pose.getNBT());
        }
        if (!this.disabledSlots.isDefault()) {
            nbt.func_218657_a("DisabledSlots", (INBT)this.disabledSlots.getNBT());
        }
        if (!super.isDefault()) {
            CompoundNBT sup = super.getNBT();
            nbt.func_197643_a(sup);
        }
        return nbt;
    }

    @Override
    public ITextComponent getPrettyDisplay(String space, int indentation) {
        IFormattableTextComponent iformattabletextcomponent1;
        boolean showHandItems;
        StringTextComponent iformattabletextcomponent = new StringTextComponent("{");
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n");
        }
        String marker = "Marker";
        String invisible = "Invisible";
        String noBasePlate = "NoBasePlate";
        String showArmsString = "ShowArms";
        String small = "Small";
        String noGravity = "NoGravity";
        String pose = "Pose";
        String disabledSlots = "DisabledSlots";
        String armorItems = "ArmorItems";
        String handItems = "HandItems";
        boolean showMarker = !this.getMarker().isDefault();
        boolean showInvisible = !this.getInvisible().isDefault();
        boolean showBasePlate = !this.getNoBasePlate().isDefault();
        boolean showArms = !this.getArmorItems().isDefault();
        boolean showSmall = !this.getSmall().isDefault();
        boolean showGravity = !this.getNoGravity().isDefault();
        boolean showPose = !this.getPose().isDefault();
        boolean showDisabledSlots = !this.getDisabledSlots().isDefault();
        boolean showArmorItems = !this.getArmorItems().isDefault();
        boolean bl = showHandItems = !this.getHandItems().isDefault();
        if (showMarker) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(marker)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getMarker().getPrettyDisplay(space, indentation + 1));
            if (showInvisible || showBasePlate || showArms || showSmall || showGravity || showPose || showDisabledSlots || showArmorItems || showHandItems) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showInvisible) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(invisible)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getInvisible().getPrettyDisplay(space, indentation + 1));
            if (showBasePlate || showArms || showSmall || showGravity || showPose || showDisabledSlots || showArmorItems || showHandItems) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showBasePlate) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(noBasePlate)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getNoBasePlate().getPrettyDisplay(space, indentation + 1));
            if (showArms || showSmall || showGravity || showPose || showDisabledSlots || showArmorItems || showHandItems) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showArms) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(showArmsString)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getShowArms().getPrettyDisplay(space, indentation + 1));
            if (showSmall || showGravity || showPose || showDisabledSlots || showArmorItems || showHandItems) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showSmall) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(small)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getSmall().getPrettyDisplay(space, indentation + 1));
            if (showGravity || showPose || showDisabledSlots || showArmorItems || showHandItems) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showGravity) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(noGravity)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getNoGravity().getPrettyDisplay(space, indentation + 1));
            if (showPose || showDisabledSlots || showArmorItems || showHandItems) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showPose) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(pose)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getPose().getPrettyDisplay(space, indentation + 1));
            if (showDisabledSlots || showArmorItems || showHandItems) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showDisabledSlots) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(disabledSlots)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getDisabledSlots().getPrettyDisplay(space, indentation + 1));
            if (showArmorItems || showHandItems) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showArmorItems) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(armorItems)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getArmorItems().getPrettyDisplay(space, indentation + 1));
            if (showHandItems) {
                iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
            }
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (showHandItems) {
            iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(handItems)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getHandItems().getPrettyDisplay(space, indentation + 1));
            iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
        }
        if (!space.isEmpty()) {
            iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)space, (int)indentation));
        }
        iformattabletextcomponent.func_240702_b_("}");
        return iformattabletextcomponent;
    }

    public DataBoolean getMarker() {
        return this.marker;
    }

    public DataBoolean getInvisible() {
        return this.invisible;
    }

    public DataBoolean getNoBasePlate() {
        return this.noBasePlate;
    }

    public DataBoolean getNoGravity() {
        return this.noGravity;
    }

    public DataBoolean getShowArms() {
        return this.showArms;
    }

    public DataBoolean getSmall() {
        return this.small;
    }

    public Pose getPose() {
        return this.pose;
    }

    public DataBitField getDisabledSlots() {
        return this.disabledSlots;
    }

    public static class Pose
    implements Data<Pose, CompoundNBT> {
        private DataRotation head;
        private DataRotation body;
        private DataRotation leftArm;
        private DataRotation rightArm;
        private DataRotation leftLeg;
        private DataRotation rightLeg;
        private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
        private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
        private static final Rotations DEFAULT_LEFTARM_ROTATION = new Rotations(350.0f, 0.0f, 350.0f);
        private static final Rotations DEFAULT_RIGHTARM_ROTATION = new Rotations(345.0f, 0.0f, 10.0f);
        private static final Rotations DEFAULT_LEFTLEG_ROTATION = new Rotations(359.0f, 0.0f, 359.0f);
        private static final Rotations DEFAULT_RIGHTLEG_ROTATION = new Rotations(1.0f, 0.0f, 1.0f);

        public Pose(CompoundNBT nbt) {
            this.head = this.getOrDefault(nbt, "Head", DEFAULT_HEAD_ROTATION);
            this.body = this.getOrDefault(nbt, "Body", DEFAULT_BODY_ROTATION);
            this.leftArm = this.getOrDefault(nbt, "LeftArm", DEFAULT_LEFTARM_ROTATION);
            this.rightArm = this.getOrDefault(nbt, "RightArm", DEFAULT_RIGHTARM_ROTATION);
            this.leftLeg = this.getOrDefault(nbt, "LeftLeg", DEFAULT_LEFTLEG_ROTATION);
            this.rightLeg = this.getOrDefault(nbt, "RightLeg", DEFAULT_RIGHTLEG_ROTATION);
        }

        public DataRotation getOrDefault(CompoundNBT nbt, String key, Rotations def) {
            if (nbt.func_150297_b(key, 9)) {
                return new DataRotation(nbt.func_150295_c(key, 5));
            }
            return new DataRotation(def);
        }

        @Override
        public Pose getData() {
            return this;
        }

        @Override
        public boolean isDefault() {
            return DEFAULT_HEAD_ROTATION.equals((Object)this.head.getData()) && DEFAULT_BODY_ROTATION.equals((Object)this.body.getData()) && DEFAULT_LEFTARM_ROTATION.equals((Object)this.leftArm.getData()) && DEFAULT_RIGHTARM_ROTATION.equals((Object)this.rightArm.getData()) && DEFAULT_LEFTLEG_ROTATION.equals((Object)this.leftLeg.getData()) && DEFAULT_RIGHTLEG_ROTATION.equals((Object)this.rightLeg.getData());
        }

        @Override
        public CompoundNBT getNBT() {
            CompoundNBT nbt = new CompoundNBT();
            if (!DEFAULT_HEAD_ROTATION.equals((Object)this.head.getData())) {
                nbt.func_218657_a("Head", (INBT)this.head.getNBT());
            }
            if (!DEFAULT_BODY_ROTATION.equals((Object)this.body.getData())) {
                nbt.func_218657_a("Body", (INBT)this.body.getNBT());
            }
            if (!DEFAULT_LEFTARM_ROTATION.equals((Object)this.leftArm.getData())) {
                nbt.func_218657_a("LeftArm", (INBT)this.leftArm.getNBT());
            }
            if (!DEFAULT_RIGHTARM_ROTATION.equals((Object)this.rightArm.getData())) {
                nbt.func_218657_a("RightArm", (INBT)this.rightArm.getNBT());
            }
            if (!DEFAULT_LEFTLEG_ROTATION.equals((Object)this.leftLeg.getData())) {
                nbt.func_218657_a("LeftLeg", (INBT)this.leftLeg.getNBT());
            }
            if (!DEFAULT_RIGHTLEG_ROTATION.equals((Object)this.rightLeg.getData())) {
                nbt.func_218657_a("RightLeg", (INBT)this.rightLeg.getNBT());
            }
            return nbt;
        }

        @Override
        public ITextComponent getPrettyDisplay(String space, int indentation) {
            IFormattableTextComponent iformattabletextcomponent1;
            boolean showRightLeg;
            StringTextComponent iformattabletextcomponent = new StringTextComponent("{");
            if (!space.isEmpty()) {
                iformattabletextcomponent.func_240702_b_("\n");
            }
            String head = "Head";
            String body = "Body";
            String leftArm = "LeftArm";
            String rightArm = "RightArm";
            String leftLeg = "LeftLeg";
            String rightLeg = "RightLeg";
            boolean showHead = !this.getHead().isDefault();
            boolean showBody = !this.getBody().isDefault();
            boolean showLeftArm = !this.getLeftArm().isDefault();
            boolean showRightArm = !this.getRightArm().isDefault();
            boolean showLeftLeg = !this.getLeftLeg().isDefault();
            boolean bl = showRightLeg = !this.getRightLeg().isDefault();
            if (showHead) {
                iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(head)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getHead().getPrettyDisplay(space, indentation + 1));
                if (showBody || showLeftArm || showRightArm || showLeftLeg || showRightLeg) {
                    iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
                }
                iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
            }
            if (showBody) {
                iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(body)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getBody().getPrettyDisplay(space, indentation + 1));
                if (showLeftArm || showRightArm || showLeftLeg || showRightLeg) {
                    iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
                }
                iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
            }
            if (showLeftArm) {
                iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(leftArm)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getLeftArm().getPrettyDisplay(space, indentation + 1));
                if (showRightArm || showLeftLeg || showRightLeg) {
                    iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
                }
                iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
            }
            if (showRightArm) {
                iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(rightArm)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getRightArm().getPrettyDisplay(space, indentation + 1));
                if (showLeftLeg || showRightLeg) {
                    iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
                }
                iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
            }
            if (showLeftLeg) {
                iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(leftLeg)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getLeftLeg().getPrettyDisplay(space, indentation + 1));
                if (showRightLeg) {
                    iformattabletextcomponent1.func_240702_b_(String.valueOf(',')).func_240702_b_(space.isEmpty() ? " " : "\n");
                }
                iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
            }
            if (showRightLeg) {
                iformattabletextcomponent1 = new StringTextComponent(Strings.repeat((String)space, (int)(indentation + 1))).func_230529_a_(DataMap.handleEscapePretty(rightLeg)).func_240702_b_(String.valueOf(':')).func_240702_b_(" ").func_230529_a_(this.getRightLeg().getPrettyDisplay(space, indentation + 1));
                iformattabletextcomponent.func_230529_a_((ITextComponent)iformattabletextcomponent1);
            }
            if (!space.isEmpty()) {
                iformattabletextcomponent.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)space, (int)indentation));
            }
            iformattabletextcomponent.func_240702_b_("}");
            return iformattabletextcomponent;
        }

        public void reset() {
            this.head = new DataRotation(DEFAULT_HEAD_ROTATION);
            this.body = new DataRotation(DEFAULT_BODY_ROTATION);
            this.rightArm = new DataRotation(DEFAULT_RIGHTARM_ROTATION);
            this.leftArm = new DataRotation(DEFAULT_LEFTARM_ROTATION);
            this.rightLeg = new DataRotation(DEFAULT_RIGHTLEG_ROTATION);
            this.leftLeg = new DataRotation(DEFAULT_LEFTLEG_ROTATION);
        }

        public void applyToArmorStand(ArmorStandEntity stand) {
            stand.func_175415_a(this.head.getData());
            stand.func_175424_b(this.body.getData());
            stand.func_175405_c(this.leftArm.getData());
            stand.func_175428_d(this.rightArm.getData());
            stand.func_175417_e(this.leftLeg.getData());
            stand.func_175427_f(this.rightLeg.getData());
        }

        public DataRotation getHead() {
            return this.head;
        }

        public DataRotation getBody() {
            return this.body;
        }

        public DataRotation getLeftArm() {
            return this.leftArm;
        }

        public DataRotation getRightArm() {
            return this.rightArm;
        }

        public DataRotation getLeftLeg() {
            return this.leftLeg;
        }

        public DataRotation getRightLeg() {
            return this.rightLeg;
        }
    }
}

