/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.events;

import infinityitemeditor.InfinityItemEditor;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.screen.HeadCollectionScreen;
import infinityitemeditor.screen.MainScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.Hand;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class KeyInputHandler {
    private static KeyBinding OPEN_EDITOR_KEY;
    private static KeyBinding OFF_HAND_SWING;
    public static KeyBinding HEAD_COLLECTION;
    public static KeyBinding BARRIER_TOGGLE;
    private static KeyBinding DEBUG_KEY;

    public static void init() {
        InfinityItemEditor.LOGGER.info("Initializing keybindings");
        OPEN_EDITOR_KEY = KeyInputHandler.registerKeybind("editor", 85);
        OFF_HAND_SWING = KeyInputHandler.registerKeybind("offhandswing", InputMappings.field_197958_a.func_197937_c());
        HEAD_COLLECTION = KeyInputHandler.registerKeybind("headcollection", 86);
        BARRIER_TOGGLE = KeyInputHandler.registerKeybind("barriertoggle", 66);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)292)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || event.getAction() != 1 || mc.field_71462_r != null && !(mc.field_71462_r instanceof ContainerScreen)) {
            return;
        }
        if (event.getKey() == OPEN_EDITOR_KEY.getKey().func_197937_c()) {
            assert (mc.field_71439_g != null);
            mc.func_147108_a((Screen)new MainScreen(mc.field_71462_r, new DataItem(mc.field_71439_g.func_184614_ca())));
        } else if (event.getKey() == OFF_HAND_SWING.getKey().func_197937_c()) {
            assert (mc.field_71439_g != null);
            mc.field_71439_g.func_184609_a(Hand.OFF_HAND);
        } else if (event.getKey() == HEAD_COLLECTION.getKey().func_197937_c()) {
            mc.func_147108_a((Screen)new HeadCollectionScreen(mc.field_71462_r));
        } else if (event.getKey() == BARRIER_TOGGLE.getKey().func_197937_c()) {
            InfinityItemEditor.BARRIER_VISIBLE = !InfinityItemEditor.BARRIER_VISIBLE;
            mc.field_71438_f.func_72712_a();
        }
    }

    private static KeyBinding registerKeybind(String name, int keyCode) {
        KeyBinding key = new KeyBinding("key." + name, keyCode, "Infinity Item Editor");
        ClientRegistry.registerKeyBinding((KeyBinding)key);
        return key;
    }
}

