/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.json;

import com.mojang.authlib.GameProfile;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.json.MinecraftHeadsResponse;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CachedHead {
    private final MinecraftHeadsResponse data;
    private boolean skinLoaded = false;
    private final ResourceLocation skin = null;

    public CachedHead(MinecraftHeadsResponse data) {
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTexture() {
        if (this.skinLoaded) {
            return;
        }
        CachedHead cachedHead = this;
        synchronized (cachedHead) {
            if (!this.skinLoaded) {
                this.skinLoaded = true;
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152342_ad().func_152790_a(this.data.getGameProfile(), null, false);
            }
        }
    }

    public ItemStack getItemStack() {
        ItemStack head = new ItemStack((IItemProvider)Items.field_196184_dx);
        head.func_190925_c("display").func_74778_a("Name", this.data.getName());
        NBTUtil.func_180708_a((CompoundNBT)head.func_190925_c("SkullOwner"), (GameProfile)this.data.getGameProfile());
        return head;
    }

    public DataItem getItem() {
        DataItem head = new DataItem(new ItemStack((IItemProvider)Items.field_196184_dx));
        head.getDisplayNameTag().set(this.data.getName());
        head.getTag().getSkullOwner().set(this.data);
        return head;
    }

    public MinecraftHeadsResponse getData() {
        return this.data;
    }

    public boolean isSkinLoaded() {
        return this.skinLoaded;
    }

    public ResourceLocation getSkin() {
        return this.skin;
    }
}

