/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.base.DataRotation;
import infinityitemeditor.data.tag.entity.TagEntityArmorStand;
import infinityitemeditor.screen.ArmorStandEquipScreen;
import infinityitemeditor.screen.ArmorstandPropScreen;
import infinityitemeditor.screen.BaseArmorstandScreen;
import infinityitemeditor.screen.widgets.SliderTag;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ArmorstandScreen
extends BaseArmorstandScreen {
    private final int buttonWidth = 80;
    private final int buttonHeight = 15;
    private final int divideX = 120;
    private final int divideY = 7;

    public ArmorstandScreen(Screen lastScreen, DataItem item) {
        super((ITextComponent)new TranslationTextComponent("gui.armorstandeditor"), lastScreen, item);
        this.renderItem = false;
    }

    @Override
    protected void postInit() {
        super.func_231160_c_();
        int x1 = this.field_230708_k_ / 120;
        int y1 = this.field_230709_l_ / 7;
        TagEntityArmorStand.Pose pose = item.getTag().getArmorStandTag().getPose();
        this.addSliders(x1, y1, pose.getHead());
        this.addSliders(x1, y1 += 22, pose.getBody());
        y1 += 22;
        if (((Boolean)item.getTag().getArmorStandTag().getShowArms().get()).booleanValue()) {
            this.addSliders(x1, y1, pose.getRightArm());
            this.addSliders(x1, y1 += 22, pose.getLeftArm());
            y1 += 22;
        }
        this.addSliders(x1, y1, pose.getRightLeg());
        this.addSliders(x1, y1 += 22, pose.getLeftLeg());
        int butWidth = 130;
        this.func_230480_a_((Widget)new StyledButton(x1 + 26, y1 += 30, butWidth, 18, I18n.func_135052_a((String)"gui.armorstandeditor.properties", (Object[])new Object[0]), t -> this.field_230706_i_.func_147108_a((Screen)new ArmorstandPropScreen(this, item))));
        this.func_230480_a_((Widget)new StyledButton(x1 + 26 + butWidth + 5, y1, butWidth, 18, I18n.func_135052_a((String)"gui.armorstandeditor.equipment", (Object[])new Object[0]), t -> this.field_230706_i_.func_147108_a((Screen)new ArmorStandEquipScreen(this, item.getTag().getArmorStandTag()))));
    }

    public void addSliders(int posX, int posY, DataRotation rot) {
        this.func_230480_a_(new SliderTag(posX + 85, posY, 80, 15, rot.getX()));
        this.func_230480_a_(new SliderTag(posX + 170, posY, 80, 15, rot.getY()));
        this.func_230480_a_(new SliderTag(posX + 255, posY, 80, 15, rot.getZ()));
    }

    @Override
    public void reset(Widget w) {
        item.getTag().getArmorStandTag().getPose().reset();
    }

    @Override
    public void backRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        drawArmor.updateArmorStand();
        super.backRender(matrix, mouseX, mouseY, p3, color);
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        int x1 = this.field_230708_k_ / 120;
        int y1 = this.field_230709_l_ / 7;
        boolean arms = (Boolean)item.getTag().getArmorStandTag().getShowArms().get();
        for (BODY_PARTS s : BODY_PARTS.values()) {
            if (!arms && (s == BODY_PARTS.LEFTARM || s == BODY_PARTS.RIGHTARM)) continue;
            ArmorstandScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)("gui.armorstandeditor." + s.toString().toLowerCase()), (Object[])new Object[0]), (int)(x1 + 52), (int)(y1 + 3), (int)color.getInt());
            y1 += 22;
        }
        super.mainRender(matrix, mouseX, mouseY, p3, color);
    }

    @Override
    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.overlayRender(matrix, mouseX, mouseY, p3, color);
        GuiUtil.addToolTip(matrix, (Screen)this, (Widget)this.resetButton, mouseX, mouseY, I18n.func_135052_a((String)"gui.armorstandeditor.reset", (Object[])new Object[0]));
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        super.func_231048_c_(p_mouseReleased_1_, p_mouseReleased_3_, p_mouseReleased_5_);
        ArmorstandScreen.drawArmor.addRotation = 0;
        return true;
    }

    public static enum BODY_PARTS {
        HEAD,
        BODY,
        RIGHTARM,
        LEFTARM,
        RIGHTLEG,
        LEFTLEG;

    }
}

