/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.tag.TagEnchantment;
import infinityitemeditor.data.tag.TagList;
import infinityitemeditor.screen.ParentScreen;
import infinityitemeditor.screen.widgets.NumberField;
import infinityitemeditor.screen.widgets.ScrollableScissorWindow;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.screen.widgets.StyledTextButton;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentScreen
extends ParentScreen {
    protected TagList<TagEnchantment> enchantmentsTag;
    private ScrollableScissorWindow list;
    private ScrollableScissorWindow added;
    private NumberField level;
    private TagEnchantment selected = null;
    private StyledButton selectedButton = null;
    protected List<Widget> selectedWidgets = Lists.newArrayList();

    public EnchantmentScreen(Screen lastScreen, TagList<TagEnchantment> enchantmentsTag) {
        super((ITextComponent)new TranslationTextComponent("gui.enchantment"), lastScreen);
        this.enchantmentsTag = enchantmentsTag;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        ArrayList sortedEnchants = Lists.newArrayList((Iterable)ForgeRegistries.ENCHANTMENTS);
        sortedEnchants.sort(new EnchantComparator());
        int yStart = 85;
        int yEnd = this.field_230709_l_ - yStart - 10;
        int containerWidth = this.field_230708_k_ / 3 - 10;
        String backString = I18n.func_135052_a((String)"gui.main.back", (Object[])new Object[0]);
        int backWidth = this.field_230712_o_.func_78256_a(backString);
        this.func_230480_a_((Widget)new StyledTextButton(10 + backWidth / 2, 15, backWidth, backString, b -> this.field_230706_i_.func_147108_a(this.lastScreen)));
        this.list = (ScrollableScissorWindow)this.func_230480_a_(new ScrollableScissorWindow(10, yStart, containerWidth, yEnd, (ITextComponent)new TranslationTextComponent("gui.enchantment.all")));
        for (Enchantment ench : sortedEnchants) {
            StyledButton button = new StyledButton(0, 0, 50, 20, ench.func_200305_d(this.getLevel(ench)).getString(), b -> {
                TagEnchantment tag = new TagEnchantment(ench, this.getLevel(ench));
                this.enchantmentsTag.add(tag);
                this.addEnchantment(tag);
            });
            if (ench.getRegistryName() != null) {
                button.setTooltip(ench.getRegistryName().toString());
            }
            this.list.getWidgets().add((Widget)button);
        }
        this.added = (ScrollableScissorWindow)this.func_230480_a_(new ScrollableScissorWindow(this.field_230708_k_ / 3 + 5, yStart, containerWidth, yEnd, (ITextComponent)new TranslationTextComponent("gui.enchantment.applied")));
        for (TagEnchantment tag : this.enchantmentsTag) {
            this.addEnchantment(tag);
        }
        this.initSelectedWidgets();
    }

    public void setSelected(TagEnchantment selected, StyledButton selectedButton) {
        Enchantment ench;
        if (this.selectedButton != null && this.selectedButton.getTooltip() != null && this.selected != null && (ench = this.getEnchantmentFromResourceString(this.selectedButton.getTooltip())) != null) {
            this.selectedButton.func_238482_a_(this.selected.getEnchantment().func_200305_d(((Integer)this.selected.getLevel().get()).intValue()));
        }
        this.selected = selected;
        this.selectedButton = selectedButton;
        if (selected != null && selectedButton != null) {
            this.selectedButton.func_238482_a_((ITextComponent)new TranslationTextComponent("gui.enchantment.selected", new Object[]{selected.getEnchantment().func_200305_d(((Integer)selected.getLevel().get()).intValue())}));
        }
        this.initSelectedWidgets();
    }

    public void initSelectedWidgets() {
        for (Widget w : this.selectedWidgets) {
            this.field_230710_m_.remove(w);
            this.field_230705_e_.remove(w);
        }
        this.selectedWidgets.clear();
        if (this.selected == null) {
            return;
        }
        int xStart = (this.field_230708_k_ / 3 - 10) * 2 + 20;
        int yStart = 85;
        int eWidth = this.field_230708_k_ / 3 - 10;
        this.selectedWidgets.add(this.func_230480_a_((Widget)new StyledButton(xStart, yStart, eWidth, 20, I18n.func_135052_a((String)"gui.enchantment.duplicate", (Object[])new Object[0]), b -> this.duplicateSelected())));
        this.selectedWidgets.add(this.func_230480_a_((Widget)new StyledButton(xStart, yStart + 25, eWidth, 20, I18n.func_135052_a((String)"gui.enchantment.remove", (Object[])new Object[0]), b -> this.removeSelected())));
        this.selectedWidgets.add(this.func_230480_a_(new NumberField(this.field_230712_o_, xStart + eWidth / 2, yStart + 50, 20, this.selected.getLevel())));
    }

    public void removeSelected() {
        if (this.selectedButton != null) {
            this.added.getWidgets().remove(this.selectedButton);
            this.selectedButton = null;
        }
        if (this.selected != null) {
            this.enchantmentsTag.remove(this.selected);
            this.selected = null;
        }
        this.initSelectedWidgets();
    }

    public void duplicateSelected() {
        TagEnchantment tag = new TagEnchantment(this.selected.getEnchantment(), this.selected.getLevel());
        this.enchantmentsTag.add(tag);
        this.addEnchantment(tag);
    }

    public void addEnchantment(TagEnchantment tag) {
        StyledButton button = new StyledButton(0, 0, 50, 20, tag.getEnchantment().func_200305_d(((Integer)tag.getLevel().get()).intValue()).getString(), b -> {
            this.setSelected(tag, (StyledButton)b);
            if (EnchantmentScreen.func_231172_r_()) {
                this.removeSelected();
            }
        });
        if (tag.getEnchantment().getRegistryName() != null) {
            button.setTooltip(tag.getEnchantment().getRegistryName().toString());
        }
        this.added.getWidgets().add((Widget)button);
        this.setSelected(tag, button);
    }

    public int getLevel(Enchantment ench) {
        return ench.func_77325_b();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public void backRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, ColorUtils.Color color) {
        super.backRender(matrix, mouseX, mouseY, partialTicks, color);
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, ColorUtils.Color color) {
        super.mainRender(matrix, mouseX, mouseY, partialTicks, color);
        EnchantmentScreen.func_238475_b_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)this.list.func_230458_i_(), (int)this.list.field_230690_l_, (int)(this.list.field_230691_m_ - 10), (int)color.getInt());
        EnchantmentScreen.func_238475_b_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)this.added.func_230458_i_(), (int)this.added.field_230690_l_, (int)(this.added.field_230691_m_ - 10), (int)color.getInt());
    }

    @Override
    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, ColorUtils.Color color) {
        StyledButton b;
        String tooltip;
        super.overlayRender(matrix, mouseX, mouseY, partialTicks, color);
        if (!this.list.isScrolling() && GuiUtil.isMouseIn(mouseX, mouseY, this.list.field_230690_l_, this.list.field_230691_m_, this.list.func_230998_h_(), this.list.func_238483_d_())) {
            for (Widget w : this.list.getWidgets()) {
                Enchantment ench;
                if (!(w instanceof StyledButton) || (tooltip = (b = (StyledButton)w).getTooltip()) == null || (ench = this.getEnchantmentFromResourceString(tooltip)) == null || !w.func_230449_g_()) continue;
                this.drawTooltip(matrix, mouseX, mouseY, ench);
            }
        }
        if (!this.added.isScrolling() && GuiUtil.isMouseIn(mouseX, mouseY, this.added.field_230690_l_, this.added.field_230691_m_, this.added.func_230998_h_(), this.added.func_238483_d_())) {
            for (Widget w : this.added.getWidgets()) {
                if (!(w instanceof StyledButton) || (tooltip = (b = (StyledButton)w).getTooltip()) == null) continue;
                ResourceLocation loc = new ResourceLocation(tooltip);
                Enchantment ench = (Enchantment)GameRegistry.findRegistry(Enchantment.class).getValue(loc);
                if (ench == null || !w.func_230449_g_()) continue;
                this.drawTooltip(matrix, mouseX, mouseY, ench);
            }
        }
        if (this.selected != null) {
            int xStart = (this.field_230708_k_ / 3 - 10) * 2 + 20;
            int eWidth = this.field_230708_k_ / 3 - 10;
            int textWidth = this.field_230712_o_.func_78256_a(I18n.func_135052_a((String)"gui.enchantment.level", (Object[])new Object[0]));
            EnchantmentScreen.func_238475_b_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (ITextComponent)new TranslationTextComponent("gui.enchantment.level"), (int)(xStart + eWidth / 2 - 3 - textWidth), (int)141, (int)color.getInt());
        }
    }

    void drawTooltip(MatrixStack matrix, int x, int y, Enchantment ench) {
        String name = I18n.func_135052_a((String)ench.func_77320_a(), (Object[])new Object[0]);
        String rarity = I18n.func_135052_a((String)("gui.enchantment.rarity." + ench.func_77324_c().toString().toLowerCase()), (Object[])new Object[0]);
        String rarityLine = I18n.func_135052_a((String)"gui.enchantment.tooltip.rarity", (Object[])new Object[]{rarity});
        String minLevel = I18n.func_135052_a((String)"gui.enchantment.tooltip.minlevel", (Object[])new Object[]{ench.func_77319_d()});
        String maxLevel = I18n.func_135052_a((String)"gui.enchantment.tooltip.maxlevel", (Object[])new Object[]{ench.func_77325_b()});
        String typeLine = I18n.func_135052_a((String)"gui.enchantment.tooltip.type", (Object[])new Object[]{ench.field_77351_y != null ? ench.field_77351_y.toString().toLowerCase() : "N/A"});
        String descKey = ench.func_77320_a() + ".desc";
        if (!I18n.func_188566_a((String)descKey)) {
            GuiUtil.addToolTip(matrix, (Screen)this, x, y, name, rarityLine, minLevel, maxLevel, typeLine);
        } else {
            String descLine = I18n.func_135052_a((String)descKey, (Object[])new Object[0]);
            GuiUtil.addToolTip(matrix, (Screen)this, x, y, name, rarityLine, minLevel, maxLevel, typeLine, descLine);
        }
    }

    Enchantment getEnchantmentFromResourceString(String resource) {
        ResourceLocation loc = new ResourceLocation(resource);
        return (Enchantment)GameRegistry.findRegistry(Enchantment.class).getValue(loc);
    }

    public static class EnchantComparator
    implements Comparator<Enchantment> {
        @Override
        public int compare(Enchantment o1, Enchantment o2) {
            return I18n.func_135052_a((String)o1.func_77320_a(), (Object[])new Object[0]).compareTo(I18n.func_135052_a((String)o2.func_77320_a(), (Object[])new Object[0]));
        }
    }

    private static enum Filter {
        ALL,
        APPLICABLE;

    }

    private static enum LevelLimit {
        SURVIVAL,
        SHORT,
        INTEGER;

    }
}

