/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.base.DataString;
import infinityitemeditor.screen.ParentItemScreen;
import infinityitemeditor.screen.widgets.LoreWidget;
import infinityitemeditor.screen.widgets.ScrollableScissorWindow;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.util.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LoreEditorScreen
extends ParentItemScreen {
    private ScrollableScissorWindow scrollWindow;
    public ArrayList<LoreWidget> loreLines = new ArrayList();
    private final int buttonWidth = 50;
    private final int distanceFromScroll = 10;
    private int scrollWidth;

    public LoreEditorScreen(Screen lastScreen, DataItem editing) {
        super((ITextComponent)new TranslationTextComponent("gui.loreeditor"), lastScreen, editing);
    }

    @Override
    protected void func_231160_c_() {
        this.renderColorHelper = true;
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.setRenderItem(true, 1.0f, 10);
        this.scrollWidth = this.field_230708_k_ / 6 * 4;
        int xScroll = (this.field_230708_k_ - this.scrollWidth) / 2;
        this.scrollWindow = (ScrollableScissorWindow)this.func_230480_a_(new ScrollableScissorWindow(xScroll, this.field_230709_l_ / 4, this.scrollWidth, this.field_230709_l_ / 4 * 2, (ITextComponent)new StringTextComponent("Lores")));
        int scrollTop = this.field_230709_l_ / 4;
        this.func_230480_a_((Widget)new StyledButton(xScroll - 50 - 10, scrollTop, 50, 20, I18n.func_135052_a((String)"gui.loreeditor.addline", (Object[])new Object[0]), t -> this.addLine()));
        this.func_230480_a_((Widget)new StyledButton(xScroll - 50 - 10, scrollTop + 25, 50, 20, I18n.func_135052_a((String)"gui.loreeditor.copy", (Object[])new Object[0]), t -> this.copyLoreToClipboard()));
        this.loreLines.clear();
        List l = (List)item.getTag().getDisplay().getLore().get();
        for (int i = 0; i < l.size(); ++i) {
            String loreText = "";
            IFormattableTextComponent textFromJson = ITextComponent.Serializer.func_240643_a_((String)((String)((DataString)l.get(i)).get()));
            if (textFromJson != null) {
                loreText = textFromJson.getString();
            }
            this.loreLines.add(new LoreWidget(i + 1, this.scrollWidth, this.field_230712_o_, this, loreText));
        }
        this.scrollWindow.getWidgets().addAll(this.loreLines);
        this.func_212928_a((IGuiEventListener)this.scrollWindow);
    }

    private void copyLoreToClipboard() {
        ArrayList<String> loreList = new ArrayList<String>();
        for (LoreWidget widget : this.loreLines) {
            String text = widget.field.getText();
            if (text.isEmpty()) {
                text = " ";
            }
            loreList.add(text);
        }
        this.field_230706_i_.field_195559_v.func_197960_a(String.join((CharSequence)"\n", loreList));
    }

    private void updateLines() {
        this.applyLoreToItem();
        this.scrollWindow.getWidgets().clear();
        for (int i = 0; i < this.loreLines.size(); ++i) {
            this.scrollWindow.getWidgets().add(this.loreLines.get(i).updateCount(i + 1));
        }
    }

    private void addLine() {
        this.addLine(this.loreLines.size());
    }

    private void addLine(int i) {
        this.loreLines.add(i, new LoreWidget(this.scrollWindow.getWidgets().size() + 1, this.scrollWidth, this.field_230706_i_.field_71466_p, this));
        this.updateLines();
    }

    public void removeLine(LoreWidget widget) {
        this.loreLines.remove((Object)widget);
        this.updateLines();
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.mainRender(matrix, mouseX, mouseY, p3, color);
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.loreLines.forEach(t -> t.field.tick());
    }

    public boolean func_223281_a_(int p_223281_1_, int p_223281_2_, int p_223281_3_) {
        this.applyLoreToItem();
        return super.func_223281_a_(p_223281_1_, p_223281_2_, p_223281_3_);
    }

    private void applyLoreToItem() {
        item.getTag().getDisplay().getLore().clear();
        for (LoreWidget widget : this.loreLines) {
            String text = widget.field.getText();
            if (text.isEmpty()) {
                text = "";
            }
            item.getTag().getDisplay().getLore().add(new DataString(ITextComponent.Serializer.func_150696_a((ITextComponent)new StringTextComponent(text))));
        }
    }

    @Override
    public void reset(Widget w) {
        item.getTag().getDisplay().getLore().clear();
        this.func_231160_c_();
    }

    public void moveUp(LoreWidget w) {
        int i = this.loreLines.indexOf((Object)w);
        this.loreLines.remove((Object)w);
        this.loreLines.add(i > 0 ? i - 1 : this.loreLines.size(), w);
        this.updateLines();
    }

    public void moveDown(LoreWidget w) {
        int i = this.loreLines.indexOf((Object)w);
        int size = this.loreLines.size();
        this.loreLines.remove((Object)w);
        this.loreLines.add(i < size - 1 ? i + 1 : 0, w);
        this.updateLines();
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (!this.isInColorWidget((int)mouseX, (int)mouseY)) {
            this.loreLines.forEach(t -> t.setFocusField(false));
        }
        this.applyLoreToItem();
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    private LoreWidget getFocusedLoreWidget() {
        for (LoreWidget w : this.loreLines) {
            if (!w.func_230999_j_()) continue;
            return w;
        }
        return null;
    }

    @Override
    public boolean func_231046_a_(int key1, int key2, int key3) {
        String clip;
        if (key2 == 47 && key3 == 2 && !(clip = this.field_230706_i_.field_195559_v.func_197965_a()).isEmpty() && this.getFocusedLoreWidget() == null) {
            String[] lines = new String[]{clip};
            if (clip.contains("\n")) {
                lines = clip.split("\n");
            }
            for (int i = 0; i < lines.length; ++i) {
                this.loreLines.add(new LoreWidget(i + 1, this.scrollWidth, this.field_230712_o_, this, lines[i]));
                this.updateLines();
            }
            return true;
        }
        if ((key1 == 258 || key1 == 264 || key1 == 265) && this.handleArrowsAndTab(key1 == 265)) {
            return true;
        }
        if (key2 == 28 && this.getFocusedLoreWidget() != null) {
            LoreWidget loreWidget = this.getFocusedLoreWidget();
            this.addLine(loreWidget.getCount());
            this.handleArrowsAndTab(false);
        }
        return super.func_231046_a_(key1, key2, key3);
    }

    private boolean handleArrowsAndTab(boolean goesDown) {
        if (this.getFocusedLoreWidget() != null) {
            LoreWidget focused = this.getFocusedLoreWidget();
            focused.setFocusField(false);
            int i = focused.getCount() - 1;
            int get = goesDown ? (i - 1 >= 0 ? i - 1 : this.loreLines.size() - 1) : (i + 1 < this.loreLines.size() ? i + 1 : 0);
            LoreWidget lw = this.loreLines.get(get);
            lw.setFocusField(true);
            this.scrollWindow.func_231035_a_((IGuiEventListener)lw);
            return true;
        }
        return false;
    }

    @Override
    public void func_231175_as__() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        super.func_231175_as__();
    }

    public boolean func_231049_c__(boolean p_231049_1_) {
        return false;
    }
}

