/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import infinityitemeditor.config.Config;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.NumberRangeInt;
import infinityitemeditor.screen.ColorScreen;
import infinityitemeditor.screen.FlagScreen;
import infinityitemeditor.screen.HeadCollectionScreen;
import infinityitemeditor.screen.LoreEditorScreen;
import infinityitemeditor.screen.ParentItemScreen;
import infinityitemeditor.screen.widgets.ClassSpecificWidget;
import infinityitemeditor.screen.widgets.NumberField;
import infinityitemeditor.screen.widgets.SliderTag;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.screen.widgets.StyledDataTextField;
import infinityitemeditor.screen.widgets.StyledTextButton;
import infinityitemeditor.screen.widgets.StyledToggle;
import infinityitemeditor.screen.widgets.WidgetInfo;
import infinityitemeditor.screen.widgets.base.AdvancedWidgets;
import infinityitemeditor.screen.widgets.base.ItemWidgets;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.ItemRendererUtils;
import infinityitemeditor.util.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class MainScreen
extends ParentItemScreen {
    private final ArrayList<Widget> toolsWidgets = new ArrayList();
    private final ArrayList<Widget> displayWidgets = new ArrayList();
    private final ArrayList<Widget> editWidgets = new ArrayList();
    private final ArrayList<Widget> advancedWidgets = new ArrayList();
    private StyledTextButton nbtButton;
    private StyledTextButton tooltipButton;
    private StyledTextButton toolsButton;
    private StyledTextButton displayButton;
    private StyledTextButton editButton;
    private StyledTextButton advancedButton;
    private StyledTextButton loreButton;
    private NumberField countField;
    private NumberField damageField;
    private StyledDataTextField idField;
    private SliderTag countSlider;
    private SliderTag damageSlider;
    private StyledToggle unbreakable;
    private StyledTextButton styleButton;
    private StyledDataTextField nameField;
    private StyledTextButton clearButton;

    public MainScreen(Screen lastScreen, DataItem editing) {
        super((ITextComponent)new TranslationTextComponent("gui.main"), lastScreen, editing);
    }

    protected void loadWidgets() {
        this.editWidgets.clear();
        this.advancedWidgets.clear();
        this.loadWidgets(new ItemWidgets(), this.editWidgets);
        this.loadWidgets(new AdvancedWidgets(), this.advancedWidgets);
    }

    @Override
    protected void func_231160_c_() {
        this.renderColorHelper = true;
        super.func_231160_c_();
        if ((Integer)item.getCount().get() < 1) {
            item.getCount().set(1);
        }
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        String nbtLocal = I18n.func_135052_a((String)"gui.main.nbt", (Object[])new Object[0]);
        String tooltipLocal = I18n.func_135052_a((String)"gui.main.tooltip", (Object[])new Object[0]);
        String toolsLocal = I18n.func_135052_a((String)"gui.main.tools", (Object[])new Object[0]);
        String displayLocal = I18n.func_135052_a((String)"gui.main.display", (Object[])new Object[0]);
        String editLocal = I18n.func_135052_a((String)"gui.main.data", (Object[])new Object[0]);
        String advancedLocal = I18n.func_135052_a((String)"gui.main.other", (Object[])new Object[0]);
        int nbtWidth = this.field_230712_o_.func_78256_a(nbtLocal);
        int tooltipWidth = this.field_230712_o_.func_78256_a(tooltipLocal);
        int toolsWidth = this.field_230712_o_.func_78256_a(toolsLocal);
        int displayWidth = this.field_230712_o_.func_78256_a(displayLocal);
        int editWidth = this.field_230712_o_.func_78256_a(editLocal);
        int advancedWidth = this.field_230712_o_.func_78256_a(advancedLocal);
        int nbtX = 21 + nbtWidth / 2;
        int toolsX = this.field_230708_k_ / 3 - 16 - toolsWidth / 2;
        int tooltipX = (nbtX + toolsX) / 2;
        int advancedX = this.field_230708_k_ - 21 - advancedWidth / 2;
        int loreX = 2 * this.field_230708_k_ / 3 + 17 + displayWidth / 2;
        int editX = (loreX + displayWidth / 2 + (advancedX - advancedWidth / 2)) / 2;
        int buttonY = 35;
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.toolsWidgets.clear();
        this.displayWidgets.clear();
        this.nbtButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(nbtX, buttonY, nbtWidth, nbtLocal, b -> this.setLeftTab(0, true)));
        this.tooltipButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(tooltipX, buttonY, tooltipWidth, tooltipLocal, b -> this.setLeftTab(1, true)));
        this.toolsButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(toolsX, buttonY, toolsWidth, toolsLocal, b -> {
            this.setLeftTab(2, true);
            for (Widget tool : this.toolsWidgets) {
                tool.field_230694_p_ = true;
            }
        }));
        this.displayButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(loreX, buttonY, displayWidth, displayLocal, b -> {
            this.setRightTab(0, true);
            for (Widget lore : this.displayWidgets) {
                lore.field_230694_p_ = true;
            }
        }));
        this.editButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(editX, buttonY, editWidth, editLocal, b -> {
            this.setRightTab(1, true);
            for (Widget lore : this.displayWidgets) {
                lore.field_230694_p_ = false;
            }
        }));
        this.advancedButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(advancedX, buttonY, advancedWidth, advancedLocal, b -> {
            this.setRightTab(2, true);
            for (Widget lore : this.displayWidgets) {
                lore.field_230694_p_ = false;
            }
        }));
        this.loadWidgets();
        int toolIndex = 0;
        String styleLocal = I18n.func_135052_a((String)"gui.main.style", (Object[])new Object[0]);
        this.styleButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(this.field_230708_k_ / 6, buttonY + 20 * ++toolIndex, this.field_230712_o_.func_78256_a(styleLocal), styleLocal, b -> StyleManager.setNext()));
        this.toolsWidgets.add((Widget)this.styleButton);
        String headsLocal = I18n.func_135052_a((String)"gui.headcollection", (Object[])new Object[0]);
        StyledTextButton headsButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(this.field_230708_k_ / 6, buttonY + 20 * ++toolIndex, this.field_230712_o_.func_78256_a(headsLocal), headsLocal, b -> this.field_230706_i_.func_147108_a((Screen)new HeadCollectionScreen(this))));
        this.toolsWidgets.add((Widget)headsButton);
        int nameX = 2 * this.field_230708_k_ / 3 + 16;
        String resetLore = I18n.func_135052_a((String)"gui.main.resetlore", (Object[])new Object[0]);
        int resetWidth = this.field_230712_o_.func_78256_a(resetLore);
        int resetX = this.field_230708_k_ - 22 - resetWidth / 2;
        String lore = I18n.func_135052_a((String)"gui.loreeditor", (Object[])new Object[0]);
        int loreWidth = this.field_230712_o_.func_78256_a(lore);
        String itemFlag = I18n.func_135052_a((String)"gui.itemflag", (Object[])new Object[0]);
        int itemFlagWidth = this.field_230712_o_.func_78256_a(itemFlag);
        String color = I18n.func_135052_a((String)"gui.color", (Object[])new Object[0]);
        int colorWidth = this.field_230712_o_.func_78256_a(color);
        this.nameField = new StyledDataTextField(this.field_230712_o_, nameX, 55, resetX - nameX - resetWidth / 2 - 7, 20, item.getDisplayNameTag());
        this.renderWidgets.add(this.nameField);
        this.displayWidgets.add(this.nameField);
        this.field_230705_e_.add(this.nameField);
        this.clearButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(resetX, 67, resetWidth, resetLore, b -> {
            this.nameField.setText(item.getDisplayNameTag().getDefault().getString());
            this.nameField.setCursorPos(0);
            this.nameField.setSelectionPos(0);
        }));
        this.displayWidgets.add((Widget)this.clearButton);
        this.loreButton = (StyledTextButton)this.func_230480_a_((Widget)new StyledTextButton(nameX + loreWidth / 2, 95, loreWidth, lore, t -> this.field_230706_i_.func_147108_a((Screen)new LoreEditorScreen(this, item))));
        this.displayWidgets.add((Widget)this.loreButton);
        StyledButton flagsButton = (StyledButton)this.func_230480_a_((Widget)new StyledTextButton(nameX + itemFlagWidth / 2, 115, itemFlagWidth, itemFlag, t -> this.field_230706_i_.func_147108_a((Screen)new FlagScreen(this, item))));
        this.displayWidgets.add((Widget)flagsButton);
        StyledButton colorButton = (StyledButton)this.func_230480_a_((Widget)new StyledTextButton(nameX + colorWidth / 2, 135, colorWidth, color, t -> this.field_230706_i_.func_147108_a((Screen)new ColorScreen(this, item))));
        this.displayWidgets.add((Widget)colorButton);
        String id = I18n.func_135052_a((String)"gui.main.id", (Object[])new Object[0]);
        int idWidth = this.field_230712_o_.func_78256_a(id);
        String count = I18n.func_135052_a((String)"gui.main.count", (Object[])new Object[0]);
        int countWidth = this.field_230712_o_.func_78256_a(count);
        String damage = I18n.func_135052_a((String)"gui.main.damage", (Object[])new Object[0]);
        int damageWidth = this.field_230712_o_.func_78256_a(damage);
        int x = this.field_230708_k_ / 3 + 16 + Math.max(idWidth, Math.max(countWidth, damageWidth));
        this.idField = new StyledDataTextField(this.field_230712_o_, x, 81, this.field_230708_k_ - this.field_230708_k_ / 3 - 8 - x, 16, item.getItem());
        this.idField.setIsResourceLocationField(true);
        this.renderWidgets.add(this.idField);
        int countX = x;
        this.countField = new NumberField(this.field_230712_o_, countX, 101, 16, item.getCount());
        this.renderWidgets.add(this.countField);
        this.countSlider = (SliderTag)this.func_230480_a_(new SliderTag(countX += this.countField.func_230998_h_() + 8, 101, this.field_230708_k_ - this.field_230708_k_ / 3 - 8 - countX, 16, item.getCount()));
        int dmgX = x;
        this.damageField = new NumberField(this.field_230712_o_, dmgX, 121, 16, item.getTag().getDamage());
        this.renderWidgets.add(this.damageField);
        this.damageSlider = (SliderTag)this.func_230480_a_(new SliderTag(dmgX += this.damageField.func_230998_h_() + 8, 121, this.field_230708_k_ - this.field_230708_k_ / 3 - 8 - dmgX, 16, item.getTag().getDamage()));
        this.unbreakable = (StyledToggle)this.func_230480_a_((Widget)new StyledToggle(this.field_230708_k_ / 2 - 40, 141, 80, 16, I18n.func_135052_a((String)"item.tag.unbreakable.true", (Object[])new Object[0]), I18n.func_135052_a((String)"item.tag.unbreakable.false", (Object[])new Object[0]), item.getTag().getUnbreakable()));
        this.setLeftTab((Integer)Config.MAIN_LEFT_TAB.get(), false);
        this.setRightTab((Integer)Config.MAIN_RIGHT_TAB.get(), false);
    }

    private void loadWidgets(Iterable<ClassSpecificWidget> widgets, ArrayList<Widget> widgetList) {
        int y = 55;
        for (ClassSpecificWidget w : widgets) {
            WidgetInfo info;
            Widget widget = w.get(info = new WidgetInfo(this.field_230708_k_ - this.field_230708_k_ / 6, y, this.field_230712_o_.func_78256_a(w.text), 10, w.text, null, this, this.field_230712_o_), item);
            if (widget == null) continue;
            this.func_230480_a_(widget);
            widgetList.add(widget);
            y += 20;
        }
    }

    @Override
    public void func_231175_as__() {
        super.func_231175_as__();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    public void setLeftTab(int i, boolean updateConfig) {
        if (updateConfig && i >= 0 && i <= 3) {
            Config.MAIN_LEFT_TAB.set((Object)i);
        }
        switch (i) {
            case 0: {
                this.nbtButton.field_230693_o_ = false;
                this.tooltipButton.field_230693_o_ = true;
                this.toolsButton.field_230693_o_ = true;
                for (Widget tool : this.toolsWidgets) {
                    tool.field_230694_p_ = false;
                }
                break;
            }
            case 1: {
                this.nbtButton.field_230693_o_ = true;
                this.tooltipButton.field_230693_o_ = false;
                this.toolsButton.field_230693_o_ = true;
                for (Widget tool : this.toolsWidgets) {
                    tool.field_230694_p_ = false;
                }
                break;
            }
            case 2: {
                this.nbtButton.field_230693_o_ = true;
                this.tooltipButton.field_230693_o_ = true;
                this.toolsButton.field_230693_o_ = false;
                for (Widget tool : this.toolsWidgets) {
                    tool.field_230694_p_ = true;
                }
                break;
            }
        }
    }

    public void setRightTab(int i, boolean updateConfig) {
        if (updateConfig && i >= 0 && i <= 3) {
            Config.MAIN_RIGHT_TAB.set((Object)i);
        }
        switch ((Integer)Config.MAIN_RIGHT_TAB.get()) {
            case 0: {
                this.displayButton.field_230693_o_ = false;
                this.editButton.field_230693_o_ = true;
                this.advancedButton.field_230693_o_ = true;
                for (Widget lore : this.displayWidgets) {
                    lore.field_230694_p_ = true;
                }
                for (Widget edit : this.editWidgets) {
                    edit.field_230694_p_ = false;
                }
                for (Widget advanced : this.advancedWidgets) {
                    advanced.field_230694_p_ = false;
                }
                break;
            }
            case 1: {
                this.displayButton.field_230693_o_ = true;
                this.editButton.field_230693_o_ = false;
                this.advancedButton.field_230693_o_ = true;
                for (Widget lore : this.displayWidgets) {
                    lore.field_230694_p_ = false;
                }
                for (Widget edit : this.editWidgets) {
                    edit.field_230694_p_ = true;
                }
                for (Widget advanced : this.advancedWidgets) {
                    advanced.field_230694_p_ = false;
                }
                break;
            }
            case 2: {
                this.displayButton.field_230693_o_ = true;
                this.editButton.field_230693_o_ = true;
                this.advancedButton.field_230693_o_ = false;
                for (Widget lore : this.displayWidgets) {
                    lore.field_230694_p_ = false;
                }
                for (Widget edit : this.editWidgets) {
                    edit.field_230694_p_ = false;
                }
                for (Widget advanced : this.advancedWidgets) {
                    advanced.field_230694_p_ = true;
                }
                break;
            }
        }
    }

    @Override
    public void func_231152_a_(Minecraft minecraft, int par2, int par3) {
        this.func_231158_b_(minecraft, par2, par3);
    }

    public void func_231164_f_() {
        assert (this.field_230706_i_ != null);
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    @Override
    public boolean func_231046_a_(int key1, int key2, int key3) {
        if (key3 == 2) {
            if (key2 == 47) {
                String clip = this.field_230706_i_.field_195559_v.func_197965_a();
                if (!clip.isEmpty()) {
                    try {
                        CompoundNBT nbt = JsonToNBT.func_180713_a((String)clip);
                        if (nbt != null) {
                            item = new DataItem(nbt);
                            NumberRangeInt c = item.getCount();
                            if ((Integer)c.get() > c.getMax()) {
                                c.set(c.getMax());
                            }
                            this.func_231160_c_();
                        }
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
            } else if (key2 == 46 && !item.getNBT().isEmpty()) {
                this.field_230706_i_.field_195559_v.func_197960_a(item.getNBT().func_150285_a_());
            }
        }
        return super.func_231046_a_(key1, key2, key3);
    }

    @Override
    public void backRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, ColorUtils.Color color) {
        super.backRender(matrix, mouseX, mouseY, partialTicks, color);
        MainScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ / 3), (int)20, (int)(this.field_230708_k_ / 3 + 1), (int)(this.field_230709_l_ / 5 * 4), (int)color.getInt());
        MainScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ * 2 / 3), (int)20, (int)(this.field_230708_k_ * 2 / 3 + 1), (int)(this.field_230709_l_ / 5 * 4), (int)color.getInt());
        MainScreen.func_238467_a_((MatrixStack)matrix, (int)20, (int)40, (int)(this.field_230708_k_ / 3 - 15), (int)41, (int)color.getInt());
        MainScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ * 2 / 3 + 16), (int)40, (int)(this.field_230708_k_ - 20), (int)41, (int)color.getInt());
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, ColorUtils.Color color) {
        super.mainRender(matrix, mouseX, mouseY, partialTicks, color);
        String itemCount = (Integer)item.getCount().get() > 1 ? item.getCount().get() + "x " : "";
        String displayName = item.getItemStack().func_151000_E().getString();
        String itemOverview = itemCount + this.addChar(displayName, "\u00a7r", displayName.length() - 1);
        String overviewTrimmed = this.field_230712_o_.func_238412_a_(itemOverview, this.field_230708_k_ / 3 - 15);
        MainScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)(overviewTrimmed.equals(itemOverview) ? overviewTrimmed : overviewTrimmed + "..."), (int)(this.field_230708_k_ / 2), (int)27, (int)color.getInt());
        int x = this.field_230708_k_ / 3 + 10;
        boolean dmgEnabled = this.getItem().getTag().getDamage().getMax() > 0;
        String count = I18n.func_135052_a((String)"gui.main.count", (Object[])new Object[0]);
        int countWidth = this.field_230712_o_.func_78256_a(count);
        String dmgString = I18n.func_135052_a((String)"gui.main.damage", (Object[])new Object[0]);
        int damageWidth = this.field_230712_o_.func_78256_a(dmgString);
        int idoffset = Math.max(countWidth, damageWidth);
        if (dmgEnabled) {
            this.damageField.field_230694_p_ = true;
            this.damageSlider.field_230694_p_ = true;
            MainScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)dmgString, (int)x, (int)125, (int)color.getInt());
            this.unbreakable.field_230691_m_ = 141;
        } else {
            this.damageField.field_230694_p_ = false;
            this.damageSlider.field_230694_p_ = false;
            this.unbreakable.field_230691_m_ = 121;
        }
        String id = I18n.func_135052_a((String)"gui.main.id", (Object[])new Object[0]);
        MainScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)id, (int)x, (int)85, (int)color.getInt());
        MainScreen.func_238476_c_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)count, (int)x, (int)105, (int)color.getInt());
    }

    private String addChar(String str, String ch, int position) {
        return str.substring(0, position) + ch + str.substring(position);
    }

    @Override
    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float partialTicks, ColorUtils.Color color) {
        super.overlayRender(matrix, mouseX, mouseY, partialTicks, color);
        RenderUtil.glScissorBox(6, 41, this.field_230708_k_ / 3, this.field_230709_l_ - 6);
        GL11.glEnable((int)3089);
        matrix.func_227860_a_();
        if ((Integer)Config.MAIN_LEFT_TAB.get() == 0) {
            assert (this.field_230706_i_ != null);
            matrix.func_227862_a_(0.75f, 0.75f, 0.75f);
            ItemRendererUtils.renderFormattedItemNBT(matrix, item, 5, 80, this.field_230708_k_, this.field_230709_l_, this.field_230708_k_ / 3 - 1, this.field_230712_o_);
        } else if ((Integer)Config.MAIN_LEFT_TAB.get() == 1) {
            matrix.func_227862_a_(0.9f, 0.9f, 0.9f);
            this.func_230457_a_(matrix, item.getItemStack(), 3, 68);
        }
        matrix.func_227865_b_();
        GL11.glDisable((int)3089);
    }
}

