/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.screen.ItemInspectorScreen;
import infinityitemeditor.screen.ParentScreen;
import infinityitemeditor.screen.widgets.ColorHelperWidget;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import java.util.UUID;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CCreativeInventoryActionPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ParentItemScreen
extends ParentScreen {
    protected static DataItem item;
    protected boolean hasEssButtons = true;
    protected StyledButton backButton;
    protected StyledButton resetButton;
    protected StyledButton saveButton;
    protected StyledButton dropButton;
    protected boolean renderItem = true;
    protected boolean renderColorHelper = false;
    private ColorHelperWidget colorHelperWidget;
    protected float itemScale = 2.0f;
    protected float itemRotX = 0.0f;
    protected int correctX = 0;
    protected boolean renderToolTip = false;

    public ParentItemScreen(ITextComponent title, Screen lastScreen, DataItem editing) {
        super(title, lastScreen);
        item = editing;
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.func_231039_at__().clear();
        this.renderWidgets.clear();
        if (this.hasEssButtons) {
            String butCloseBack;
            int bwidth = 68;
            int posX = this.field_230708_k_ / 2 - bwidth / 2;
            int posY = this.field_230709_l_ - 42;
            boolean hasLastscreen = this.lastScreen != null;
            String string = butCloseBack = hasLastscreen ? "gui.main.back" : "gui.main.close";
            if (hasLastscreen) {
                posY += 10;
            }
            this.backButton = (StyledButton)this.func_230480_a_((Widget)new StyledButton(posX - bwidth - 1, posY, bwidth, 20, (ITextComponent)new TranslationTextComponent(butCloseBack), this::back));
            this.resetButton = (StyledButton)this.func_230480_a_((Widget)new StyledButton(posX, hasLastscreen ? posY : posY - 11, bwidth, 20, (ITextComponent)new TranslationTextComponent("gui.main.reset"), this::reset));
            this.saveButton = hasLastscreen ? null : (StyledButton)this.func_230480_a_((Widget)new StyledButton(posX, posY + 10, bwidth, 20, (ITextComponent)new TranslationTextComponent("gui.main.save"), this::save));
            this.dropButton = (StyledButton)this.func_230480_a_((Widget)new StyledButton(posX + bwidth + 1, posY, bwidth, 20, (ITextComponent)new TranslationTextComponent("gui.main.drop"), this::drop));
            if (!this.field_230706_i_.field_71439_g.func_184812_l_() && !this.field_230706_i_.func_71356_B()) {
                if (this.saveButton != null) {
                    this.saveButton.field_230693_o_ = false;
                }
                this.dropButton.field_230693_o_ = false;
            }
        }
        if (this.renderColorHelper) {
            this.colorHelperWidget = new ColorHelperWidget(this.field_230705_e_, this.field_230708_k_ - this.dropButton.field_230690_l_ - this.dropButton.func_230998_h_() - 10, 30, this.field_230708_k_, this.field_230709_l_);
            this.renderWidgets.add(this.colorHelperWidget);
        }
    }

    public void back(Widget w) {
        this.field_230706_i_.func_147108_a(this.lastScreen);
    }

    public void reset(Widget w) {
        DataItem dItem;
        item = dItem = new DataItem(item.getItem().getItem(), 1, new CompoundNBT(), (int)((Integer)item.getSlot().get()));
        Screen last = this.lastScreen;
        while (last instanceof ParentItemScreen) {
            ParentItemScreen lastItemScreen = (ParentItemScreen)last;
            item = dItem;
            last = lastItemScreen.lastScreen;
        }
        this.func_231160_c_();
    }

    public void save(Widget w) {
        if (item.getItem().getItem() != Items.field_190931_a) {
            int slotId = 36 + this.field_230706_i_.field_71439_g.field_71071_by.field_70461_c;
            if (this.field_230706_i_.func_71356_B()) {
                this.field_230706_i_.func_71401_C().func_184103_al().func_177451_a((UUID)this.field_230706_i_.field_71439_g.func_110124_au()).field_71069_bz.func_75141_a(slotId, item.getItemStack());
            } else {
                this.field_230706_i_.func_147114_u().func_147297_a((IPacket)new CCreativeInventoryActionPacket(slotId, item.getItemStack()));
            }
        }
    }

    public void drop(Widget w) {
        if (item.getItem().getItem() != Items.field_190931_a) {
            if (ParentItemScreen.func_231173_s_()) {
                this.field_230706_i_.field_195559_v.func_197960_a(this.generateGiveCommand(item));
            } else {
                this.field_230706_i_.func_147114_u().func_147297_a((IPacket)new CCreativeInventoryActionPacket(-1, item.getItemStack()));
            }
        }
    }

    private String generateGiveCommand(DataItem item) {
        String nbt = item.getTag().getNBT().toString();
        nbt = nbt.length() > 2 ? nbt : "";
        String resource_location = item.getItem().getItem().getRegistryName().toString();
        String amount = (Integer)item.getCount().get() > 1 ? " " + item.getCount().get() : "";
        return "/give @p " + resource_location + nbt + amount;
    }

    public DataItem getItem() {
        return item;
    }

    public void setRenderItem(boolean shouldRender, float scale) {
        this.renderItem = shouldRender;
        if (scale > 0.0f) {
            this.itemScale = scale;
        }
    }

    public void setRenderItem(boolean shouldRender, float scale, int correctX) {
        this.setRenderItem(shouldRender, scale);
        this.correctX = correctX;
    }

    protected boolean isInColorWidget(int mouseX, int mouseY) {
        return this.colorHelperWidget != null && GuiUtil.isMouseInColorWidget(mouseX, mouseY, this.colorHelperWidget);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (this.isInColorWidget((int)mouseX, (int)mouseY)) {
            return this.colorHelperWidget.func_231044_a_(mouseX, mouseY, mouseButton);
        }
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.renderItem && GuiUtil.isMouseIn((int)mouseX, (int)mouseY, this.field_230708_k_ / 2 - 17, 43, 36, 36)) {
            this.field_230706_i_.func_147108_a((Screen)new ItemInspectorScreen(this, item));
            return true;
        }
        return false;
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.mainRender(matrix, mouseX, mouseY, p3, color);
    }

    @Override
    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.overlayRender(matrix, mouseX, mouseY, p3, color);
        GuiUtil.addToolTip(matrix, (Screen)this, (Widget)this.dropButton, mouseX, mouseY, I18n.func_135052_a((String)"gui.main.copyclipboard", (Object[])new Object[0]));
        if (this.renderItem) {
            this.renderItem(matrix, mouseX, mouseY, color, item);
        }
    }

    protected void renderItem(MatrixStack matrix, int mouseX, int mouseY, ColorUtils.Color color, DataItem item) {
        ItemStack stack = item.getItemStack();
        Item ite = item.getItem().getItem();
        int x = this.field_230708_k_ / 2;
        int y = 60;
        int xFrameStart = x - 19 + this.correctX;
        int xFrameEnd = x + 19;
        int yFrameStart = 41;
        if (ite == Items.field_190931_a) {
            ParentItemScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)ite.func_200295_i(stack).getString(), (int)x, (int)(y - 3), (int)color.getInt());
        } else {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)this.itemScale, (float)this.itemScale, (float)1.0f);
            RenderSystem.scalef((float)this.itemScale, (float)this.itemScale, (float)1.0f);
            this.drawItemStack(item.getItemStack(), (int)((float)xFrameStart / this.itemScale + 1.0f), (int)((float)yFrameStart / this.itemScale + 1.0f), this.itemRotX, 0.0f, null);
            RenderSystem.popMatrix();
        }
        if (GuiUtil.isMouseIn(mouseX, mouseY, this.field_230708_k_ / 2 - 17, 43, 36, 36)) {
            this.itemRotX = (float)((double)this.itemRotX + 0.25);
            if (this.itemScale == 2.0f) {
                GuiUtil.drawFrame(matrix, xFrameStart, yFrameStart, xFrameEnd, 79, 1, StyleManager.getCurrentStyle().getFGColor(true, true));
            }
            this.func_230457_a_(matrix, stack, mouseX, mouseY);
        } else {
            this.itemRotX = 0.0f;
            if (this.itemScale == 2.0f) {
                GuiUtil.drawFrame(matrix, xFrameStart, yFrameStart, xFrameEnd, 79, 1, color);
            }
        }
    }
}

