/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import infinityitemeditor.screen.widgets.StyledTextField;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import infinityitemeditor.util.ItemRendererUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public abstract class ParentScreen
extends Screen {
    protected final Screen lastScreen;
    protected List<Widget> renderWidgets = Lists.newArrayList();
    private int topLineWidth = -1;

    public ParentScreen(ITextComponent title, Screen lastScreen) {
        super(title);
        this.lastScreen = lastScreen;
    }

    protected void func_231160_c_() {
        this.renderWidgets.clear();
        super.func_231160_c_();
    }

    public void func_231152_a_(Minecraft mc, int width, int height) {
        super.func_231152_a_(mc, width, height);
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.lastScreen);
    }

    public boolean func_231046_a_(int key1, int key2, int key3) {
        return super.func_231046_a_(key1, key2, key3);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public FontRenderer getFontRenderer() {
        return this.field_230712_o_;
    }

    public void drawItemStack(ItemStack stack, int x, int y, float rotX, float rotY, String altText) {
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.func_230926_e_(200);
        this.field_230707_j_.field_77023_b = 10.0f;
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        if (font == null) {
            font = this.field_230712_o_;
        }
        new ItemRendererUtils(this.field_230707_j_).renderItemIntoGUI(stack, x, y, rotX, rotY);
        this.field_230707_j_.func_180453_a(font, stack, x, y, altText);
        this.func_230926_e_(0);
        this.field_230707_j_.field_77023_b = 0.0f;
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-32.0f);
    }

    public void func_231023_e_() {
        this.renderWidgets.forEach(w -> {
            if (w instanceof StyledTextField) {
                ((StyledTextField)((Object)w)).tick();
            }
        });
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        for (Widget w : this.renderWidgets) {
            if (!w.func_231044_a_(mouseX, mouseY, mouseButton)) continue;
            this.func_231035_a_((IGuiEventListener)w);
            if (mouseButton != 0) continue;
            this.func_231037_b__(true);
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Deprecated
    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        ColorUtils.Color color = StyleManager.getCurrentStyle().getMainColor();
        this.backRender(matrix, mouseX, mouseY, partialTicks, color);
        this.mainRender(matrix, mouseX, mouseY, partialTicks, color);
        this.overlayRender(matrix, mouseX, mouseY, partialTicks, color);
        StyleManager.getCurrentStyle().update();
    }

    public void backRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        StyleManager.getCurrentStyle().renderBackground(matrix, this);
        GuiUtil.drawFrame(matrix, 5, 5, this.field_230708_k_ - 5, this.field_230709_l_ - 5, 1, color);
        ParentScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)this.func_231171_q_().getString(), (int)(this.field_230708_k_ / 2), (int)9, (int)color.getInt());
        int midX = this.field_230708_k_ / 2;
        if (this.getTopLineWidth() == -1) {
            int sWidthHalf = this.field_230712_o_.func_78256_a(this.func_231171_q_().getString()) / 2 + 3;
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(midX - sWidthHalf), (int)20, (int)(midX + sWidthHalf), (int)21, (int)color.getInt());
        } else if (this.getTopLineWidth() > 1) {
            int halfLineW = this.topLineWidth / 2;
            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(midX - halfLineW), (int)20, (int)(midX + halfLineW), (int)21, (int)color.getInt());
        }
    }

    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        this.field_230710_m_.forEach(b -> b.func_230430_a_(matrix, mouseX, mouseY, p3));
        this.renderWidgets.forEach(w -> w.func_230430_a_(matrix, mouseX, mouseY, p3));
    }

    public void overlayRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
    }

    public int getTopLineWidth() {
        return this.topLineWidth;
    }

    public void setTopLineWidth(int topLineWidth) {
        this.topLineWidth = topLineWidth;
    }
}

