/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.NumberRangeInt;
import infinityitemeditor.screen.ParentItemScreen;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.screen.widgets.StyledTextField;
import infinityitemeditor.util.ColorUtils;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class RawNBTEditorScreen
extends ParentItemScreen {
    private StyledTextField nbtField;
    private StyledButton copyButton;
    private String nbtText = "";
    private int fieldY;
    private final int fieldHeight = 20;
    private String statusText = "";
    private final int bwidth = 50;
    private final int butHeight = 20;

    public RawNBTEditorScreen(Screen lastScreen, DataItem item) {
        super((ITextComponent)new TranslationTextComponent("gui.rawnbt"), lastScreen, item);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        int fieldWidth = this.field_230708_k_ / 6 * 4;
        this.fieldY = (this.field_230709_l_ - 20) / 2;
        this.nbtField = new StyledTextField(this.field_230712_o_, (this.field_230708_k_ - fieldWidth) / 2, this.fieldY, fieldWidth, 20, "nbt");
        this.nbtField.setMaxStringLength(9999);
        this.initFieldText();
        this.copyButton = new StyledButton((this.field_230708_k_ - 50) / 2, this.nbtField.field_230691_m_ + 20 + 10, 50, 20, (ITextComponent)new TranslationTextComponent("gui.loreeditor.copy"), this::copy);
        this.renderWidgets.add(this.nbtField);
        this.renderWidgets.add(this.copyButton);
        this.field_230706_i_.field_195559_v.func_197967_a(true);
    }

    private void copy(Button button) {
        this.field_230706_i_.field_195559_v.func_197960_a(this.nbtField.getText());
    }

    private void initFieldText() {
        String tag = "{}";
        if (!this.nbtText.isEmpty()) {
            tag = this.nbtText;
        } else if (!item.getNBT().isEmpty()) {
            tag = item.getNBT().func_150285_a_();
        }
        this.nbtField.setText(tag);
    }

    public boolean func_223281_a_(int p_223281_1_, int p_223281_2_, int p_223281_3_) {
        this.tryUpdateDataItem();
        return super.func_223281_a_(p_223281_1_, p_223281_2_, p_223281_3_);
    }

    private void tryUpdateDataItem() {
        CompoundNBT nbt = this.canConvertStringToNBT(this.nbtField.getText());
        try {
            NumberRangeInt c;
            if (nbt != null && (Integer)(c = (item = new DataItem(nbt)).getCount()).get() > c.getMax()) {
                c.set(c.getMax());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void mainRender(MatrixStack matrix, int mouseX, int mouseY, float p3, ColorUtils.Color color) {
        super.mainRender(matrix, mouseX, mouseY, p3, color);
        RawNBTEditorScreen.func_238471_a_((MatrixStack)matrix, (FontRenderer)this.field_230712_o_, (String)this.statusText, (int)(this.field_230708_k_ / 2), (int)(this.fieldY - 20 + 5), (int)TextFormatting.RED.func_211163_e());
    }

    @Override
    public void reset(Widget w) {
        this.nbtText = "";
        this.statusText = "";
        this.initFieldText();
    }

    private CompoundNBT canConvertStringToNBT(String s) {
        try {
            this.statusText = "";
            return JsonToNBT.func_180713_a((String)s);
        }
        catch (JsonSyntaxException | CommandSyntaxException e) {
            this.statusText = e.getMessage();
            return null;
        }
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.nbtText = this.nbtField.getText();
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_231023_e_() {
        this.nbtField.tick();
        super.func_231023_e_();
    }

    @Override
    public void func_231175_as__() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        super.func_231175_as__();
    }
}

