/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.models;

import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.NumberRangeInt;
import infinityitemeditor.data.base.DataBoolean;
import infinityitemeditor.data.tag.TagAttributeModifier;
import infinityitemeditor.data.tag.TagEnum;
import infinityitemeditor.screen.models.TagModifier;
import infinityitemeditor.screen.widgets.NumberField;
import infinityitemeditor.screen.widgets.StyledEnumSwitcher;
import infinityitemeditor.screen.widgets.StyledToggle;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.ShieldItem;

public class AttributeTagModifier
implements TagModifier<TagAttributeModifier> {
    private final DataBoolean infinity;
    private StyledToggle infinityToggle;
    private final TagEnum<AttributeModifier.Operation> operation;
    private StyledEnumSwitcher operationSwitcher;
    private final TagEnum<EquipmentSlotType> slot;
    private StyledEnumSwitcher slotSwitcher;
    private final NumberRangeInt level;
    private NumberField levelField;
    private final NumberRangeInt levelFractional;
    private NumberField fractionalField;

    public AttributeTagModifier(DataItem dataItem) {
        Item item = dataItem.getItem().getItem();
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            this.slot = new TagEnum<EquipmentSlotType>(EquipmentSlotType.class, armor.func_185083_B_());
        } else {
            this.slot = item instanceof ShieldItem || item instanceof ArrowItem || item == Items.field_190929_cY ? new TagEnum<EquipmentSlotType>(EquipmentSlotType.class, EquipmentSlotType.OFFHAND) : new TagEnum<EquipmentSlotType>(EquipmentSlotType.class, EquipmentSlotType.MAINHAND);
        }
        this.infinity = new DataBoolean();
        this.operation = new TagEnum<AttributeModifier.Operation>(AttributeModifier.Operation.class, AttributeModifier.Operation.ADDITION);
        this.level = new NumberRangeInt(1, 0, 99999999);
        this.levelFractional = new NumberRangeInt(0, 999);
    }

    private void initWidgets(FontRenderer font, int width, int height) {
        this.infinityToggle = new StyledToggle(10, height - 105, 80, 20, I18n.func_135052_a((String)"gui.attributewheel.infinity", (Object[])new Object[0]), this.infinity);
        this.operationSwitcher = new StyledEnumSwitcher(10, height - 80, 80, 20, this.operation);
        this.slotSwitcher = new StyledEnumSwitcher(10, height - 55, 80, 20, this.slot);
        this.levelField = new NumberField(font, 10, height - 30, 20, this.level);
        this.fractionalField = new NumberField(font, 15 + this.levelField.func_230998_h_(), height - 30, 20, this.levelFractional);
    }

    @Override
    public void modify(TagAttributeModifier tag) {
        if (((Boolean)this.infinity.get()).booleanValue()) {
            tag.getAmount().set(Double.POSITIVE_INFINITY);
        } else {
            tag.getAmount().set((double)((Integer)this.level.get()).intValue() + (double)((Integer)this.levelFractional.get()).intValue() / 1000.0);
        }
        tag.getOperation().set((AttributeModifier.Operation)this.operation.get());
        tag.getSlot().set((EquipmentSlotType)this.slot.get());
    }

    @Override
    public Widget[] widgets(FontRenderer font, int width, int height) {
        this.initWidgets(font, width, height);
        return new Widget[]{this.infinityToggle, this.operationSwitcher, this.slotSwitcher, this.levelField, this.fractionalField};
    }
}

