/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.models;

import com.mojang.datafixers.util.Pair;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.tag.TagEnchantment;
import infinityitemeditor.screen.models.TagFilter;
import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class EnchantmentFilter
implements TagFilter<TagEnchantment> {
    private final TextComponent name;
    private final Function<Pair<DataItem, TagEnchantment>, Boolean> shouldShow;

    public EnchantmentFilter(String name, Function<Pair<DataItem, TagEnchantment>, Boolean> shouldShow) {
        this.name = new TranslationTextComponent("filter._", new Object[]{new TranslationTextComponent("filter.enchantment." + name)});
        this.shouldShow = shouldShow;
    }

    @Override
    public TextComponent getName() {
        return this.name;
    }

    @Override
    public boolean shouldShow(DataItem item, TagEnchantment tag) {
        return this.shouldShow.apply((Pair<DataItem, TagEnchantment>)new Pair((Object)item, (Object)tag));
    }

    public TagEnchantment[] filter(DataItem item, TagEnchantment[] tags) {
        return (TagEnchantment[])Arrays.stream(tags).filter(tagAttributeModifier -> this.shouldShow(item, (TagEnchantment)tagAttributeModifier)).toArray(TagEnchantment[]::new);
    }
}

