/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.models;

import infinityitemeditor.data.DataItem;
import infinityitemeditor.data.tag.TagEnchantment;
import infinityitemeditor.screen.models.EnchantmentFilter;
import infinityitemeditor.screen.models.EnchantmentTagModifier;
import infinityitemeditor.screen.models.TagFilter;
import infinityitemeditor.screen.models.TagModifier;
import infinityitemeditor.screen.models.WheelType;
import infinityitemeditor.util.EnchantmentUtils;
import java.util.Arrays;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class EnchantmentWheelType
extends WheelType<TagEnchantment> {
    private static final EnchantmentFilter SUPPORTED = new EnchantmentFilter("supported", pair -> ((TagEnchantment)pair.getSecond()).getEnchantment().func_92089_a(((DataItem)pair.getFirst()).getItemStack()));
    private static final EnchantmentFilter ENCHANTING_TABLE = new EnchantmentFilter("enchantingtable", pair -> ((TagEnchantment)pair.getSecond()).getEnchantment().canApplyAtEnchantingTable(((DataItem)pair.getFirst()).getItemStack()));
    private static final EnchantmentFilter STOREABLE = new EnchantmentFilter("storeable", pair -> ((TagEnchantment)pair.getSecond()).getEnchantment().isAllowedOnBooks());
    private static final EnchantmentFilter TREASURE = new EnchantmentFilter("treasure", pair -> ((TagEnchantment)pair.getSecond()).getEnchantment().func_185261_e());
    private static final EnchantmentFilter CURSE = new EnchantmentFilter("curse", pair -> ((TagEnchantment)pair.getSecond()).getEnchantment().func_190936_d());
    private static final EnchantmentFilter DISCOVERABLE = new EnchantmentFilter("discoverable", pair -> ((TagEnchantment)pair.getSecond()).getEnchantment().func_190936_d());
    private static final TagFilter<TagEnchantment> MINECRAFT = new TagFilter<TagEnchantment>(){

        @Override
        public TextComponent getName() {
            return new StringTextComponent("Minecraft");
        }

        @Override
        public boolean shouldShow(DataItem item, TagEnchantment tag) {
            return tag.getEnchantment().getRegistryName().func_110624_b().equals("minecraft");
        }

        public TagEnchantment[] filter(DataItem item, TagEnchantment[] tags) {
            return (TagEnchantment[])Arrays.stream(tags).filter(tagAttributeModifier -> this.shouldShow(item, (TagEnchantment)tagAttributeModifier)).toArray(TagEnchantment[]::new);
        }
    };

    public EnchantmentWheelType(DataItem dataItem) {
        super(dataItem, SUPPORTED, ENCHANTING_TABLE, STOREABLE, TREASURE, CURSE, DISCOVERABLE, MINECRAFT);
    }

    @Override
    public TagModifier<TagEnchantment> getTagModifier() {
        return new EnchantmentTagModifier();
    }

    public TagEnchantment[] newArray(int size) {
        return new TagEnchantment[size];
    }

    @Override
    public TagEnchantment clone(TagEnchantment tag) {
        return new TagEnchantment(tag.getNBT());
    }

    public TagEnchantment[] getAll() {
        return (TagEnchantment[])GameRegistry.findRegistry(Enchantment.class).getEntries().stream().map(TagEnchantment::new).toArray(this::newArray);
    }

    @Override
    public TextComponent displayTag(TagEnchantment tag) {
        return (TextComponent)tag.getPrettyDisplay("", 0);
    }

    @Override
    public ITextComponent[] tooltip(TagEnchantment tag) {
        return EnchantmentUtils.getTooltip(tag);
    }

    @Override
    public int compare(TagEnchantment o1, TagEnchantment o2) {
        int curse = Boolean.compare(o1.getEnchantment().func_190936_d(), o2.getEnchantment().func_190936_d());
        if (curse != 0) {
            return curse;
        }
        return super.compare(o1, o2);
    }
}

