/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.models;

import infinityitemeditor.data.Data;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.screen.models.TagFilter;
import infinityitemeditor.screen.models.TagModifier;
import infinityitemeditor.util.TextComponentUtils;
import java.util.Comparator;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class WheelType<T extends Data<?, ?>>
implements Comparator<T> {
    public static final TagFilter<?> ALL = new TagFilter<Data<?, ?>>(){

        @Override
        public TextComponent getName() {
            return new TranslationTextComponent("filter.all");
        }

        @Override
        public boolean shouldShow(DataItem item, Data<?, ?> tag) {
            return true;
        }

        public Data<?, ?>[] filter(DataItem item, Data<?, ?>[] tags) {
            return tags;
        }
    };
    protected DataItem dataItem;
    TagFilter<?>[] tagFilters;

    @SafeVarargs
    public WheelType(DataItem dataItem, TagFilter<T> ... tagFilters) {
        this.dataItem = dataItem;
        this.tagFilters = new TagFilter[tagFilters.length + 1];
        this.tagFilters[0] = ALL;
        System.arraycopy(tagFilters, 0, this.tagFilters, 1, tagFilters.length);
    }

    public abstract TagModifier<T> getTagModifier();

    public abstract T[] newArray(int var1);

    public abstract T clone(T var1);

    public abstract T[] getAll();

    public abstract TextComponent displayTag(T var1);

    public abstract ITextComponent[] tooltip(T var1);

    @Override
    public int compare(T o1, T o2) {
        return TextComponentUtils.getPlainText((ITextProperties)this.displayTag(o1)).compareTo(TextComponentUtils.getPlainText((ITextProperties)this.displayTag(o2)));
    }

    public TagFilter<?>[] getTagFilters() {
        return this.tagFilters;
    }
}

