/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.screen.LoreEditorScreen;
import infinityitemeditor.screen.widgets.StyledButton;
import infinityitemeditor.screen.widgets.StyledTextField;
import infinityitemeditor.styles.StyleManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.StringTextComponent;

public class LoreWidget
extends Widget
implements INestedGuiEventHandler {
    private final int spacing = 4;
    private final int squareSize = 20;
    private int count;
    private final int offset = 20;
    private final int fieldWidth = this.field_230688_j_ - 110;
    private LoreEditorScreen loreEditorScreen;
    private FontRenderer font;
    private StyledButton up;
    private StyledButton down;
    private StyledButton delete;
    public StyledTextField field;
    private List<Widget> children;
    int lastWidth;
    int lastSpacingCount;

    public LoreWidget(int count, int width, FontRenderer font, LoreEditorScreen loreEditorScreen) {
        super(0, 0, width, 20, StringTextComponent.field_240750_d_);
        this.loreEditorScreen = loreEditorScreen;
        this.count = count;
        this.font = font;
        this.children = new ArrayList<Widget>();
        this.field = new StyledTextField(font, 0, 0, this.fieldWidth, this.field_230689_k_, "lore");
        this.field.setMaxStringLength(9999);
        this.up = new StyledButton(0, 0, 20, this.field_230689_k_, "\u2191", t -> loreEditorScreen.moveUp(this));
        this.down = new StyledButton(0, 0, 20, this.field_230689_k_, "\u2193", t -> loreEditorScreen.moveDown(this));
        this.delete = new StyledButton(0, 0, 20, this.field_230689_k_, "\u2715", t -> loreEditorScreen.removeLine(this));
        this.children.add((Widget)this.up);
        this.children.add((Widget)this.down);
        this.children.add((Widget)this.delete);
        this.children.add(this.field);
    }

    public LoreWidget(int count, int width, FontRenderer font, LoreEditorScreen loreEditorScreen, String text) {
        this(count, width, font, loreEditorScreen);
        this.field.setText(text);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.children;
    }

    public boolean func_231041_ay__() {
        return false;
    }

    public void func_231037_b__(boolean b) {
    }

    public LoreWidget updateCount(int i) {
        this.count = i;
        return this;
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        this.children.forEach(t -> t.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_));
        return super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
        this.lastWidth = 0;
        this.lastSpacingCount = 0;
        FontRenderer font = this.loreEditorScreen.getFontRenderer();
        String string = this.count + ".";
        font.getClass();
        LoreWidget.func_238471_a_((MatrixStack)matrix, (FontRenderer)font, (String)string, (int)(this.field_230690_l_ + 10), (int)(this.field_230691_m_ + (20 - 9) / 2), (int)StyleManager.getCurrentStyle().getMainColor().getInt());
        this.renderChild(this.field, 20, 0, matrix, mouseX, mouseY, partial);
        this.renderChild((Widget)this.up, this.fieldWidth, 0, matrix, mouseX, mouseY, partial);
        this.renderChild((Widget)this.down, 20, 0, matrix, mouseX, mouseY, partial);
        this.renderChild((Widget)this.delete, 20, 0, matrix, mouseX, mouseY, partial);
    }

    public void renderChild(Widget child, int offsetX, int offsetY, MatrixStack matrix, int mouseX, int mouseY, float partial) {
        child.field_230690_l_ = this.field_230690_l_ + offsetX + this.lastWidth + this.lastSpacingCount * 4;
        child.field_230691_m_ = this.field_230691_m_ + offsetY;
        this.lastWidth += offsetX;
        ++this.lastSpacingCount;
        child.func_230430_a_(matrix, mouseX, mouseY, partial);
    }

    public boolean func_231042_a_(char p_231042_1_, int p_231042_2_) {
        return this.field.func_231042_a_(p_231042_1_, p_231042_2_);
    }

    @Nullable
    public IGuiEventListener func_241217_q_() {
        return this.field;
    }

    public void func_231035_a_(@Nullable IGuiEventListener p_231035_1_) {
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        return this.field.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public void setFocusField(boolean bool) {
        this.func_230996_d_(bool);
        this.field.func_230996_d_(bool);
        this.field.selectionEnd = this.field.cursorPosition;
    }

    public String getText() {
        return this.field.getText();
    }

    public boolean func_230999_j_() {
        return this.field.func_230999_j_();
    }

    public int getCount() {
        return this.count;
    }
}

