/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.data.NumberRangeInt;
import infinityitemeditor.screen.widgets.WidgetInfo;
import infinityitemeditor.styles.Style;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.util.ColorUtils;
import infinityitemeditor.util.GuiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class NumberField
extends Widget {
    private final FontRenderer fontRenderer;
    NumberRangeInt data;
    public char[] digits;
    private final char[] allowed = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private boolean isNegative;
    private int cursorCounter;
    private final boolean enableBackgroundDrawing = true;
    private boolean canLoseFocus = true;
    private int cursorPosition;

    public NumberField(WidgetInfo info, NumberRangeInt data) {
        this(info.getFont(), info.getPosX(), info.getPosY(), info.getHeight(), data);
    }

    public NumberField(FontRenderer font, int x, int y, int width, int height, NumberRangeInt data) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(""));
        int d;
        this.data = data;
        this.fontRenderer = font;
        String min = Integer.toString(data.getMin());
        String max = Integer.toString(data.getMin());
        if (max.length() >= min.length()) {
            d = max.length();
            this.field_230688_j_ = font.func_78256_a(max);
        } else {
            d = min.length();
            this.field_230688_j_ = font.func_78256_a(min);
        }
        this.digits = new char[d];
        this.setValue((Integer)data.get());
    }

    public NumberField(FontRenderer font, int x, int y, int height, NumberRangeInt data) {
        super(x, y, 1000, height, (ITextComponent)new StringTextComponent(""));
        int m;
        this.data = data;
        this.fontRenderer = font;
        int d = 0;
        int n = m = (Integer)data.get() > data.getMax() ? ((Integer)data.get()).intValue() : data.getMax();
        while (m > 0) {
            m /= 10;
            ++d;
        }
        this.field_230688_j_ = font.func_78256_a("0") * d + 8;
        this.digits = new char[d];
        this.setValue((Integer)data.get());
    }

    public String getValueAsString() {
        return (this.isNegative ? Character.valueOf('-') : "") + new String(this.digits);
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void setDigit(int i, char c) {
        if (this.isAllowed(c)) {
            this.digits[i] = c;
        }
        if (this.getDigitsValue() > this.data.getMax() || this.data.getMax() == Integer.MAX_VALUE && this.getDigitsValue() == Integer.MAX_VALUE) {
            int diff;
            String maxStr = this.data.getMax() + "";
            char mC = maxStr.charAt(this.cursorPosition - (diff = this.digits.length - maxStr.length()));
            if (c == mC) {
                this.setValue(this.data.getMax());
            } else {
                this.setDigit(mC);
            }
        } else if (this.getDigitsValue() < this.data.getMin()) {
            int diff;
            String minStr = this.data.getMin() + "";
            String zeroes = "";
            int neededZeroes = this.digits.length - minStr.length();
            for (int z = 0; z < neededZeroes; ++z) {
                zeroes = zeroes + "0";
            }
            minStr = zeroes + minStr;
            char mC = minStr.charAt(this.cursorPosition - (diff = this.digits.length - minStr.length()));
            if (c == mC) {
                this.setValue(this.data.getMin());
            } else {
                this.setDigit(mC);
            }
        }
        this.data.set(this.getDigitsValue());
    }

    public void setDigit(char c) {
        this.setDigit(this.cursorPosition, c);
    }

    private void setValue(int value) {
        int diff;
        String s = Integer.toString(value);
        if (value < 0) {
            s = s.substring(1);
        }
        if ((diff = this.getValueAsString().length() - s.length()) < 0) {
            return;
        }
        this.resetDigits();
        for (int i = 0; i < s.length(); ++i) {
            this.digits[diff + i] = s.charAt(i);
        }
    }

    private void resetDigits() {
        for (int i = 0; i < this.digits.length; ++i) {
            this.digits[i] = 48;
        }
    }

    private int getDigitsValue() {
        if (this.digits.length >= 10) {
            long value = Long.parseLong(this.getValueAsString());
            return value >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
        }
        return Integer.parseInt(this.getValueAsString());
    }

    public boolean isAllowed(char c) {
        for (char ch : this.allowed) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public void moveCursor(boolean right) {
        this.setCursorPosition(this.cursorPosition + (right ? 1 : -1));
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        int i = this.digits.length - 1;
        this.cursorPosition = MathHelper.func_76125_a((int)this.cursorPosition, (int)0, (int)i);
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.digits.length - 1);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifier) {
        switch (keyCode) {
            case 263: {
                this.moveCursor(false);
                return true;
            }
            case 262: {
                this.moveCursor(true);
                return true;
            }
            case 265: {
                this.setValue(this.getDigitsValue() + 1);
                return true;
            }
            case 264: {
                this.setValue(this.getDigitsValue() - 1);
                return true;
            }
        }
        return super.func_231046_a_(keyCode, scanCode, modifier);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!this.func_230999_j_()) {
            return false;
        }
        if (Screen.func_231169_i_((int)keyCode)) {
            mc.field_195559_v.func_197960_a(String.valueOf(this.digits));
            return true;
        }
        if (Screen.func_231168_h_((int)keyCode)) {
            if (this.field_230693_o_) {
                try {
                    this.setValue(Integer.decode(mc.field_195559_v.func_197965_a()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (Screen.func_231166_g_((int)keyCode)) {
            mc.field_195559_v.func_197960_a(String.valueOf(this.digits));
            if (this.field_230693_o_) {
                this.resetDigits();
            }
            return true;
        }
        if (this.field_230693_o_) {
            if (typedChar == '-' && this.data.getMin() < 0) {
                this.isNegative = true;
            } else if (typedChar == '+' && this.data.getMax() > -1) {
                this.isNegative = false;
            } else if (this.isAllowed(typedChar)) {
                this.setDigit(typedChar);
                this.moveCursor(true);
            }
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean flag;
        boolean bl = flag = mouseX >= (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY >= (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_);
        if (this.canLoseFocus) {
            this.func_230996_d_(flag);
        }
        if (this.func_230999_j_() && flag && mouseButton == 0) {
            int i = (int)mouseX - this.field_230690_l_;
            ((Object)((Object)this)).getClass();
            String s = this.fontRenderer.func_238412_a_(this.getValueAsString(), this.func_230998_h_());
            this.setCursorPosition(this.fontRenderer.func_238412_a_(s, i -= 4).length());
            return true;
        }
        return false;
    }

    public void func_230431_b_(MatrixStack matrix, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
        Style style = StyleManager.getCurrentStyle();
        ColorUtils.Color color = style.getFGColor(this);
        String s = this.getValueAsString();
        if (this.digits.length != 0 && s.length() == this.digits.length && s.length() != 0 && this.getDigitsValue() != ((Integer)this.data.get()).intValue()) {
            this.setValue((Integer)this.data.get());
        }
        if (this.getEnableBackgroundDrawing()) {
            GuiUtil.drawFrame(matrix, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 1, color);
        }
        int cursorPos = this.cursorPosition;
        String string = this.fontRenderer.func_238412_a_(s, this.func_230998_h_());
        boolean cursorFine = cursorPos >= 0 && cursorPos <= string.length();
        boolean displayCursor = this.func_230999_j_() && this.cursorCounter / 6 % 2 == 0 && cursorFine;
        ((Object)((Object)this)).getClass();
        int textX = this.field_230690_l_ + 4;
        ((Object)((Object)this)).getClass();
        int textY = this.field_230691_m_ + (this.field_230689_k_ - 8) / 2;
        int halfX = textX;
        if (!string.isEmpty()) {
            String halfString = cursorFine ? string.substring(0, cursorPos) : string;
            halfX = this.fontRenderer.func_238405_a_(matrix, halfString, (float)textX, (float)textY, color.getInt()) - 1;
        }
        int cursorX = halfX;
        if (!cursorFine) {
            int n = cursorX = cursorPos > 0 ? textX + this.field_230688_j_ : textX;
        }
        if (!string.isEmpty() && cursorFine && cursorPos < string.length()) {
            halfX = this.fontRenderer.func_238405_a_(matrix, string.substring(cursorPos), (float)halfX, (float)textY, color.getInt());
        }
        if (displayCursor) {
            this.fontRenderer.func_238405_a_(matrix, "_", (float)cursorX, (float)textY, color.getInt());
        }
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean getEnableBackgroundDrawing() {
        return this.enableBackgroundDrawing;
    }

    public void func_230996_d_(boolean isFocusedIn) {
        super.func_230996_d_(isFocusedIn);
        if (isFocusedIn) {
            this.cursorCounter = 0;
        }
    }

    public int func_230998_h_() {
        return this.getEnableBackgroundDrawing() ? this.field_230688_j_ - 6 : this.field_230688_j_;
    }

    public void setCanLoseFocus(boolean canLoseFocusIn) {
        this.canLoseFocus = canLoseFocusIn;
    }

    public NumberRangeInt getData() {
        return this.data;
    }
}

