/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.util.GuiUtil;
import infinityitemeditor.util.RenderUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import org.lwjgl.opengl.GL11;

public class ScrollableScissorWindow
extends Widget
implements INestedGuiEventHandler {
    @Nullable
    private IGuiEventListener focused;
    private boolean isDragging;
    private boolean isScrolling = false;
    private int scrollOffset = 0;
    private final int padding = 5;
    private final int scrollBarWidth = 10;
    protected final List<Widget> widgets = Lists.newArrayList();

    public ScrollableScissorWindow(int x, int y, int width, int height, ITextComponent msg) {
        super(x, y, width, height, msg);
    }

    public int getListHeight() {
        int height = 5;
        for (Widget w : this.widgets) {
            height += w.func_238483_d_() + 5;
        }
        return height;
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (this.field_230692_n_) {
            int listHeight = this.getListHeight();
            if (listHeight <= this.field_230689_k_) {
                return false;
            }
            this.scrollOffset = (int)MathHelper.func_151237_a((double)((double)this.scrollOffset - p_mouseScrolled_5_ * 10.0), (double)0.0, (double)(listHeight - this.field_230689_k_));
            return true;
        }
        return false;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.widgets;
    }

    public final boolean func_231041_ay__() {
        return this.isDragging;
    }

    public final void func_231037_b__(boolean isDragging) {
        this.isDragging = isDragging;
    }

    @Nullable
    public IGuiEventListener func_241217_q_() {
        return this.focused;
    }

    public void func_231035_a_(IGuiEventListener focused) {
        this.focused = focused;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && GuiUtil.isMouseInRegion(mouseX, mouseY, this.field_230690_l_ + this.field_230688_j_ - 10, this.field_230691_m_, 10, this.field_230689_k_)) {
            this.isScrolling = true;
            int listHeight = this.getListHeight();
            int n = listHeight - this.field_230689_k_;
            int insideHeight = this.field_230689_k_ - 4;
            double covered = MathHelper.func_151237_a((double)((float)insideHeight / (float)listHeight), (double)0.0, (double)1.0);
            int scrollBarHeight = (int)((double)insideHeight * covered);
            int scrollSpace = insideHeight - scrollBarHeight;
            double mousePos = MathHelper.func_151237_a((double)(mouseY - ((double)(this.field_230691_m_ + 2) + (double)scrollBarHeight / 2.0)), (double)0.0, (double)scrollSpace);
            double scrollPerc = mousePos / (double)scrollSpace;
            this.scrollOffset = (int)(scrollPerc * (double)n);
            return true;
        }
        this.isScrolling = false;
        if (this.field_230692_n_ && this.func_231039_at__().size() > 0) {
            for (IGuiEventListener iGuiEventListener : this.func_231039_at__()) {
                if (!iGuiEventListener.func_231044_a_(mouseX, mouseY, mouseButton)) continue;
                this.func_231035_a_(iGuiEventListener);
                if (mouseButton == 0) {
                    this.func_231037_b__(true);
                }
                return true;
            }
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        this.isScrolling = false;
        return super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double onX, double onY) {
        if (this.isScrolling) {
            int listHeight = this.getListHeight();
            int max = listHeight - this.field_230689_k_;
            int insideHeight = this.field_230689_k_ - 4;
            double covered = MathHelper.func_151237_a((double)((float)insideHeight / (float)listHeight), (double)0.0, (double)1.0);
            int scrollBarHeight = (int)((double)insideHeight * covered);
            int scrollSpace = insideHeight - scrollBarHeight;
            double mousePos = MathHelper.func_151237_a((double)(mouseY - (double)(this.field_230691_m_ + 2 + scrollBarHeight / 2)), (double)0.0, (double)scrollSpace);
            double scrollPerc = mousePos / (double)scrollSpace;
            this.scrollOffset = (int)(scrollPerc * (double)max);
        }
        return super.func_231045_a_(mouseX, mouseY, button, onX, onY);
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        GuiUtil.drawFrame(matrix, this.field_230690_l_, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 1, StyleManager.getCurrentStyle().getMainColor());
        int listHeight = this.getListHeight();
        GuiUtil.drawFrame(matrix, this.field_230690_l_ + this.field_230688_j_ - 10, this.field_230691_m_, this.field_230690_l_ + this.field_230688_j_, this.field_230691_m_ + this.field_230689_k_, 1, StyleManager.getCurrentStyle().getMainColor());
        int insideHeight = this.field_230689_k_ - 4;
        double covered = MathHelper.func_151237_a((double)((float)insideHeight / (float)listHeight), (double)0.0, (double)1.0);
        int scrollBarHeight = (int)((double)insideHeight * covered);
        double scrolled = MathHelper.func_151237_a((double)((float)this.scrollOffset / (float)(listHeight - this.field_230689_k_)), (double)0.0, (double)1.0);
        int scrolledPixels = (int)(scrolled * (double)(insideHeight - scrollBarHeight));
        int scrollTop = 2 + this.field_230691_m_ + scrolledPixels;
        boolean hovered = GuiUtil.isMouseInRegion(mouseX, mouseY, this.field_230690_l_ + this.field_230688_j_ - 10, this.field_230691_m_, 10, this.field_230689_k_);
        ScrollableScissorWindow.func_238467_a_((MatrixStack)matrix, (int)(2 + this.field_230690_l_ + this.field_230688_j_ - 10), (int)scrollTop, (int)(this.field_230690_l_ + this.field_230688_j_ - 2), (int)(scrollTop + scrollBarHeight), (int)StyleManager.getCurrentStyle().getFGColor(true, hovered).getInt());
        if (this.widgets.size() != 0) {
            RenderUtil.glScissorBox(this.field_230690_l_ + 1, this.field_230691_m_ + 2, this.field_230690_l_ + this.field_230688_j_ - 10 - 1, this.field_230691_m_ + this.field_230689_k_ - 1);
            GL11.glEnable((int)3089);
            int x = this.field_230690_l_ + 5;
            int y = this.field_230691_m_ + 5 - this.scrollOffset;
            int maxY = this.field_230691_m_ + this.field_230689_k_;
            boolean mouseOut = mouseY < this.field_230691_m_ || mouseY >= maxY;
            for (Widget w : this.widgets) {
                w.field_230690_l_ = x;
                w.field_230691_m_ = y;
                w.func_230991_b_(this.field_230688_j_ - 5 - 5 - 10);
                if (this.field_230691_m_ <= w.field_230691_m_ + w.func_238483_d_() && w.field_230691_m_ < maxY) {
                    w.field_230693_o_ = true;
                    w.field_230694_p_ = true;
                    if (mouseOut) {
                        w.func_230430_a_(matrix, -10000, -10000, partialTicks);
                    } else {
                        w.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
                    }
                } else {
                    w.field_230693_o_ = false;
                    w.field_230694_p_ = false;
                }
                y = w.field_230691_m_ + w.func_238483_d_() + 5;
            }
            GL11.glDisable((int)3089);
        }
    }

    public void func_230988_a_(SoundHandler p_230988_1_) {
    }

    public boolean isScrolling() {
        return this.isScrolling;
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }
}

