/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import infinityitemeditor.styles.IStyledSlider;
import infinityitemeditor.styles.StyleManager;
import infinityitemeditor.styles.StyleSpectrum;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StyledSlider
extends Widget
implements IStyledSlider<Integer> {
    public int value;
    public String display;
    public boolean drawString;
    public int min;
    public int max;
    @Nullable
    public SliderHandler handler = null;

    protected StyledSlider(int x, int y, int width, int height, String display, int value, int min, int max) {
        this(x, y, width, height, display, true, value, min, max, null);
    }

    protected StyledSlider(int x, int y, int width, int height, int value, int min, int max) {
        this(x, y, width, height, "", false, value, min, max, null);
    }

    protected StyledSlider(int x, int y, int width, int height, String display, boolean drawString, int value, int min, int max, SliderHandler handler) {
        super(x, y, width, height, (ITextComponent)new StringTextComponent(display));
        this.value = value;
        this.display = display;
        this.drawString = drawString;
        this.min = min;
        this.max = max;
        this.handler = handler;
        this.func_238482_a_((ITextComponent)new StringTextComponent(drawString ? display + value : ""));
    }

    public void func_230431_b_(MatrixStack matrix, int mouseX, int mouseY, float p3) {
        StyleManager.getCurrentStyle().renderButton(matrix, this, mouseX, mouseY, p3);
        super.func_230431_b_(matrix, mouseX, mouseY, p3);
    }

    private void setValueFromMouse(double mouseX) {
        double updateValue = StyleManager.getCurrentStyle() instanceof StyleSpectrum ? (mouseX - ((double)this.field_230690_l_ + 1.0)) / ((double)this.field_230688_j_ - 2.5) : (mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8);
        this.setValue((int)Math.round(updateValue * (double)(this.max - this.min) + (double)this.min));
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    public boolean func_231046_a_(int key1, int key2, int key3) {
        if (key1 == 263 && this.value > this.min) {
            --this.value;
            this.updateSlider();
            return true;
        }
        if (key1 == 262 && this.value < this.max) {
            ++this.value;
            this.updateSlider();
            return true;
        }
        return false;
    }

    public void setValue(int value) {
        int clamped = MathHelper.func_76125_a((int)value, (int)this.min, (int)this.max);
        if (this.value != clamped) {
            this.value = clamped;
            this.updateSlider();
        }
    }

    public void updateSlider() {
        this.func_238482_a_((ITextComponent)new StringTextComponent(this.drawString ? this.display + this.value : ""));
        if (this.handler != null) {
            this.handler.onSlideValue(this);
        }
    }

    protected void func_230983_a_(double mouseX, double p_onDrag_3_, double p_onDrag_5_, double p_onDrag_7_) {
        this.setValueFromMouse(mouseX);
        super.func_230983_a_(mouseX, p_onDrag_3_, p_onDrag_5_, p_onDrag_7_);
    }

    public void func_230988_a_(SoundHandler soundHandler) {
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        super.func_230988_a_(Minecraft.func_71410_x().func_147118_V());
    }

    public int getFGColor() {
        return StyleManager.getCurrentStyle().getFGColor(this).getInt();
    }

    @Override
    public Widget getWidget() {
        return this;
    }

    @Override
    public int getImageY(boolean b) {
        return super.func_230989_a_(b);
    }

    @Override
    public int getOffsetBlit() {
        return super.func_230927_p_();
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public Integer getMin() {
        return this.min;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public void setHovered(boolean b) {
        this.field_230692_n_ = b;
    }

    @Override
    public void renderBackground(MatrixStack matrix, Minecraft mc, int mouseX, int mouseY) {
        if (!this.field_230694_p_) {
            return;
        }
        StyleManager.getCurrentStyle().renderSlider(matrix, this, mouseX, mouseY);
    }

    public static interface SliderHandler {
        public void onSlideValue(StyledSlider var1);
    }
}

