/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.styles;

import infinityitemeditor.styles.ButtonColor;
import infinityitemeditor.styles.Style;
import infinityitemeditor.util.ColorUtils;
import net.minecraft.client.gui.widget.Widget;

public abstract class StyleBase
implements Style {
    protected ButtonColor buttonColor;
    private static final ColorUtils.Color color = new ColorUtils.Color(100, 100, 100);

    public StyleBase(ButtonColor buttonColor) {
        this.buttonColor = buttonColor;
    }

    @Override
    public ColorUtils.Color getMainColor() {
        return color.copy();
    }

    @Override
    public void update() {
    }

    @Override
    public ColorUtils.Color getFGColor(Widget widget) {
        return this.getFGColor(widget.field_230693_o_, widget.func_230449_g_());
    }

    @Override
    public ColorUtils.Color getFGColor(boolean active, boolean hovered) {
        if (!active) {
            return this.buttonColor.inactive();
        }
        if (!hovered) {
            return this.buttonColor.hovered();
        }
        return this.buttonColor.standard();
    }

    public static class StaticButtonColor
    implements ButtonColor {
        private static final ColorUtils.Color[] colors = new ColorUtils.Color[3];

        public StaticButtonColor(ColorUtils.Color hovered, ColorUtils.Color standard, ColorUtils.Color inactive) {
            StaticButtonColor.colors[0] = hovered;
            StaticButtonColor.colors[1] = standard;
            StaticButtonColor.colors[2] = inactive;
        }

        public StaticButtonColor(int hovered, int standard, int inactive) {
            this(new ColorUtils.Color(hovered), new ColorUtils.Color(standard), new ColorUtils.Color(inactive));
        }

        @Override
        public ColorUtils.Color hovered() {
            return colors[0];
        }

        @Override
        public ColorUtils.Color standard() {
            return colors[1];
        }

        @Override
        public ColorUtils.Color inactive() {
            return colors[2];
        }
    }
}

