/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.util;

import infinityitemeditor.data.tag.TagAttributeModifier;
import infinityitemeditor.util.ResourceLocationUtils;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;

public class AttributeUtils {
    public static IForgeRegistry<Attribute> getAttributeRegistry() {
        return GameRegistry.findRegistry(Attribute.class);
    }

    public static ResourceLocation getResourceLocation(Attribute attribute) {
        return attribute.getRegistryName();
    }

    public static String getName(Attribute attribute) {
        return ResourceLocationUtils.getShortString(AttributeUtils.getResourceLocation(attribute));
    }

    public static Attribute getAttribute(ResourceLocation resourceLocation) {
        return (Attribute)AttributeUtils.getAttributeRegistry().getValue(resourceLocation);
    }

    public static Attribute getAttribute(String resourceLocation) {
        return AttributeUtils.getAttribute(new ResourceLocation(resourceLocation));
    }

    public static String getNameSpace(Attribute attribute) {
        return AttributeUtils.getResourceLocation(attribute).func_110624_b();
    }

    public static boolean belongsToNameSpace(Attribute attribute, String namespace) {
        return AttributeUtils.getNameSpace(attribute).equals(namespace);
    }

    public static TextComponent getText(Attribute attribute, AttributeModifier modifier) {
        double d0 = modifier.func_111164_d();
        double d1 = modifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (attribute.equals(Attributes.field_233820_c_) ? d0 * 10.0 : d0) : d0 * 100.0;
        if (d0 < 0.0) {
            return (TextComponent)new TranslationTextComponent("attribute.modifier.take." + modifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.RED);
        }
        return (TextComponent)new TranslationTextComponent("attribute.modifier.plus." + modifier.func_220375_c().func_220371_a(), new Object[]{ItemStack.field_111284_a.format(d1), new TranslationTextComponent(attribute.func_233754_c_())}).func_240699_a_(TextFormatting.BLUE);
    }

    public static ITextComponent[] getTooltip(TagAttributeModifier tag) {
        return new ITextComponent[]{AttributeUtils.getText(tag.getAttribute(), tag.createAttributeModifier()), tag.getSlot().getKeyValue(), tag.getOperation().getKeyValue(), new TranslationTextComponent("attribute.amount._", new Object[]{tag.getAmount().getPrettyDisplay("", 0)}).func_240699_a_(TextFormatting.AQUA), new StringTextComponent(AttributeUtils.getNameSpace(tag.getAttribute())).func_240699_a_(TextFormatting.BLUE)};
    }
}

