/*
 * Decompiled with CFR 0.152.
 */
package infinityitemeditor.util;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import infinityitemeditor.data.DataItem;
import infinityitemeditor.screen.ParentScreen;
import infinityitemeditor.screen.widgets.ColorHelperWidget;
import infinityitemeditor.util.ColorUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class GuiUtil
extends GuiUtils {
    public static FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    public static boolean isMouseIn(int mouseX, int mouseY, int x, int y, int width, int height) {
        return x <= mouseX && mouseX < x + width && y <= mouseY && mouseY < y + height;
    }

    public static boolean isMouseInColorWidget(int mouseX, int mouseY, ColorHelperWidget w) {
        return w.field_230690_l_ <= mouseX && mouseX < w.field_230690_l_ + w.func_230998_h_() && w.field_230691_m_ <= mouseY && mouseY < w.field_230691_m_ + w.func_238483_d_();
    }

    public static void drawFrame(MatrixStack matrix, int xStart, int yStart, int xEnd, int yEnd, int border, ColorUtils.Color color) {
        int c = color.getInt();
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xStart, (int)yStart, (int)xEnd, (int)(yStart + border), (int)c);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xStart, (int)(yStart + border), (int)(xStart + border), (int)(yEnd - border), (int)c);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)(xEnd - border), (int)(yStart + border), (int)xEnd, (int)(yEnd - border), (int)c);
        AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xStart, (int)(yEnd - border), (int)xEnd, (int)yEnd, (int)c);
    }

    public static void fillGradient(ParentScreen screen, int xStart, int yStart, int xEnd, int yEnd, int fromColor, int toColor) {
        float f = (float)(fromColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(fromColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(fromColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(fromColor & 0xFF) / 255.0f;
        float f4 = (float)(toColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(toColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(toColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(toColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)xEnd, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_225582_a_((double)xEnd, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void fillVerticalGradient(ParentScreen screen, int xStart, int yStart, int xEnd, int yEnd, int topColor, int bottomColor) {
        float f = (float)(topColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(topColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(topColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(topColor & 0xFF) / 255.0f;
        float f4 = (float)(bottomColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(bottomColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(bottomColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(bottomColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)xEnd, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_225582_a_((double)xEnd, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void fillHorizontalGradient(ParentScreen screen, int xStart, int yStart, int xEnd, int yEnd, int leftColor, int rightColor) {
        float leftAlpha = (float)(leftColor >> 24 & 0xFF) / 255.0f;
        float leftRed = (float)(leftColor >> 16 & 0xFF) / 255.0f;
        float leftGreen = (float)(leftColor >> 8 & 0xFF) / 255.0f;
        float leftBlue = (float)(leftColor & 0xFF) / 255.0f;
        float rightAlpha = (float)(rightColor >> 24 & 0xFF) / 255.0f;
        float rightRed = (float)(rightColor >> 16 & 0xFF) / 255.0f;
        float rightGreen = (float)(rightColor >> 8 & 0xFF) / 255.0f;
        float rightBlue = (float)(rightColor & 0xFF) / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)xEnd, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(rightRed, rightGreen, rightBlue, rightAlpha).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(leftRed, leftGreen, leftBlue, leftAlpha).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(leftRed, leftGreen, leftBlue, leftAlpha).func_181675_d();
        bufferbuilder.func_225582_a_((double)xEnd, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(rightRed, rightGreen, rightBlue, rightAlpha).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void fillColorPicker(ParentScreen screen, int xStart, int yStart, int xEnd, int yEnd, float hue) {
        ColorUtils.Color sat = ColorUtils.Color.fromHSB(hue, 1.0f, 1.0f);
        float satRed = (float)sat.getRed() / 255.0f;
        float satGreen = (float)sat.getGreen() / 255.0f;
        float satBlue = (float)sat.getBlue() / 255.0f;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)xEnd, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xEnd, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)xEnd, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(satRed, satGreen, satBlue, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(satRed, satGreen, satBlue, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(satRed, satGreen, satBlue, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xEnd, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(satRed, satGreen, satBlue, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_225582_a_((double)xEnd, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yStart, (double)screen.func_230927_p_()).func_227885_a_(0.0f, 0.0f, 0.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xStart, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)xEnd, (double)yEnd, (double)screen.func_230927_p_()).func_227885_a_(0.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }

    public static void fillHueSlider(ParentScreen screen, int xStart, int yStart, int xEnd, int yEnd) {
        int gradWidth = (xEnd - xStart) / 6;
        int i = 0;
        GuiUtil.fillHorizontalGradient(screen, xStart + gradWidth * i++, yStart, xStart + gradWidth * i, yEnd, -65536, -256);
        GuiUtil.fillHorizontalGradient(screen, xStart + gradWidth * i++, yStart, xStart + gradWidth * i, yEnd, -256, -16711936);
        GuiUtil.fillHorizontalGradient(screen, xStart + gradWidth * i++, yStart, xStart + gradWidth * i, yEnd, -16711936, -16711681);
        GuiUtil.fillHorizontalGradient(screen, xStart + gradWidth * i++, yStart, xStart + gradWidth * i, yEnd, -16711681, -16776961);
        GuiUtil.fillHorizontalGradient(screen, xStart + gradWidth * i++, yStart, xStart + gradWidth * i, yEnd, -16776961, -65281);
        GuiUtil.fillHorizontalGradient(screen, xStart + gradWidth * i++, yStart, xStart + gradWidth * i, yEnd, -65281, -65536);
    }

    @Nullable
    public static Screen getCurrentScreen() {
        return Minecraft.func_71410_x().field_71462_r;
    }

    public static boolean isMouseInRegion(double mouseX, double mouseY, int xPos, int yPos, int width, int height) {
        return mouseX >= (double)xPos && mouseY >= (double)yPos && mouseX < (double)(xPos + width) && mouseY < (double)(yPos + height);
    }

    public static void addToolTip(MatrixStack matrix, Screen screen, int xPos, int yPos, int width, int height, int mouseX, int mouseY, String ... str) {
        if (GuiUtil.isMouseInRegion(mouseX, mouseY, xPos, yPos, width, height)) {
            GuiUtil.addToolTip(matrix, screen, mouseX, mouseY, str);
        }
    }

    public static void addToolTip(MatrixStack matrix, Screen screen, Widget w, int mouseX, int mouseY, String ... str) {
        if (GuiUtil.isMouseInRegion(mouseX, mouseY, w.field_230690_l_, w.field_230691_m_, w.func_230998_h_(), w.func_238483_d_())) {
            GuiUtil.addToolTip(matrix, screen, mouseX, mouseY, str);
        }
    }

    public static void addToolTip(MatrixStack matrix, Screen screen, int xPos, int yPos, String ... str) {
        GuiUtil.drawHoveringText((ItemStack)ItemStack.field_190927_a, (MatrixStack)matrix, Arrays.stream(str).map(StringTextComponent::new).collect(Collectors.toList()), (int)xPos, (int)yPos, (int)screen.field_230708_k_, (int)screen.field_230709_l_, (int)-1, (FontRenderer)GuiUtil.getFontRenderer());
    }

    public static void addToolTip(MatrixStack matrix, Screen screen, int xPos, int yPos, ITextProperties ... str) {
        GuiUtil.drawHoveringText((ItemStack)ItemStack.field_190927_a, (MatrixStack)matrix, (List)Lists.newArrayList((Object[])str), (int)xPos, (int)yPos, (int)screen.field_230708_k_, (int)screen.field_230709_l_, (int)-1, (FontRenderer)GuiUtil.getFontRenderer());
    }

    public static void addToolTip(MatrixStack matrix, Screen screen, int xPos, int yPos, DataItem item) {
        ItemStack stack = item.getData();
        GuiUtil.drawHoveringText((ItemStack)stack, (MatrixStack)matrix, (List)GuiUtil.getTooltipFromItem(stack), (int)xPos, (int)yPos, (int)screen.field_230708_k_, (int)screen.field_230709_l_, (int)-1, (FontRenderer)GuiUtil.getFontRenderer());
    }

    public static List getTooltipFromItem(ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        List list = stack.func_82840_a((PlayerEntity)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList list1 = Lists.newArrayList();
        for (ITextComponent itextcomponent : list) {
            list1.add(itextcomponent.getString());
        }
        return list1;
    }

    public static void dropStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71439_g.field_71071_by.field_70458_d.func_71019_a(stack, true);
        }
    }

    public static int getColorFromRGB(int alpha, int red, int green, int blue) {
        int color = alpha << 24;
        color += red << 16;
        color += green << 8;
        return color += blue;
    }

    public static void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

