/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity;

import java.io.File;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Logger;
import ruukas.infinity.data.realm.RealmController;
import ruukas.infinity.tab.InfinityTab;
import ruukas.infinity.util.CertificateHandler;

@Mod(modid="infinity", name="Infinity Item Editor", version="0.13.2", clientSideOnly=true, acceptedMinecraftVersions="[1.11.2]")
public class Infinity {
    public static final String MODID = "infinity";
    public static final String NAME = "Infinity Item Editor";
    public static final String VERSION = "0.13.2";
    public static Logger logger;
    public static File dataDir;
    public static KeyBinding keybind;
    public static KeyBinding keybindCopy;
    public static KeyBinding keybindSave;
    public static CreativeTabs UNAVAILABLE;
    public static CreativeTabs REALM;
    public static CreativeTabs BANNERS;
    public static CreativeTabs SKULLS;
    public static CreativeTabs FIREWORKS;
    public static CreativeTabs THIEF;
    public static CreativeTabs VOID;
    public static RealmController realmController;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        dataDir = new File(Minecraft.func_71410_x().field_71412_D, "infinity-data");
        new File(dataDir.getAbsolutePath() + File.separatorChar + "void").mkdirs();
        InfinityTab.initTabs();
        File oldRealmFile = new File(dataDir, "infinity.nbt");
        if (oldRealmFile.exists()) {
            File newRealmFile = new File(dataDir, "realm.nbt");
            if (newRealmFile.exists()) {
                logger.warn("When loading realm in %s, an old version of realm, infinity.nbt, was found, but a newer one, realm.nbt, already exists!", new Object[]{dataDir.getPath()});
            } else {
                oldRealmFile.renameTo(newRealmFile);
                logger.info("When loading realm in %s, found old realm %s, renaming to %s.", new Object[]{dataDir.getPath(), oldRealmFile.getName(), newRealmFile.getName()});
            }
        }
        realmController = new RealmController(dataDir);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        keybind = new KeyBinding("key.infinity.desc", 22, "key.infinity.category");
        ClientRegistry.registerKeyBinding((KeyBinding)keybind);
        keybindCopy = new KeyBinding("key.infinitycopy.desc", 47, "key.infinity.category");
        ClientRegistry.registerKeyBinding((KeyBinding)keybindCopy);
        keybindSave = new KeyBinding("key.infinitysave.desc", 34, "key.infinity.category");
        ClientRegistry.registerKeyBinding((KeyBinding)keybindSave);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (Item item : Item.field_150901_e) {
            if (item == null || item == Items.field_190931_a || item.func_77640_w() != null || item == Items.field_151134_bR) continue;
            item.func_77637_a(UNAVAILABLE);
            logger.info("Item: " + item.func_77658_a() + " was not added to a tab. Adding it to Unavailable.");
        }
        for (Block block : Block.field_149771_c) {
            if (block == null || block == Blocks.field_150350_a || block.func_149708_J() != null) continue;
            block.func_149647_a(UNAVAILABLE);
            logger.info("Block: " + block.func_149739_a() + " was not added to a tab. Adding it to Unavailable.");
        }
        try {
            CertificateHandler.testIfNeedsCert();
        }
        catch (IOException e) {
            logger.warn("Failed to connect to API for head collection. Check your internet connection.");
        }
    }
}

