/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.data.realm;

import java.io.File;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import ruukas.infinity.Infinity;

@SideOnly(value=Side.CLIENT)
public class RealmController {
    public static final String VERSION = "0.2";
    private static final Logger LOGGER = Infinity.logger;
    private final File dataFile;
    private final NonNullList<ItemStack> stackList = NonNullList.func_191196_a();

    public RealmController(File dataDir) {
        this.dataFile = new File(dataDir, "realm.nbt");
        this.read();
    }

    public void read() {
        try {
            NBTTagCompound root = CompressedStreamTools.func_74797_a((File)this.dataFile);
            if (root == null || !root.func_150297_b("realm", 9)) {
                return;
            }
            for (NBTBase tag : root.func_150295_c("realm", 10)) {
                this.stackList.add((Object)new ItemStack((NBTTagCompound)tag));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load infinity realm", (Throwable)exception);
        }
    }

    public void write() {
        try {
            NBTTagCompound root = new NBTTagCompound();
            root.func_74782_a("realm", (NBTBase)new NBTTagList());
            root.func_74778_a("realm_version", VERSION);
            NBTTagList realm = root.func_150295_c("realm", 10);
            for (int i = 0; i < this.stackList.size(); ++i) {
                realm.func_74742_a((NBTBase)((ItemStack)this.stackList.get(i)).func_77955_b(new NBTTagCompound()));
            }
            CompressedStreamTools.func_74795_b((NBTTagCompound)root, (File)this.dataFile);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save infinity realm", (Throwable)exception);
        }
    }

    public void addItemStack(EntityPlayerSP player, ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        for (ItemStack s : this.stackList) {
            if (!ItemStack.func_77989_b((ItemStack)s, (ItemStack)stack)) continue;
            player.func_145747_a(new TextComponentString("Didn't add ").func_150257_a(stack.func_151000_E()).func_150258_a(", as it seems to already exist in the Infinity Realm."));
            return;
        }
        player.func_145747_a(new TextComponentString("Added ").func_150257_a(stack.func_151000_E()).func_150258_a(" to Infinity Realm."));
        this.stackList.add((Object)stack);
        this.write();
    }

    public void removeItemStack(EntityPlayerSP player, ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        for (ItemStack s : this.stackList) {
            if (!ItemStack.func_77989_b((ItemStack)s, (ItemStack)stack)) continue;
            player.func_145747_a(new TextComponentString("Banished ").func_150257_a(stack.func_151000_E()).func_150258_a(" from the Infinity Realm. If this was done by mistake, get it from the Thief tab."));
            this.stackList.remove((Object)s);
            return;
        }
        this.write();
    }

    public NonNullList<ItemStack> getStackList() {
        return this.stackList;
    }
}

