/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.data.thevoid;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class VoidElement {
    private ItemStack stack;
    private NBTTagList uuids = null;

    public VoidElement(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public static VoidElement readFromNBT(NBTTagCompound tag) {
        ItemStack readStack = new ItemStack(tag);
        NBTTagList ids = null;
        if (readStack.func_190926_b()) {
            readStack = new ItemStack(tag.func_74775_l("stack"));
            ids = tag.func_150295_c("uuids", 8);
        }
        VoidElement e = new VoidElement(readStack);
        if (ids != null && !ids.func_82582_d()) {
            e.uuids = ids;
        }
        return e;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        if (this.uuids != null) {
            tag.func_74782_a("uuids", (NBTBase)this.uuids);
        }
        return tag;
    }

    public boolean hasUUID(String id) {
        if (this.uuids == null) {
            return false;
        }
        for (NBTBase tag : this.uuids) {
            if (!id.equals(((NBTTagString)tag).func_150285_a_())) continue;
            return true;
        }
        return false;
    }

    public boolean addUUID(String id, boolean doCheck) {
        if (id == null || id.isEmpty() || doCheck && this.hasUUID(id)) {
            return false;
        }
        if (this.uuids == null) {
            this.uuids = new NBTTagList();
        }
        this.uuids.func_74742_a((NBTBase)new NBTTagString(id));
        return true;
    }
}

