/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.GuiInfinity;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.action.GuiInfinityButton;
import ruukas.infinity.gui.action.GuiNumberField;
import ruukas.infinity.nbt.itemstack.tag.InfinityAttributeModifierList;
import ruukas.infinity.nbt.itemstack.tag.attributemodifiers.InfinityAttributeModifierTag;

@SideOnly(value=Side.CLIENT)
public class GuiAttributes
extends GuiInfinity {
    private static final ItemStack note = new ItemStack(Items.field_151121_aF);
    private static final IAttribute[] sharedAttributes = new IAttribute[]{SharedMonsterAttributes.field_111267_a, SharedMonsterAttributes.field_111265_b, SharedMonsterAttributes.field_111266_c, SharedMonsterAttributes.field_111263_d, SharedMonsterAttributes.field_111264_e, SharedMonsterAttributes.field_188790_f, SharedMonsterAttributes.field_188791_g, SharedMonsterAttributes.field_189429_h, SharedMonsterAttributes.field_188792_h};
    private GuiNumberField level;
    private GuiNumberField levelDecimal;
    private GuiInfinityButton slotButton;
    private GuiInfinityButton operationButton;
    private GuiInfinityButton infinityButton;
    private GuiInfinityButton negativeButton;
    private boolean negativeAmount = false;
    private int rotOff = 0;
    private int mouseDist = 0;
    private int slot = 0;
    private int operation = 0;
    private boolean isInfinity = false;

    public GuiAttributes(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stackHolder) {
        super(lastScreen, stackHolder);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.infinityButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(250, 15, this.field_146295_m - 123, 80, 20, I18n.func_135052_a((String)("gui.attributes.infinity." + (this.isInfinity ? "1" : "0")), (Object[])new Object[0])));
        this.operationButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(251, 15, this.field_146295_m - 93, 80, 20, I18n.func_135052_a((String)("gui.attributes.operation." + this.operation), (Object[])new Object[0])));
        this.slotButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(252, 15, this.field_146295_m - 63, 80, 20, I18n.func_135052_a((String)("gui.attributes.slot." + this.slot), (Object[])new Object[0])));
        this.negativeButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(253, 15, this.field_146295_m - 33, 20, 20, this.negativeAmount ? "-" : "+"));
        if (this.level != null) {
            this.level.y = this.field_146295_m - 32;
        } else {
            this.level = new GuiNumberField(100, this.field_146289_q, 38, this.field_146295_m - 32, 55, 18, 8);
            this.level.minValue = 0;
            this.level.maxValue = 99999999;
            this.level.setValue(0);
        }
        if (this.levelDecimal != null) {
            this.levelDecimal.y = this.field_146295_m - 32;
        } else {
            this.levelDecimal = new GuiNumberField(101, this.field_146289_q, 100, this.field_146295_m - 32, 25, 18, 3);
            this.levelDecimal.minValue = 0;
            this.levelDecimal.maxValue = 999;
            this.levelDecimal.setValue(0);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.level.updateCursorCounter();
        this.levelDecimal.updateCursorCounter();
        if (Math.abs(this.mouseDist - this.field_146295_m / 3) >= 16) {
            ++this.rotOff;
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a(this.backButton);
        } else {
            this.level.textboxKeyTyped(typedChar, keyCode);
            this.levelDecimal.textboxKeyTyped(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.level.mouseClicked(mouseX, mouseY, mouseButton);
        this.levelDecimal.mouseClicked(mouseX, mouseY, mouseButton);
        InfinityAttributeModifierList list = new InfinityAttributeModifierList(this.getItemStack());
        InfinityAttributeModifierTag[] activeModifiers = list.getAll();
        int start = this.midY - 5 * activeModifiers.length;
        if (activeModifiers.length > 0 && HelperGui.isMouseInRegion(mouseX, mouseY, 0, start, 5 + this.field_146289_q.func_78256_a("Unbreaking 32767"), 10 * activeModifiers.length)) {
            list.removeModifier((mouseY - start) / 10);
            return;
        }
        int r = this.field_146295_m / 3;
        if (Math.abs(this.mouseDist - r) < 16) {
            double angle = Math.PI * 2 / (double)sharedAttributes.length;
            int lowDist = Integer.MAX_VALUE;
            IAttribute attribute = null;
            for (int i = 0; i < sharedAttributes.length; ++i) {
                int y;
                int distY;
                double angleI = (double)this.rotOff / 60.0 + angle * (double)i;
                int x = (int)((double)this.midX + (double)r * Math.cos(angleI));
                int distX = x - mouseX;
                int dist = (int)Math.sqrt(distX * distX + (distY = (y = (int)((double)this.midY + (double)r * Math.sin(angleI))) - mouseY) * distY);
                if (dist >= 10 || dist >= lowDist) continue;
                lowDist = dist;
                attribute = sharedAttributes[i];
            }
            if (attribute != null) {
                double amount = this.isInfinity ? (this.negativeAmount ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY) : (this.negativeAmount ? -1.0 : 1.0) * ((double)this.level.getIntValue() + (double)this.levelDecimal.getIntValue() / 1000.0);
                InfinityAttributeModifierTag tag = new InfinityAttributeModifierTag(new InfinityAttributeModifierList(this.getItemStack()), new AttributeModifier(attribute.func_111108_a(), amount, 0));
                tag.setOperation(this.operationButton.field_146124_l ? this.operation : 0);
                tag.setSlot(this.slot);
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.infinityButton.field_146127_k) {
            this.isInfinity = !this.isInfinity;
            this.infinityButton.field_146126_j = I18n.func_135052_a((String)("gui.attributes.infinity." + (this.isInfinity ? "1" : "0")), (Object[])new Object[0]);
            this.level.setEnabled(!this.isInfinity);
            this.levelDecimal.setEnabled(!this.isInfinity);
            this.operationButton.field_146124_l = !this.isInfinity;
        } else if (button.field_146127_k == this.operationButton.field_146127_k) {
            this.operation = (this.operation + 1) % 3;
            this.operationButton.field_146126_j = I18n.func_135052_a((String)("gui.attributes.operation." + this.operation), (Object[])new Object[0]);
        } else if (button.field_146127_k == this.slotButton.field_146127_k) {
            this.slot = (this.slot + 1) % 7;
            this.slotButton.field_146126_j = I18n.func_135052_a((String)("gui.attributes.slot." + this.slot), (Object[])new Object[0]);
        } else if (button.field_146127_k == this.negativeButton.field_146127_k) {
            this.negativeAmount = !this.negativeAmount;
            this.func_73866_w_();
        } else {
            super.func_146284_a(button);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        InfinityAttributeModifierTag[] modifierTags = new InfinityAttributeModifierList(this.getItemStack()).getAll();
        for (int i = 0; i < modifierTags.length; ++i) {
            InfinityAttributeModifierTag m = modifierTags[i];
            this.func_73731_b(this.field_146289_q, m.getDisplayString(), 5, this.midY + i * 10 - modifierTags.length * 5, InfinityConfig.MAIN_COLOR);
        }
        this.level.drawTextBox();
        this.levelDecimal.drawTextBox();
        this.func_73731_b(this.field_146289_q, ".", 96, this.field_146295_m - 26, InfinityConfig.MAIN_COLOR);
        int distX = this.midX - mouseX;
        int distY = this.midY - mouseY;
        this.mouseDist = (int)Math.sqrt(distX * distX + distY * distY);
        int r = this.field_146295_m / 3;
        double angle = Math.PI * 2 / (double)sharedAttributes.length;
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        GlStateManager.func_179152_a((float)5.0f, (float)5.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(this.field_146294_l / 10), (float)(this.field_146295_m / 10), (float)0.0f);
        GlStateManager.func_179114_b((float)(this.rotOff * 3), (float)0.0f, (float)0.0f, (float)-1.0f);
        this.field_146296_j.func_180450_b(this.getItemStack(), -8, -8);
        GlStateManager.func_179114_b((float)(this.rotOff * 3), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-(this.field_146294_l / 10)), (float)(-(this.field_146295_m / 10)), (float)0.0f);
        GlStateManager.func_179139_a((double)0.2, (double)0.2, (double)1.0);
        for (int i = 0; i < sharedAttributes.length; ++i) {
            double angleI = ((double)this.rotOff + (Math.abs(this.mouseDist - r) >= 16 ? (double)partialTicks : 0.0)) / 60.0 + angle * (double)i;
            int x = (int)((double)this.midX + (double)r * Math.cos(angleI));
            int y = (int)((double)this.midY + (double)r * Math.sin(angleI));
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)("attribute.name." + sharedAttributes[i].func_111108_a()), (Object[])new Object[0]), x, y - 17, InfinityConfig.MAIN_COLOR);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
            this.field_146296_j.func_180450_b(note, x - 8, y - 8);
            GuiAttributes.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 1), (int)(y + 1), (int)HelperGui.getColorFromRGB(255, 255, 255, 255));
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    @Override
    protected String getNameUnlocalized() {
        return "attributes";
    }
}

