/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.GuiInfinity;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.action.GuiActionTextField;
import ruukas.infinity.gui.action.GuiInfinityButton;
import ruukas.infinity.nbt.itemstack.tag.InfinityBookTags;

@SideOnly(value=Side.CLIENT)
public class GuiBook
extends GuiInfinity {
    private GuiInfinityButton generationButton;
    private GuiInfinityButton resolvedButton;
    private GuiInfinityButton unsignButton;
    private GuiActionTextField titleField;
    private GuiActionTextField authorField;
    @Nullable
    private InfinityBookTags.SignedData data;

    public GuiBook(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stackHolder) {
        super(lastScreen, stackHolder);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.setRenderStack(true, this.midX, 40, 1.0f);
        this.renderTooltip = true;
        this.renderTag = true;
        Keyboard.enableRepeatEvents((boolean)true);
        InfinityBookTags bookTags = new InfinityBookTags(this.getItemStack());
        boolean written = this.getItemStack().func_77973_b() == Items.field_151164_bB;
        int fields = 0;
        this.titleField = new GuiActionTextField(200 + fields, this.field_146289_q, this.midX, 55 + 30 * fields++, 75, 20);
        this.titleField.func_146203_f(100);
        this.titleField.func_146180_a(bookTags.getTitle());
        this.titleField.func_146184_c(written);
        this.titleField.action = () -> bookTags.setTitle(this.titleField.func_146179_b());
        this.authorField = new GuiActionTextField(200 + fields, this.field_146289_q, this.midX, 55 + 30 * fields++, 75, 20);
        this.authorField.func_146203_f(100);
        this.authorField.func_146180_a(bookTags.getAuthor());
        this.authorField.func_146184_c(written);
        this.authorField.action = () -> bookTags.setAuthor(this.authorField.func_146179_b());
        int buttons = 0;
        this.generationButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(100 + buttons, this.midX - 75, 55 + 30 * fields + 30 * buttons++, 150, 20, I18n.func_135052_a((String)"gui.book.generation", (Object[])new Object[0])));
        this.generationButton.field_146124_l = written;
        this.resolvedButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(100 + buttons, this.midX - 75, 55 + 30 * fields + 30 * buttons++, 150, 20, bookTags.getResolved() ? I18n.func_135052_a((String)"gui.book.resolved", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.book.unresolved", (Object[])new Object[0])));
        this.resolvedButton.field_146124_l = written;
        this.unsignButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(100 + buttons, this.midX - 75, 55 + 30 * fields + 30 * buttons++, 150, 20, this.data != null ? I18n.func_135052_a((String)"gui.book.resign", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.book.unsign", (Object[])new Object[0])));
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.titleField.func_146178_a();
        this.authorField.func_146178_a();
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.titleField.func_146201_a(typedChar, keyCode);
        this.authorField.func_146201_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.titleField.func_146192_a(mouseX, mouseY, mouseButton);
        this.authorField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.generationButton.field_146127_k) {
            new InfinityBookTags(this.getItemStack()).addGeneration();
        } else if (button.field_146127_k == this.unsignButton.field_146127_k) {
            if (this.data == null) {
                ItemStack quill = new ItemStack(Items.field_151099_bA);
                if (this.getItemStack().func_77942_o()) {
                    quill.func_77982_d(this.getItemStack().func_77978_p().func_74737_b());
                    this.data = new InfinityBookTags(quill).unsign();
                    this.stackHolder.setStack(quill);
                }
            } else {
                ItemStack book = new ItemStack(Items.field_151164_bB);
                new InfinityBookTags(book).resign(this.data);
                this.data = null;
                this.stackHolder.setStack(book);
            }
            this.func_73866_w_();
        } else if (button.field_146127_k == this.resolvedButton.field_146127_k) {
            new InfinityBookTags(this.getItemStack()).toggleResolved();
            this.func_73866_w_();
        } else {
            super.func_146284_a(button);
        }
    }

    @Override
    protected String getNameUnlocalized() {
        return "book";
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.titleField.func_146194_f();
        String titleStr = I18n.func_135052_a((String)"gui.book.title", (Object[])new Object[0]);
        this.func_73731_b(this.field_146289_q, titleStr, this.titleField.field_146209_f - this.field_146289_q.func_78256_a(titleStr) - 5, this.titleField.field_146210_g + 6, InfinityConfig.MAIN_COLOR);
        this.authorField.func_146194_f();
        String authorStr = I18n.func_135052_a((String)"gui.book.author", (Object[])new Object[0]);
        this.func_73731_b(this.field_146289_q, authorStr, this.authorField.field_146209_f - this.field_146289_q.func_78256_a(authorStr) - 5, this.authorField.field_146210_g + 6, InfinityConfig.MAIN_COLOR);
        HelperGui.addTooltipTranslated(this.resolvedButton, mouseX, mouseY, I18n.func_135052_a((String)"gui.book.resolved.tooltip", (Object[])new Object[0]));
    }
}

