/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import ruukas.infinity.Infinity;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.action.GuiActionTextField;
import ruukas.infinity.gui.action.GuiInfinityButton;
import ruukas.infinity.nbt.NBTHelper;

@SideOnly(value=Side.CLIENT)
public class GuiColor
extends GuiScreen {
    private ItemStack stack = ItemStack.field_190927_a;
    private final GuiScreen lastScreen;
    private GuiInfinityButton backButton;
    private GuiInfinityButton resetButton;
    private GuiInfinityButton dropButton;
    private GuiSlider redSlider;
    private GuiSlider greenSlider;
    private GuiSlider blueSlider;
    private GuiActionTextField hexText;
    protected String title = I18n.func_135052_a((String)"gui.color", (Object[])new Object[0]);
    protected ArrayList<String> prettyNBTList = new ArrayList();

    public GuiColor(GuiScreen lastScreen, ItemStack stack) {
        this.lastScreen = lastScreen;
        this.stack = stack;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.hexText = new GuiActionTextField(100, this.field_146289_q, this.field_146294_l / 2 - 25, this.field_146295_m / 2 - 85, 50, 20);
        this.hexText.func_146203_f(7);
        String hexS = Integer.toHexString(NBTHelper.ColorNBTHelper.getColorAsInt(this.stack));
        String zeroes = "";
        for (int i = 0; i < 6 - hexS.length(); ++i) {
            zeroes = zeroes + "0";
        }
        this.hexText.func_146180_a("#" + zeroes + hexS);
        this.hexText.action = () -> {
            if (!(this.redSlider.dragging || this.greenSlider.dragging || this.blueSlider.dragging)) {
                String text = this.hexText.func_146179_b();
                int length = text.length();
                if (length == 6 && !text.startsWith("#")) {
                    this.hexText.func_146180_a("#" + text);
                } else if (length == 7) {
                    text = text.substring(1);
                    length = 6;
                }
                if (this.hexText.func_146179_b().length() == 7) {
                    try {
                        NBTHelper.ColorNBTHelper.setColor(this.stack, (int)Long.parseLong(text, 16));
                        this.redSlider.sliderValue = NBTHelper.ColorNBTHelper.getRed(this.stack);
                    }
                    catch (NumberFormatException e) {
                        Infinity.logger.error("Could not parse " + text + " as a hex color.");
                    }
                }
            }
        };
        this.backButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(200, this.field_146294_l / 2 - 90, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0])));
        this.resetButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(201, this.field_146294_l / 2 - 30, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.reset", (Object[])new Object[0])));
        this.dropButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(202, this.field_146294_l / 2 + 30, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.drop", (Object[])new Object[0])));
        this.redSlider = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider(300, this.field_146294_l / 2 - 80, this.field_146295_m / 2 - 50, 160, 20, "Red: ", "", 0.0, 255.0, (double)NBTHelper.ColorNBTHelper.getRed(this.stack), false, true, new GuiSlider.ISlider(){

            public void onChangeSliderValue(GuiSlider slider) {
                NBTHelper.ColorNBTHelper.setRed(GuiColor.this.stack, slider.getValueInt());
                String hexS = Integer.toHexString(NBTHelper.ColorNBTHelper.getColorAsInt(GuiColor.this.stack));
                String zeroes = "";
                for (int i = 0; i < 6 - hexS.length(); ++i) {
                    zeroes = zeroes + "0";
                }
                GuiColor.this.hexText.func_146180_a("#" + zeroes + hexS);
            }
        }));
        this.greenSlider = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider(301, this.field_146294_l / 2 - 80, this.field_146295_m / 2 - 10, 160, 20, "Green: ", "", 0.0, 255.0, (double)NBTHelper.ColorNBTHelper.getGreen(this.stack), false, true, new GuiSlider.ISlider(){

            public void onChangeSliderValue(GuiSlider slider) {
                NBTHelper.ColorNBTHelper.setGreen(GuiColor.this.stack, slider.getValueInt());
                String hexS = Integer.toHexString(NBTHelper.ColorNBTHelper.getColorAsInt(GuiColor.this.stack));
                String zeroes = "";
                for (int i = 0; i < 6 - hexS.length(); ++i) {
                    zeroes = zeroes + "0";
                }
                GuiColor.this.hexText.func_146180_a("#" + zeroes + hexS);
            }
        }));
        this.blueSlider = (GuiSlider)this.func_189646_b((GuiButton)new GuiSlider(302, this.field_146294_l / 2 - 80, this.field_146295_m / 2 + 30, 160, 20, "Blue: ", "", 0.0, 255.0, (double)NBTHelper.ColorNBTHelper.getBlue(this.stack), false, true, new GuiSlider.ISlider(){

            public void onChangeSliderValue(GuiSlider slider) {
                NBTHelper.ColorNBTHelper.setBlue(GuiColor.this.stack, slider.getValueInt());
                String hexS = Integer.toHexString(NBTHelper.ColorNBTHelper.getColorAsInt(GuiColor.this.stack));
                String zeroes = "";
                for (int i = 0; i < 6 - hexS.length(); ++i) {
                    zeroes = zeroes + "0";
                }
                GuiColor.this.hexText.func_146180_a("#" + zeroes + hexS);
            }
        }));
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a(this.backButton);
        } else {
            this.hexText.func_146201_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.hexText.func_146192_a(mouseX, mouseY, mouseButton);
        if (NBTHelper.ColorNBTHelper.isPotion(this.stack) && mouseButton == 0 && HelperGui.isMouseInRegion(mouseX, mouseY, this.blueSlider.field_146128_h, this.blueSlider.field_146129_i + this.blueSlider.field_146121_g + 10, 160, 40)) {
            int horizontal = (mouseX - this.blueSlider.field_146128_h) / 20;
            int vertical = 8 * ((mouseY - (this.blueSlider.field_146129_i + this.blueSlider.field_146121_g + 10)) / 20);
            NBTHelper.ColorNBTHelper.addDye(this.stack, EnumDyeColor.values()[horizontal + vertical]);
            this.hexText.func_146180_a(Integer.toHexString(NBTHelper.ColorNBTHelper.getColorAsInt(this.stack)));
            this.redSlider.setValue((double)NBTHelper.ColorNBTHelper.getRed(this.stack));
            this.redSlider.updateSlider();
            this.greenSlider.setValue((double)NBTHelper.ColorNBTHelper.getGreen(this.stack));
            this.greenSlider.updateSlider();
            this.blueSlider.setValue((double)NBTHelper.ColorNBTHelper.getBlue(this.stack));
            this.blueSlider.updateSlider();
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.backButton.field_146127_k) {
            this.field_146297_k.func_147108_a(this.lastScreen);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (button.field_146127_k == this.resetButton.field_146127_k) {
            if (this.stack.func_77942_o()) {
                this.stack.func_77982_d(new NBTTagCompound());
            }
        } else if (button.field_146127_k == this.dropButton.field_146127_k) {
            HelperGui.dropStack(this.stack);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179094_E();
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        this.func_146285_a(this.stack, 0, 25);
        String s = this.stack.func_77942_o() ? this.stack.func_77978_p().toString() : "{}";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(s);
        s = gson.toJson(je);
        this.prettyNBTList.clear();
        for (String str : s.split("\\n")) {
            this.prettyNBTList.add(str);
        }
        this.func_146283_a(this.prettyNBTList, 0, this.field_146295_m);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        GlStateManager.func_179152_a((float)4.0f, (float)4.0f, (float)1.0f);
        this.field_146296_j.func_180450_b(this.stack, this.field_146294_l / 8 - 8, 5);
        GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)1.0);
        if (!NBTHelper.ColorNBTHelper.isPotion(this.stack)) {
            int j = 0;
            for (EnumDyeColor c : EnumDyeColor.values()) {
                this.field_146296_j.func_180450_b(new ItemStack(Items.field_151100_aR, 1, c.func_176767_b()), 2 + this.blueSlider.field_146128_h + 20 * (j % 8), 2 + this.blueSlider.field_146129_i + this.blueSlider.field_146121_g + 10 + 20 * (j / 8));
                ++j;
            }
        }
        GlStateManager.func_179121_F();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 15, InfinityConfig.MAIN_COLOR);
        GuiColor.func_73734_a((int)(this.redSlider.field_146128_h - 5), (int)(this.redSlider.field_146129_i - 5), (int)(this.blueSlider.field_146128_h + this.blueSlider.field_146120_f + 5), (int)(this.blueSlider.field_146129_i + this.blueSlider.field_146121_g + 5), (int)HelperGui.getColorFromRGB(100, this.redSlider.getValueInt(), this.greenSlider.getValueInt(), this.blueSlider.getValueInt()));
        GuiColor.func_73734_a((int)(this.redSlider.field_146128_h - 2), (int)(this.redSlider.field_146129_i - 2), (int)(this.redSlider.field_146128_h + this.redSlider.field_146120_f + 2), (int)(this.redSlider.field_146129_i + this.redSlider.field_146121_g + 2), (int)HelperGui.getColorFromRGB(255, this.redSlider.getValueInt(), 0, 0));
        GuiColor.func_73734_a((int)(this.greenSlider.field_146128_h - 2), (int)(this.greenSlider.field_146129_i - 2), (int)(this.greenSlider.field_146128_h + this.greenSlider.field_146120_f + 2), (int)(this.greenSlider.field_146129_i + this.greenSlider.field_146121_g + 2), (int)HelperGui.getColorFromRGB(255, 0, this.greenSlider.getValueInt(), 0));
        GuiColor.func_73734_a((int)(this.blueSlider.field_146128_h - 2), (int)(this.blueSlider.field_146129_i - 2), (int)(this.blueSlider.field_146128_h + this.blueSlider.field_146120_f + 2), (int)(this.blueSlider.field_146129_i + this.blueSlider.field_146121_g + 2), (int)HelperGui.getColorFromRGB(255, 0, 0, this.blueSlider.getValueInt()));
        if (!NBTHelper.ColorNBTHelper.isPotion(this.stack)) {
            int size = 20;
            int i = 0;
            for (EnumDyeColor c : EnumDyeColor.values()) {
                GuiColor.func_73734_a((int)(this.blueSlider.field_146128_h + size * (i % 8)), (int)(this.blueSlider.field_146129_i + this.blueSlider.field_146121_g + 10 + size * (i / 8)), (int)(this.blueSlider.field_146128_h + size * (i % 8 + 1)), (int)(this.blueSlider.field_146129_i + this.blueSlider.field_146121_g + 10 + size + size * (i / 8)), (int)(-1627389952 + c.func_176768_e().field_76291_p));
                ++i;
            }
        }
        this.hexText.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public boolean func_73868_f() {
        return false;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }
}

