/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.GuiInfinity;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.action.GuiInfinityButton;
import ruukas.infinity.gui.action.GuiNumberField;
import ruukas.infinity.nbt.itemstack.tag.InfinityEnchantmentList;
import ruukas.infinity.nbt.itemstack.tag.ench.InfinityEnchantmentTag;

@SideOnly(value=Side.CLIENT)
public class GuiEnchanting
extends GuiInfinity {
    private static boolean showAll = false;
    private GuiInfinityButton enchantToggleButton;
    private GuiNumberField level;
    private int rotOff = 0;
    private int mouseDist = 0;
    private List<Enchantment> enchants = new ArrayList<Enchantment>();
    private ItemStack enchantBook;

    public GuiEnchanting(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stackHolder) {
        super(lastScreen, stackHolder);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.enchantToggleButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(150, 15, this.field_146295_m - 63, 90, 20, I18n.func_135052_a((String)("gui.enchanting.enchanttoggle." + (showAll ? 1 : 0)), (Object[])new Object[0])));
        this.level = new GuiNumberField(100, this.field_146289_q, 15, this.field_146295_m - 33, 40, 18, 5);
        this.level.minValue = 1;
        this.level.maxValue = Short.MAX_VALUE;
        this.level.setValue(1);
        this.enchants.clear();
        for (Enchantment e : Enchantment.field_185264_b) {
            if (!showAll && !e.func_92089_a(this.getItemStack())) continue;
            this.enchants.add(e);
        }
        this.enchants.sort(new EnchantComparator());
        this.enchantBook = new ItemStack((Item)Items.field_151134_bR);
        if (!this.enchants.isEmpty()) {
            EnchantmentData dat = new EnchantmentData(this.enchants.get(0), 1);
            Items.field_151134_bR.func_92115_a(this.enchantBook, dat);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.level.updateCursorCounter();
        if (Math.abs(this.mouseDist - this.field_146295_m / 3) >= 16) {
            ++this.rotOff;
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a(this.backButton);
        } else {
            this.level.textboxKeyTyped(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.level.mouseClicked(mouseX, mouseY, mouseButton);
        InfinityEnchantmentList list = new InfinityEnchantmentList(this.getItemStack());
        InfinityEnchantmentTag[] activeEnchants = list.getAll();
        int start = this.midY - 5 * activeEnchants.length;
        if (activeEnchants.length > 0 && HelperGui.isMouseInRegion(mouseX, mouseY, 0, start, 5 + this.field_146289_q.func_78256_a("Unbreaking 32767"), 10 * activeEnchants.length)) {
            list.removeEnchantment((mouseY - start) / 10);
            return;
        }
        int r = this.field_146295_m / 3;
        if (Math.abs(this.mouseDist - r) < 16) {
            double angle = Math.PI * 2 / (double)this.enchants.size();
            int lowDist = Integer.MAX_VALUE;
            Enchantment enchantment = null;
            for (int i = 0; i < this.enchants.size(); ++i) {
                int y;
                int distY;
                double angleI = (double)this.rotOff / 60.0 + angle * (double)i;
                int x = (int)((double)this.midX + (double)r * Math.cos(angleI));
                int distX = x - mouseX;
                int dist = (int)Math.sqrt(distX * distX + (distY = (y = (int)((double)this.midY + (double)r * Math.sin(angleI))) - mouseY) * distY);
                if (dist >= 10 || dist >= lowDist) continue;
                lowDist = dist;
                enchantment = this.enchants.get(i);
            }
            if (enchantment != null) {
                new InfinityEnchantmentList(this.getItemStack()).set(enchantment, (short)(enchantment.func_77325_b() == 1 ? 1 : this.level.getIntValue()));
            }
        } else if (mouseX > this.midX - 15 && mouseX < this.midX + 15 && mouseY > this.midY - 15 && mouseY < this.midY + 15) {
            for (Enchantment e : this.enchants) {
                new InfinityEnchantmentList(this.getItemStack()).set(e, (short)(e.func_77325_b() == 1 ? 1 : this.level.getIntValue()));
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.enchantToggleButton.field_146127_k) {
            showAll = !showAll;
            this.func_73866_w_();
        } else {
            super.func_146284_a(button);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        InfinityEnchantmentTag[] enchantmentTags = new InfinityEnchantmentList(this.getItemStack()).getAll();
        for (int i = 0; i < enchantmentTags.length; ++i) {
            InfinityEnchantmentTag e = enchantmentTags[i];
            if (e.getEnchantment() != null) {
                this.func_73731_b(this.field_146289_q, e.getEnchantment().func_77316_c((int)e.getLevel()).replace("enchantment.level.", ""), 5, this.midY + i * 10 - enchantmentTags.length * 5, InfinityConfig.MAIN_COLOR);
                continue;
            }
            this.func_73731_b(this.field_146289_q, "Unknown ID (" + e.getID() + ")", 5, this.midY + i * 10 - enchantmentTags.length * 5, 16007778);
        }
        this.level.drawTextBox();
        int distX = this.midX - mouseX;
        int distY = this.midY - mouseY;
        this.mouseDist = (int)Math.sqrt(distX * distX + distY * distY);
        int r = this.field_146295_m / 3;
        double angle = Math.PI * 2 / (double)this.enchants.size();
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        GlStateManager.func_179152_a((float)5.0f, (float)5.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(this.field_146294_l / 10), (float)(this.field_146295_m / 10), (float)0.0f);
        GlStateManager.func_179114_b((float)(this.rotOff * 3), (float)0.0f, (float)0.0f, (float)-1.0f);
        this.field_146296_j.func_180450_b(this.getItemStack(), -8, -8);
        GlStateManager.func_179114_b((float)(this.rotOff * 3), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-(this.field_146294_l / 10)), (float)(-(this.field_146295_m / 10)), (float)0.0f);
        GlStateManager.func_179139_a((double)0.2, (double)0.2, (double)1.0);
        for (int i = 0; i < this.enchants.size(); ++i) {
            double angleI = ((double)this.rotOff + (Math.abs(this.mouseDist - r) >= 16 ? (double)partialTicks : 0.0)) / 60.0 + angle * (double)i;
            int x = (int)((double)this.midX + (double)r * Math.cos(angleI));
            int y = (int)((double)this.midY + (double)r * Math.sin(angleI));
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            this.func_73732_a(this.field_146289_q, this.enchants.get(i).func_77316_c(this.enchants.get(i).func_77325_b() == 1 ? 1 : this.level.getIntValue()).replace("enchantment.level.", ""), x, y - 17, InfinityConfig.MAIN_COLOR);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
            this.field_146296_j.func_180450_b(this.enchantBook, x - 8, y - 8);
            GuiEnchanting.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 1), (int)(y + 1), (int)HelperGui.getColorFromRGB(255, 255, 255, 255));
        }
        if (mouseX > this.midX - 15 && mouseX < this.midX + 15 && mouseY > this.midY - 15 && mouseY < this.midY + 15) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.enchanting.addall", (Object[])new Object[0]), this.midX, this.midY, InfinityConfig.CONTRAST_COLOR);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    @Override
    protected String getNameUnlocalized() {
        return "enchanting";
    }

    public static class EnchantComparator
    implements Comparator<Enchantment> {
        @Override
        public int compare(Enchantment o1, Enchantment o2) {
            return o1.func_77316_c(1).compareToIgnoreCase(o2.func_77316_c(1));
        }
    }
}

