/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.NonNullList;
import org.lwjgl.input.Keyboard;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.nbt.NBTHelper;
import ruukas.infinity.nbt.itemstack.tag.InfinitySkullOwnerTag;

public class GuiHeadCollection
extends GuiScreen {
    public static final String[] CATEGORIES = new String[]{"alphabet", "animals", "blocks", "decoration", "food-drinks", "humans", "humanoid", "miscellaneous", "monsters", "plants"};
    private static final String API_URL = "https://minecraft-heads.com/scripts/api.php?cat=";
    private static int selCat = 0;
    private static int currentElement = 0;
    private static String filteredString = null;
    private static String searchString = "";
    private int maxInRow;
    private int amountInPage;
    private int loaded = -1;
    private final GuiScreen lastScreen;
    private NonNullList<ItemStack> allSkulls = NonNullList.func_191196_a();
    private NonNullList<ItemStack> filteredSkulls = NonNullList.func_191196_a();

    public GuiHeadCollection(GuiScreen lastScreen) {
        this.lastScreen = lastScreen;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.loaded != selCat) {
            try {
                this.loadSkulls();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!searchString.equals(filteredString)) {
            this.filteredSkulls.clear();
            for (ItemStack s : this.allSkulls) {
                if (!s.func_82833_r().toLowerCase().contains(searchString.toLowerCase())) continue;
                this.filteredSkulls.add((Object)s);
            }
            currentElement = 0;
            filteredString = searchString;
        }
        this.maxInRow = (this.field_146294_l - 250) / 16;
        this.amountInPage = this.maxInRow * 10;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int y;
        int x;
        int i;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        int letterSpace = 80;
        int space = (this.field_146294_l - this.maxInRow * 16 - letterSpace) / 2;
        int nextPageW = this.field_146289_q.func_78256_a("-->");
        int topbar = 20;
        int currentPage = currentElement / this.amountInPage;
        int amountPages = (int)Math.ceil(this.filteredSkulls.size() / this.amountInPage) + 1;
        int searchW = this.field_146289_q.func_78256_a(searchString);
        if (searchString.length() > 0 && !searchString.equals(filteredString) && HelperGui.isMouseInRegion(mouseX, mouseY, this.field_146294_l / 2 - searchW / 2, 56, searchW, 8)) {
            this.func_73866_w_();
        } else {
            if (currentPage + 1 < amountPages && HelperGui.isMouseInRegion(mouseX, mouseY, space + letterSpace + this.maxInRow * 16 - 3 - nextPageW, 50 + topbar + 168, nextPageW, 8)) {
                currentElement = Math.min(this.filteredSkulls.size() - 1, (currentPage + 1) * this.amountInPage);
                return;
            }
            if (currentPage > 0 && HelperGui.isMouseInRegion(mouseX, mouseY, space + letterSpace + this.maxInRow * 16 - 25 - nextPageW * 2, 50 + topbar + 168, nextPageW, 8)) {
                currentElement = Math.max(0, (currentPage - 1) * this.amountInPage);
                return;
            }
        }
        for (i = 0; i < CATEGORIES.length; ++i) {
            x = space + letterSpace / 2;
            y = i * 15 + 59 + topbar;
            int sWH = this.field_146289_q.func_78256_a(CATEGORIES[i]) / 2;
            if (mouseX <= x - sWH || mouseX >= x + sWH || mouseY <= y - 1 || mouseY >= y + 9) continue;
            selCat = i;
            currentElement = 0;
            this.func_73866_w_();
            return;
        }
        if (this.filteredSkulls.size() > 0) {
            for (i = Math.min(this.filteredSkulls.size() - 1, currentPage * this.amountInPage); i < Math.min(this.filteredSkulls.size(), (currentPage + 1) * this.amountInPage); ++i) {
                x = space + letterSpace + 16 * (i % this.maxInRow);
                y = 50 + topbar + 16 * (i % this.amountInPage / this.maxInRow);
                if (mouseX <= x || mouseX >= x + 16 || mouseY <= y || mouseY >= y + 16) continue;
                if (GuiHeadCollection.func_146272_n()) {
                    this.field_146297_k.field_71442_b.func_78752_a((ItemStack)this.filteredSkulls.get(i));
                } else {
                    this.field_146297_k.field_71442_b.func_78761_a((ItemStack)this.filteredSkulls.get(i), this.field_146297_k.field_71439_g.field_71071_by.field_70461_c + 36);
                }
                return;
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.lastScreen);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (keyCode == 14) {
            if ((searchString = searchString.substring(0, Math.max(searchString.length() - 1, 0))).length() < 1 && !searchString.equals(filteredString)) {
                this.func_73866_w_();
            }
        } else if (!(keyCode != 28 && keyCode != 156 || searchString.equals(filteredString))) {
            this.func_73866_w_();
        } else if (ChatAllowedCharacters.func_71566_a((char)typedChar) && searchString.length() < 20) {
            searchString = searchString + typedChar;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int topbar = 20;
        int letterSpace = 80;
        int space = (this.field_146294_l - (this.maxInRow * 16 + 3) - letterSpace) / 2;
        int currentPage = currentElement / this.amountInPage;
        int blandColor = HelperGui.getColorFromRGB(255, 150, 200, 255);
        int amountPages = (int)Math.ceil(this.filteredSkulls.size() / this.amountInPage) + 1;
        GuiHeadCollection.func_73734_a((int)space, (int)50, (int)(space + letterSpace + this.maxInRow * 16 + 3), (int)(50 + topbar), (int)HelperGui.getColorFromRGB(200, 0, 122, 255));
        GuiHeadCollection.func_73734_a((int)space, (int)(50 + topbar), (int)(space + 2), (int)(50 + topbar + 161 + topbar), (int)HelperGui.getColorFromRGB(200, 0, 122, 255));
        GuiHeadCollection.func_73734_a((int)(space + letterSpace + this.maxInRow * 16 + 1), (int)(50 + topbar), (int)(space + letterSpace + this.maxInRow * 16 + 3), (int)(50 + topbar + 161 + topbar), (int)HelperGui.getColorFromRGB(200, 0, 122, 255));
        GuiHeadCollection.func_73734_a((int)(space + 2), (int)(50 + topbar + 161), (int)(space + letterSpace + this.maxInRow * 16 + 1), (int)(50 + topbar + 163), (int)HelperGui.getColorFromRGB(200, 0, 122, 255));
        GuiHeadCollection.func_73734_a((int)space, (int)(50 + topbar * 2 + 161), (int)(space + letterSpace + this.maxInRow * 16 + 3), (int)(50 + topbar * 2 + 163), (int)HelperGui.getColorFromRGB(200, 0, 122, 255));
        GuiHeadCollection.func_73734_a((int)space, (int)(50 + topbar), (int)(space + letterSpace + this.maxInRow * 16 + 3), (int)(50 + topbar * 2 + 163), (int)HelperGui.getColorFromRGB(100, 70, 50, 200));
        GuiHeadCollection.func_73734_a((int)(space + 2), (int)(50 + topbar), (int)(space + letterSpace - 2), (int)(50 + topbar + 161), (int)HelperGui.getColorFromRGB(100, 50, 50, 50));
        for (int i = 0; i < CATEGORIES.length; ++i) {
            int x = space + letterSpace / 2;
            int y = i * 15 + 59 + topbar;
            int sWH = this.field_146289_q.func_78256_a(CATEGORIES[i]) / 2;
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)("gui.headcollection.category." + CATEGORIES[i]), (Object[])new Object[0]), x, y, i == selCat || mouseX > x - sWH && mouseX < x + sWH && mouseY > y - 1 && mouseY < y + 9 ? InfinityConfig.CONTRAST_COLOR : InfinityConfig.MAIN_COLOR);
        }
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.headcollection", (Object[])new Object[0]) + " (" + this.filteredSkulls.size() + ")", space + 7, 56, blandColor);
        this.func_73732_a(this.field_146289_q, searchString.length() > 0 ? searchString : I18n.func_135052_a((String)"gui.headcollection.typesearch", (Object[])new Object[0]), this.field_146294_l / 2, 56, blandColor);
        String pageString = I18n.func_135052_a((String)"gui.headcollection.currentpage", (Object[])new Object[]{currentPage + 1, amountPages});
        this.func_73731_b(this.field_146289_q, pageString, space + letterSpace + this.maxInRow * 16 - this.field_146289_q.func_78256_a(pageString), 56, blandColor);
        String nextPage = "-->";
        int nextPageW = this.field_146289_q.func_78256_a(nextPage);
        if (currentPage + 1 < amountPages) {
            boolean selectedN = HelperGui.isMouseInRegion(mouseX, mouseY, space + letterSpace + this.maxInRow * 16 - 3 - nextPageW, 50 + topbar + 168, nextPageW, 8);
            this.func_73731_b(this.field_146289_q, nextPage, space + letterSpace + this.maxInRow * 16 - 3 - nextPageW, 50 + topbar + 168, selectedN ? InfinityConfig.CONTRAST_COLOR : blandColor);
        }
        this.func_73732_a(this.field_146289_q, "" + (currentPage + 1), space + letterSpace + this.maxInRow * 16 - 13 - nextPageW, 50 + topbar + 168, blandColor);
        if (currentPage > 0) {
            String previousPage = "<--";
            boolean selectedP = HelperGui.isMouseInRegion(mouseX, mouseY, space + letterSpace + this.maxInRow * 16 - 25 - nextPageW * 2, 50 + topbar + 168, nextPageW, 8);
            this.func_73731_b(this.field_146289_q, previousPage, space + letterSpace + this.maxInRow * 16 - 25 - nextPageW * 2, 50 + topbar + 168, selectedP ? InfinityConfig.CONTRAST_COLOR : blandColor);
        }
        this.func_73731_b(this.field_146289_q, "From https://minecraft-heads.com API", space + 7, 50 + topbar + 168, blandColor);
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        this.field_146296_j.field_77023_b = 100.0f;
        ItemStack hovered = null;
        if (this.filteredSkulls.size() > 0) {
            for (int i = Math.min(this.filteredSkulls.size() - 1, currentPage * this.amountInPage); i < Math.min(this.filteredSkulls.size(), (currentPage + 1) * this.amountInPage); ++i) {
                int x = space + letterSpace + 16 * (i % this.maxInRow);
                int y = 50 + topbar + 16 * (i % this.amountInPage / this.maxInRow);
                this.field_146296_j.func_180450_b((ItemStack)this.filteredSkulls.get(i), x, y);
                if (mouseX <= x || mouseX >= x + 16 || mouseY <= y || mouseY >= y + 16) continue;
                GuiHeadCollection.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)HelperGui.getColorFromRGB(150, 150, 150, 150));
                hovered = (ItemStack)this.filteredSkulls.get(i);
            }
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
        int searchW = this.field_146289_q.func_78256_a(searchString);
        if (hovered != null) {
            HelperGui.addToolTip(0, 0, this.field_146294_l, this.field_146295_m, mouseX, mouseY, hovered.func_82833_r(), I18n.func_135052_a((String)"gui.headcollection.clickhead", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.headcollection.clickheadshift", (Object[])new Object[0]));
        } else if (!searchString.equals(filteredString) && HelperGui.isMouseInRegion(mouseX, mouseY, this.field_146294_l / 2 - searchW / 2, 56, searchW, 8)) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.headcollection.clicksearch", (Object[])new Object[0]), mouseX, mouseY);
        } else {
            HelperGui.addTooltipTranslated(space + 2, 50 + topbar, letterSpace - 4, 161, mouseX, mouseY, "gui.headcollection.changecategory");
        }
    }

    public void loadSkulls() throws IOException {
        URL url = new URL(API_URL + CATEGORIES[selCat]);
        InputStream st = url.openStream();
        Scanner s = new Scanner(st);
        String line = s.nextLine();
        s.close();
        st.close();
        if (line == null || line.length() < 1) {
            return;
        }
        this.allSkulls.clear();
        JsonParser parser = new JsonParser();
        JsonArray array = (JsonArray)parser.parse(line);
        for (JsonElement e : array) {
            ItemStack skull = new ItemStack(Items.field_151144_bL, 1, 3);
            JsonObject ob = e.getAsJsonObject();
            NBTHelper.getDisplayTag(skull).func_74778_a("Name", ob.get("name").getAsString());
            new InfinitySkullOwnerTag(skull).setId(ob.get("uuid").getAsString()).setValue(ob.get("value").getAsString());
            this.allSkulls.add((Object)skull);
        }
        this.loaded = selCat;
        filteredString = null;
    }

    public boolean func_73868_f() {
        return false;
    }
}

