/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiHelper {
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SWORD = new ResourceLocation("infinity", "items/empty_armor_slot_sword");
    public static final int TITLE_PURPLE = 15546047;
    public static final int MAIN_PURPLE = GuiHelper.getColorFromRGB(255, 150, 0, 200);
    public static final int ALT_PURPLE = GuiHelper.getColorFromRGB(255, 50, 20, 75);
    public static final int MAIN_BLUE = GuiHelper.getColorFromRGB(255, 0, 100, 255);
    public static final int GOOD_GREEN = 5420856;
    public static final int BAD_RED = 16007778;

    @Nullable
    public static GuiScreen getCurrentScreen() {
        return Minecraft.func_71410_x().field_71462_r;
    }

    public static boolean isMouseInRegion(int mouseX, int mouseY, int xPos, int yPos, int width, int height) {
        return mouseX >= xPos && mouseY >= yPos && mouseX < xPos + width && mouseY < yPos + height;
    }

    public static void addTooltipTranslated(GuiButton button, int mouseX, int mouseY, String str) {
        if (button != null && button.field_146124_l && button.field_146125_m) {
            GuiHelper.addTooltipTranslated(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g, mouseX, mouseY, str);
        }
    }

    public static void addTooltip(GuiButton button, int mouseX, int mouseY, String ... str) {
        if (button != null && button.field_146124_l && button.field_146125_m) {
            GuiHelper.addToolTip(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g, mouseX, mouseY, str);
        }
    }

    public static void addTooltipTranslated(int xPos, int yPos, int width, int height, int mouseX, int mouseY, String str) {
        String s;
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 1; i < 10 && I18n.func_188566_a((String)(s = str + "." + i)); ++i) {
            strings.add(I18n.func_135052_a((String)s, (Object[])new Object[0]));
        }
        if (!strings.isEmpty()) {
            GuiHelper.addToolTip(xPos, yPos, width, height, mouseX, mouseY, strings.toArray(new String[strings.size()]));
        } else {
            GuiHelper.addToolTip(xPos, yPos, width, height, mouseX, mouseY, "missing localization: " + str);
        }
    }

    public static void addToolTip(int xPos, int yPos, int width, int height, int mouseX, int mouseY, String ... str) {
        if (GuiHelper.isMouseInRegion(mouseX, mouseY, xPos, yPos, width, height)) {
            if (str.length == 1) {
                GuiHelper.getCurrentScreen().func_146279_a(str[0], mouseX, mouseY);
            } else {
                ArrayList<String> strings = new ArrayList<String>();
                for (String s : str) {
                    strings.add(s);
                }
                GuiHelper.getCurrentScreen().func_146283_a(strings, mouseX, mouseY);
            }
        }
    }

    public static InventoryPlayer getInventoryPlayerCopy(InventoryPlayer source) {
        InventoryPlayer dest = new InventoryPlayer(source.field_70458_d);
        for (int i = 0; i < source.func_70302_i_(); ++i) {
            dest.func_70299_a(i, source.func_70301_a(i).func_77946_l());
        }
        dest.field_70461_c = source.field_70461_c;
        return dest;
    }

    public static void dropStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70458_d.func_71019_a(stack, true);
            Minecraft.func_71410_x().field_71442_b.func_78752_a(stack);
        }
    }

    public static int getColorFromRGB(int alpha, int red, int green, int blue) {
        int color = alpha << 24;
        color += red << 16;
        color += green << 8;
        return color += blue;
    }
}

