/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.action.GuiInfinityButton;

public abstract class GuiInfinity
extends GuiScreen {
    protected final GuiScreen lastScreen;
    protected ItemStackHolder stackHolder;
    protected String title;
    protected GuiInfinityButton backButton;
    protected GuiInfinityButton resetButton;
    protected GuiInfinityButton dropButton;
    protected int buttonID;
    int midX;
    int midY;
    protected GuiInfinityButton saveButton;
    protected boolean hasSave = false;
    private boolean renderStack = false;
    private int stackX = 5;
    private int stackY = 5;
    protected boolean renderTooltip = false;
    protected boolean renderTag = false;

    protected GuiInfinity(GuiScreen lastScreen, ItemStackHolder itemStackHolder) {
        this.lastScreen = lastScreen;
        this.stackHolder = itemStackHolder;
        this.title = I18n.func_135052_a((String)("gui." + this.getNameUnlocalized()), (Object[])new Object[0]);
    }

    protected abstract String getNameUnlocalized();

    protected void setRenderStack(boolean doRender, int x, int y, float scale) {
        this.renderStack = doRender;
        this.stackX = x - 8;
        this.stackY = y - 8;
    }

    public void func_73866_w_() {
        this.midX = this.field_146294_l / 2;
        this.midY = this.field_146295_m / 2;
        this.field_146292_n.clear();
        this.buttonID = 200;
        if (this.hasSave) {
            this.backButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(this.buttonID++, this.midX - 90, this.field_146295_m - 35, 60, 20, I18n.func_135052_a((String)"gui.close", (Object[])new Object[0])));
            this.saveButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(this.buttonID++, this.midX - 30, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.save", (Object[])new Object[0])));
            this.resetButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(this.buttonID++, this.midX - 30, this.field_146295_m - 45, 60, 20, I18n.func_135052_a((String)"gui.reset", (Object[])new Object[0])));
        } else {
            this.backButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(this.buttonID++, this.midX - 90, this.field_146295_m - 35, 60, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0])));
            this.saveButton = null;
            this.resetButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(this.buttonID++, this.midX - 30, this.field_146295_m - 35, 60, 20, I18n.func_135052_a((String)"gui.reset", (Object[])new Object[0])));
        }
        this.dropButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(this.buttonID++, this.midX + 30, this.field_146295_m - 35, 60, 20, I18n.func_135052_a((String)"gui.drop", (Object[])new Object[0])));
    }

    protected void update() {
    }

    protected void back() {
        this.field_146297_k.func_147108_a(this.lastScreen);
        if (this.field_146297_k.field_71462_r == null) {
            this.field_146297_k.func_71381_h();
        }
    }

    protected void save() {
        this.field_146297_k.field_71442_b.func_78761_a(this.getItemStack(), this.field_146297_k.field_71439_g.field_71071_by.field_70461_c + 36);
    }

    protected void drop() {
        if (GuiInfinity.func_146272_n()) {
            boolean shouldAddCount;
            if (this.stackHolder == null || this.getItemStack().func_190926_b()) {
                return;
            }
            String id = this.getItemStack().func_77973_b().getRegistryName().toString();
            String command = "/give @p " + id;
            boolean shouldAddTag = this.getItemStack().func_77942_o();
            boolean shouldAddMeta = shouldAddTag || this.getItemStack().func_77960_j() != 0;
            boolean bl = shouldAddCount = shouldAddMeta || this.getItemStack().func_190916_E() != 1;
            if (shouldAddCount) {
                command = command + " " + this.getItemStack().func_190916_E();
            }
            if (shouldAddMeta) {
                command = command + " " + this.getItemStack().func_77960_j();
            }
            if (shouldAddTag) {
                command = command + " " + this.getItemStack().toString();
            }
            GuiInfinity.func_146275_d((String)command);
        } else {
            HelperGui.dropStack(this.getItemStack());
        }
    }

    protected void reset() {
        if (this.getItemStack().func_77942_o()) {
            this.getItemStack().func_77982_d(null);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.backButton.field_146127_k) {
            this.back();
        } else if (this.hasSave && button.field_146127_k == this.saveButton.field_146127_k) {
            this.save();
        } else if (button.field_146127_k == this.dropButton.field_146127_k) {
            this.drop();
        } else if (button.field_146127_k == this.resetButton.field_146127_k) {
            this.reset();
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.back();
        } else if (this.hasSave && (keyCode == 28 || keyCode == 156)) {
            this.save();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.hasSave && this.saveButton != null) {
            this.saveButton.field_146124_l = this.dropButton.field_146124_l = this.field_146297_k.field_71442_b.func_78758_h();
        }
        this.func_146276_q_();
        if (this.getItemStack().func_77973_b() != Items.field_190931_a && this.getItemStack() != ItemStack.field_190927_a) {
            if (this.renderTooltip || this.renderTag) {
                GlStateManager.func_179094_E();
                GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
                if (this.renderTooltip) {
                    this.func_146285_a(this.getItemStack(), 0, 25);
                }
                if (this.renderTag) {
                    String s = new GsonBuilder().setPrettyPrinting().create().toJson(new JsonParser().parse(this.getItemStack().func_77942_o() ? this.getItemStack().func_77978_p().toString() : "{}"));
                    ArrayList<String> prettyNBTList = new ArrayList<String>();
                    for (String str : s.split("\\n")) {
                        prettyNBTList.add(TextFormatting.DARK_PURPLE + str);
                    }
                    this.func_146283_a(prettyNBTList, 0, this.field_146295_m);
                }
                GlStateManager.func_179121_F();
            }
            if (this.renderStack) {
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                GlStateManager.func_179140_f();
                GlStateManager.func_179091_B();
                GlStateManager.func_179142_g();
                GlStateManager.func_179145_e();
                this.field_146296_j.field_77023_b = 100.0f;
                this.field_146296_j.func_180450_b(this.getItemStack(), this.stackX, this.stackY);
                this.field_146296_j.func_175030_a(this.field_146289_q, this.getItemStack(), this.stackX, this.stackY);
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
        }
        this.func_73732_a(this.field_146289_q, this.title, this.midX, 15, InfinityConfig.MAIN_COLOR);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public boolean func_73868_f() {
        return false;
    }

    public ItemStack getItemStack() {
        return this.stackHolder.getStack();
    }

    public static class ItemStackHolder {
        protected ItemStack stack;

        public ItemStackHolder() {
            this(ItemStack.field_190927_a);
        }

        public ItemStackHolder(ItemStack stack) {
            this.stack = stack;
        }

        public void setStack(ItemStack stack) {
            if (stack != null) {
                this.stack = stack;
            }
        }

        public ItemStack getStack() {
            return this.stack;
        }
    }
}

