/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import ruukas.infinity.Infinity;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.GuiHeadCollection;
import ruukas.infinity.gui.GuiHideFlags;
import ruukas.infinity.gui.GuiInfinity;
import ruukas.infinity.gui.GuiLore;
import ruukas.infinity.gui.GuiNBT;
import ruukas.infinity.gui.GuiNBTAdvanced;
import ruukas.infinity.gui.GuiPick;
import ruukas.infinity.gui.GuiSpecialButtons;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.action.ActionButtons;
import ruukas.infinity.gui.action.GuiActionButton;
import ruukas.infinity.gui.action.GuiActionTextField;
import ruukas.infinity.gui.action.GuiInfinityButton;
import ruukas.infinity.gui.action.GuiNumberField;
import ruukas.infinity.nbt.NBTHelper;

@SideOnly(value=Side.CLIENT)
public class GuiItem
extends GuiInfinity
implements GuiYesNoCallback {
    private GuiInfinityButton nbtButton;
    private GuiInfinityButton nbtAdvButton;
    private GuiInfinityButton hideFlagsButton;
    private GuiInfinityButton sidebarButton;
    private boolean ignoreNextClick = false;
    private GuiInfinityButton headCollectionButton;
    private GuiInfinityButton loadButton;
    private GuiInfinityButton specialButton;
    private GuiInfinityButton discordButton;
    private ArrayList<GuiTextField> textFields = new ArrayList();
    private ArrayList<GuiNumberField> numberFields = new ArrayList();
    private ArrayList<GuiTextField> loreFields = new ArrayList();
    private ArrayList<GuiInfinityButton> loreButtons = new ArrayList();
    private ArrayList<CenterString> centerStrings = new ArrayList();
    private ArrayList<DrawString> drawStrings = new ArrayList();
    private GuiInfinityButton[] colorButtons;
    private ArrayList<GuiInfinityButton> specialButtons = new ArrayList();
    private int slot;

    public GuiItem(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stackHolder, int slot) {
        super(lastScreen, stackHolder);
        this.hasSave = true;
        this.slot = slot;
    }

    public GuiItem(GuiScreen lastScreen, GuiInfinity.ItemStackHolder itemStackHolder) {
        super(lastScreen, itemStackHolder);
        this.slot = -1;
    }

    @Override
    protected String getNameUnlocalized() {
        return "item";
    }

    @Override
    protected void reset() {
        super.reset();
        this.clearCustomName();
    }

    @Override
    protected void save() {
        if (this.slot < 0) {
            this.field_146297_k.field_71442_b.func_78761_a(this.getItemStack(), this.field_146297_k.field_71439_g.field_71071_by.field_70461_c + 36);
        } else {
            this.field_146297_k.field_71442_b.func_78761_a(this.getItemStack(), this.slot);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.setRenderStack(true, this.midX, 40, 1.0f);
        boolean sidebarOn = InfinityConfig.getItemSidebar();
        this.renderTag = !sidebarOn;
        this.renderTooltip = !sidebarOn;
        Keyboard.enableRepeatEvents((boolean)true);
        this.centerStrings.clear();
        this.drawStrings.clear();
        this.numberFields.clear();
        this.textFields.clear();
        this.specialButtons.clear();
        int fieldsAmount = 0;
        GuiActionTextField itemID = new GuiActionTextField(250, this.field_146289_q, this.midX, 25 + 30 * ++fieldsAmount, 75, 20);
        String registryName = this.getItemStack().func_77973_b().getRegistryName().toString();
        itemID.func_146180_a(registryName.toLowerCase().startsWith("minecraft:") ? registryName.replaceFirst("minecraft:", "") : registryName);
        itemID.func_146193_g(InfinityConfig.MAIN_COLOR);
        itemID.func_146203_f(100);
        itemID.action = () -> {
            Item item = Item.func_111206_d((String)itemID.func_146179_b());
            if (item != null) {
                NBTTagCompound tag = this.getItemStack().func_77978_p();
                this.stackHolder.setStack(new ItemStack(item, this.getItemStack().func_190916_E() == 0 ? 1 : this.getItemStack().func_190916_E(), this.getItemStack().func_77960_j()));
                this.getItemStack().func_77982_d(tag);
                this.field_146292_n.clear();
                this.func_73866_w_();
            }
        };
        this.textFields.add(itemID);
        this.centerStrings.add(new CenterString(I18n.func_135052_a((String)"gui.item.id", (Object[])new Object[0]), 31 + 30 * fieldsAmount));
        GuiNumberField count = new GuiNumberField(300 + fieldsAmount, this.field_146289_q, this.midX, 25 + 30 * ++fieldsAmount, 20, 20, 2);
        count.minValue = 1;
        count.maxValue = 64;
        count.setValue(this.getItemStack().func_190916_E());
        count.action = () -> this.getItemStack().func_190920_e(count.getIntValue());
        this.numberFields.add(count);
        this.centerStrings.add(new CenterString(I18n.func_135052_a((String)"gui.item.count", (Object[])new Object[0]), 31 + 30 * fieldsAmount));
        int maxDamage = this.getItemStack().func_77973_b() instanceof ItemBlock || this.getItemStack().func_77958_k() == 0 ? 9999 : this.getItemStack().func_77958_k();
        int digits = ("" + maxDamage).length();
        GuiNumberField damage = new GuiNumberField(300 + fieldsAmount, this.field_146289_q, this.field_146294_l / 2, 25 + 30 * ++fieldsAmount, Math.max(10 * digits, 15), 20, digits);
        damage.minValue = 0;
        damage.maxValue = maxDamage;
        if (this.getItemStack().func_77952_i() > maxDamage) {
            this.getItemStack().func_77964_b(maxDamage);
        }
        damage.setValue(this.getItemStack().func_77952_i());
        damage.action = () -> this.getItemStack().func_77964_b(damage.getIntValue());
        this.numberFields.add(damage);
        this.centerStrings.add(new CenterString(I18n.func_135052_a((String)"gui.item.meta", (Object[])new Object[0]), 31 + 30 * fieldsAmount));
        this.nbtButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(300 + fieldsAmount, this.field_146294_l / 2 - 82, 25 + 30 * ++fieldsAmount, 80, 20, I18n.func_135052_a((String)"gui.nbt", (Object[])new Object[0])));
        this.nbtAdvButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(300 + fieldsAmount, this.field_146294_l / 2 + 2, 25 + 30 * fieldsAmount, 80, 20, I18n.func_135052_a((String)"gui.nbtadv", (Object[])new Object[0])));
        this.hideFlagsButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(320, this.field_146294_l - 75, 74, 70, 20, I18n.func_135052_a((String)"gui.hideflags", (Object[])new Object[0])));
        int sidebarButtonID = 350;
        this.headCollectionButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(sidebarButtonID++, this.field_146294_l / 8 - 40, this.midY - 80, 80, 20, I18n.func_135052_a((String)"gui.headcollection", (Object[])new Object[0])));
        this.headCollectionButton.field_146124_l = sidebarOn;
        this.headCollectionButton.field_146125_m = sidebarOn;
        this.loadButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(sidebarButtonID++, this.field_146294_l / 8 - 40, this.midY - 45, 80, 20, I18n.func_135052_a((String)"gui.pick", (Object[])new Object[0])));
        this.loadButton.field_146124_l = sidebarOn;
        this.loadButton.field_146125_m = sidebarOn;
        this.sidebarButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(sidebarButtonID++, this.field_146294_l / 8 - 40, this.midY - 10, 80, 20, I18n.func_135052_a((String)"gui.item.toggleside", (Object[])new Object[0])));
        this.sidebarButton.field_146124_l = sidebarOn;
        this.sidebarButton.field_146125_m = sidebarOn;
        this.specialButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(sidebarButtonID++, this.field_146294_l / 8 - 40, this.midY + 25, 80, 20, I18n.func_135052_a((String)"gui.specialbutton", (Object[])new Object[0])));
        this.specialButton.field_146124_l = sidebarOn;
        this.specialButton.field_146125_m = sidebarOn;
        this.discordButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(sidebarButtonID++, this.field_146294_l / 8 - 40, this.midY + 60, 80, 20, I18n.func_135052_a((String)"gui.item.discord", (Object[])new Object[0])));
        this.discordButton.field_146124_l = sidebarOn;
        this.discordButton.field_146125_m = sidebarOn;
        int specialID = 500;
        for (GuiActionButton b : ActionButtons.getActionButtons()) {
            boolean added = b.addOnCondition(specialID, this.field_146292_n, this.stackHolder, this.field_146294_l / 2 - 50, 25 + 30 * (fieldsAmount + (specialID - 499)), 100, 20);
            if (!added) continue;
            ++specialID;
        }
        TextFormatting[] formats = TextFormatting.values();
        int colorAmount = 2 + formats.length;
        this.colorButtons = new GuiInfinityButton[colorAmount];
        this.colorButtons[0] = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(130, this.field_146294_l - 1 - 13 * ((colorAmount + 2) / 2) + 13, this.field_146295_m - 30, 13, 15, formats[0].toString().substring(0, 1)));
        this.colorButtons[1] = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(131, this.field_146294_l - 1 - 13 * ((colorAmount + 2) / 2) + 26, this.field_146295_m - 30, 13, 15, TextFormatting.DARK_RED + "%"));
        for (int i = 2; i < colorAmount; ++i) {
            TextFormatting f = formats[i - 2];
            this.colorButtons[i] = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(130 + i, this.field_146294_l - 1 - 13 * ((colorAmount + 2) / 2) + 13 * (i % (colorAmount / 2) + 1), this.field_146295_m - 30 + 15 * (i / (colorAmount / 2)), 13, 15, f.toString() + f.toString().substring(1)));
        }
        int textID = 251;
        this.drawStrings.add(new DrawString(I18n.func_135052_a((String)"gui.item.name", (Object[])new Object[0]), this.field_146294_l - 110, 35));
        GuiActionTextField name = new GuiActionTextField(textID++, this.field_146289_q, this.field_146294_l - 180, 50, 130, 20);
        name.func_146203_f(100);
        name.func_146180_a(this.getItemStack().func_82833_r());
        name.action = () -> this.getItemStack().func_151001_c(name.func_146179_b());
        this.textFields.add(name);
        this.func_189646_b(new GuiInfinityButton(180, this.field_146294_l - 45, 50, 40, 20, I18n.func_135052_a((String)"gui.clear", (Object[])new Object[0])));
        this.drawStrings.add(new DrawString(I18n.func_135052_a((String)"gui.item.lore", (Object[])new Object[0]), this.field_146294_l - 110, 80));
        this.addLoreStuff();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    public void addLoreStuff() {
        void var2_5;
        for (GuiButton guiButton : this.loreButtons) {
            if ((guiButton.field_146127_k < 181 || guiButton.field_146127_k > 186) && guiButton.field_146127_k != 260) continue;
            this.field_146292_n.remove(guiButton);
        }
        this.loreButtons.clear();
        this.loreFields.clear();
        int id = 251;
        boolean bl = false;
        for (int i = 0; i < 5; ++i) {
            if (NBTHelper.getLoreLine(this.getItemStack(), i) != null) {
                this.addLoreTextField(id++, i, true);
                ++var2_5;
                continue;
            }
            this.addLoreTextField(id++, i, false);
            break;
        }
        if (var2_5 >= 5) {
            this.addIfNotIn(new GuiInfinityButton(260, this.field_146294_l - 180, 250, 170, 20, I18n.func_135052_a((String)"gui.lore", (Object[])new Object[0])), this.loreButtons);
        }
    }

    public void addLoreTextField(int id, int line, boolean active) {
        GuiActionTextField lore = new GuiActionTextField(id, this.field_146289_q, this.field_146294_l - 180, 100 + 30 * line, 170, 20);
        lore.func_146203_f(100);
        String loreLine = NBTHelper.getLoreLine(this.getItemStack(), line);
        lore.func_146180_a(loreLine != null ? NBTHelper.getLoreLine(this.getItemStack(), line) : "Lore" + (line + 1));
        lore.action = () -> {
            NBTHelper.editLoreLine(this.getItemStack(), line, lore.func_146179_b());
            if (line < 4 && this.loreFields.size() - 1 == line) {
                this.addLoreTextField(id + 1, line + 1, false);
            } else {
                if (line == 4) {
                    this.addIfNotIn(new GuiInfinityButton(260, this.field_146294_l - 180, 250, 170, 20, I18n.func_135052_a((String)"gui.lore", (Object[])new Object[0])), this.loreButtons);
                }
                this.addIfNotIn(new GuiInfinityButton(182 + line, this.field_146294_l - 195, 100 + 30 * line, 14, 20, TextFormatting.DARK_RED + "X"), this.loreButtons);
            }
        };
        this.loreFields.add(lore);
        if (loreLine != null) {
            this.addIfNotIn(new GuiInfinityButton(182 + line, this.field_146294_l - 195, 100 + 30 * line, 14, 20, TextFormatting.DARK_RED + "X"), this.loreButtons);
        }
        if (this.loreFields.size() > 1) {
            this.addIfNotIn(new GuiInfinityButton(181 + line, this.field_146294_l - 195, 100 + 30 * (line - 1), 14, 20, TextFormatting.DARK_RED + "X"), this.loreButtons);
        }
    }

    private void addIfNotIn(GuiInfinityButton button, ArrayList<GuiInfinityButton> list) {
        boolean exists = false;
        for (GuiInfinityButton b : this.loreButtons) {
            if (b.field_146127_k != button.field_146127_k) continue;
            exists = true;
            break;
        }
        if (!exists) {
            list.add((GuiInfinityButton)this.func_189646_b(button));
        }
    }

    public void func_73876_c() {
        for (GuiNumberField guiNumberField : this.numberFields) {
            guiNumberField.updateCursorCounter();
        }
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.func_146178_a();
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        GuiNumberField f;
        int i;
        super.func_73869_a(typedChar, keyCode);
        for (i = 0; i < this.numberFields.size(); ++i) {
            f = this.numberFields.get(i);
            if (f == null) continue;
            f.textboxKeyTyped(typedChar, keyCode);
        }
        for (i = 0; i < this.textFields.size(); ++i) {
            f = this.textFields.get(i);
            if (f == null) continue;
            f.func_146201_a(typedChar, keyCode);
        }
        for (i = 0; i < this.loreFields.size(); ++i) {
            f = this.loreFields.get(i);
            if (f == null) continue;
            f.func_146201_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (GuiNumberField guiNumberField : this.numberFields) {
            guiNumberField.mouseClicked(mouseX, mouseY, mouseButton);
        }
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        for (GuiTextField guiTextField : this.loreFields) {
            guiTextField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.ignoreNextClick) {
            this.ignoreNextClick = false;
        } else if (!InfinityConfig.getItemSidebar() && mouseX < this.field_146294_l / 4) {
            InfinityConfig.setItemSidebar(true);
            this.func_73866_w_();
        }
    }

    private void clearCustomName() {
        ItemStack copy = this.getItemStack().func_77946_l();
        copy.func_135074_t();
        this.textFields.get(1).func_146180_a(copy.func_82833_r());
        this.getItemStack().func_135074_t();
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        block32: {
            if (button.field_146127_k == this.nbtButton.field_146127_k) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNBT(this, this.getItemStack()));
            } else if (button.field_146127_k == this.nbtAdvButton.field_146127_k) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNBTAdvanced(this, this.getItemStack()));
            } else if (button.field_146127_k == 180) {
                this.clearCustomName();
            } else if (button.field_146127_k > 180 && button.field_146127_k < 187) {
                NBTHelper.removeLoreLine(this.getItemStack(), button.field_146127_k - 181 - 1);
                this.addLoreStuff();
            } else if (button.field_146127_k == 260) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiLore(this, this.stackHolder));
            } else if (button.field_146127_k >= 130 && button.field_146127_k < 130 + this.colorButtons.length) {
                for (int i = 0; i < this.textFields.size() + this.loreFields.size(); ++i) {
                    GuiTextField f;
                    GuiTextField guiTextField = f = i < this.textFields.size() ? this.textFields.get(i) : this.loreFields.get(i - this.textFields.size());
                    if (!f.func_146206_l()) continue;
                    if (button.field_146127_k == 130) {
                        f.func_146180_a(f.func_146179_b().substring(0, f.func_146198_h()) + TextFormatting.values()[0].toString().substring(0, 1) + f.func_146179_b().substring(f.func_146198_h(), f.func_146179_b().length()));
                    } else if (button.field_146127_k == 131) {
                        f.func_146180_a(TextFormatting.func_110646_a((String)f.func_146179_b()));
                    } else {
                        f.func_146180_a(f.func_146179_b().substring(0, f.func_146198_h()) + TextFormatting.values()[button.field_146127_k - 132] + f.func_146179_b().substring(f.func_146198_h(), f.func_146179_b().length()));
                    }
                    break;
                }
            } else if (button.field_146127_k == this.sidebarButton.field_146127_k) {
                InfinityConfig.setItemSidebar(false);
                this.ignoreNextClick = true;
                this.func_73866_w_();
            } else if (button.field_146127_k == this.headCollectionButton.field_146127_k) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiHeadCollection(this));
            } else if (button.field_146127_k == this.loadButton.field_146127_k) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiPick(this, this.stackHolder));
            } else if (button.field_146127_k == this.specialButton.field_146127_k) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiSpecialButtons(this, this.stackHolder));
            } else if (button.field_146127_k == this.discordButton.field_146127_k) {
                try {
                    String dLink = "https://discord.gg/PBCvQyy";
                    URI uri = new URI(dLink);
                    if (this.field_146297_k.field_71474_y.field_74358_q) {
                        this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, dLink, 31102009, true));
                        break block32;
                    }
                    HelperGui.openWebLink(uri);
                }
                catch (URISyntaxException urisyntaxexception) {
                    Infinity.logger.error("Can't open url for {}", new Object[]{this.discordButton, urisyntaxexception});
                }
            } else if (button.field_146127_k == this.hideFlagsButton.field_146127_k) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiHideFlags(this, this.stackHolder));
            } else {
                super.func_146284_a(button);
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GuiTextField textField;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.field_146297_k.field_71442_b.func_78762_g()) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"warning.notcreative", (Object[])new Object[0]), this.field_146294_l / 2, this.field_146295_m - 60, InfinityConfig.CONTRAST_COLOR);
        }
        for (GuiNumberField guiNumberField : this.numberFields) {
            guiNumberField.drawTextBox();
        }
        for (GuiTextField guiTextField : this.textFields) {
            guiTextField.func_146194_f();
        }
        for (GuiTextField guiTextField : this.loreFields) {
            guiTextField.func_146194_f();
        }
        for (CenterString centerString : this.centerStrings) {
            this.func_73731_b(this.field_146289_q, centerString.string, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(centerString.string) - 5, centerString.yPos, InfinityConfig.MAIN_COLOR);
        }
        for (DrawString drawString : this.drawStrings) {
            this.func_73731_b(this.field_146289_q, drawString.string, drawString.xPos, drawString.yPos, InfinityConfig.MAIN_COLOR);
        }
        if (!InfinityConfig.getItemSidebar() && mouseX < this.field_146294_l / 4) {
            GuiItem.func_73734_a((int)0, (int)0, (int)(this.field_146294_l / 4), (int)this.field_146295_m, (int)HelperGui.getColorFromRGB(30, 100, 100, 250));
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.item.toggleside", (Object[])new Object[0]), this.field_146294_l / 8, this.midY - 4, InfinityConfig.CONTRAST_COLOR);
        }
        if ((textField = this.textFields.get(0)).func_146179_b().length() > 9) {
            HelperGui.addToolTip(textField.field_146209_f, textField.field_146210_g, textField.field_146218_h, textField.field_146219_i, mouseX, mouseY, textField.func_146179_b());
        }
        HelperGui.addTooltipTranslated(this.field_146294_l / 2 + 30, this.field_146295_m - 35, 60, 20, mouseX, mouseY, "gui.item.drop.tooltip");
        HelperGui.addTooltipTranslated(this.colorButtons[1], mouseX, mouseY, "gui.item.colorremove.tooltip");
    }

    public void func_73878_a(boolean result, int id) {
        if (id == 31102009) {
            if (result) {
                try {
                    HelperGui.openWebLink(new URI("https://discord.gg/PBCvQyy"));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    private static class DrawString {
        private final String string;
        public int xPos;
        public int yPos;

        public DrawString(String string, int x, int y) {
            this.string = string;
            this.xPos = x;
            this.yPos = y;
        }
    }

    private static class CenterString {
        private final String string;
        public int yPos;

        public CenterString(String string, int y) {
            this.string = string;
            this.yPos = y;
        }
    }
}

