/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityElderGuardian;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.GuiEquipment;
import ruukas.infinity.gui.GuiInfinity;
import ruukas.infinity.gui.GuiVillagerTrades;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.action.GuiInfinityButton;
import ruukas.infinity.gui.monsteregg.GuiEntityTags;
import ruukas.infinity.gui.monsteregg.MobTag;
import ruukas.infinity.gui.monsteregg.MonsterPlacerUtils;

@SideOnly(value=Side.CLIENT)
public class GuiMonsterEgg
extends GuiScreen {
    private GuiInfinity.ItemStackHolder stackHolder;
    private EntityLiving mob = null;
    private final GuiScreen lastScreen;
    private GuiInfinityButton mobButton;
    private GuiInfinityButton mobSpecificButton;
    private GuiInfinityButton equipmentButton;
    private GuiInfinityButton tradeButton;
    protected String title = I18n.func_135052_a((String)"gui.spawnegg", (Object[])new Object[0]);
    protected ArrayList<String> prettyNBTList = new ArrayList();

    public GuiMonsterEgg(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stack) {
        this.lastScreen = lastScreen;
        this.stackHolder = stack;
    }

    public void func_73866_w_() {
        this.mobButton = new GuiInfinityButton(100, this.field_146294_l / 2 - 55, 50, 110, 20, this.getEntityName());
        this.field_146292_n.add(this.mobButton);
        this.field_146292_n.add(new GuiInfinityButton(101, this.field_146294_l / 2 - 75, 50, 20, 20, "<"));
        this.field_146292_n.add(new GuiInfinityButton(102, this.field_146294_l / 2 + 55, 50, 20, 20, ">"));
        this.field_146292_n.add(new GuiInfinityButton(103, this.field_146294_l / 2 - 75, 80, 150, 20, I18n.func_135052_a((String)"gui.spawnegg.entity", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiInfinityButton(104, this.field_146294_l / 2 - 75, 110, 150, 20, I18n.func_135052_a((String)"gui.spawnegg.mob", (Object[])new Object[0])));
        this.mobSpecificButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(105, this.field_146294_l / 2 - 75, 140, 150, 20, I18n.func_135052_a((String)"gui.spawnegg.mobspecific", (Object[])new Object[]{this.getEntityName()})));
        this.equipmentButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(106, this.field_146294_l / 2 - 75, 170, 150, 20, I18n.func_135052_a((String)"tag.armorstand.inventory", (Object[])new Object[0])));
        this.tradeButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(107, this.field_146294_l / 2 - 75, 200, 150, 20, I18n.func_135052_a((String)"gui.villagertrades", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiInfinityButton(200, this.field_146294_l / 2 - 90, this.field_146295_m - 35, 60, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiInfinityButton(202, this.field_146294_l / 2 + 30, this.field_146295_m - 35, 60, 20, I18n.func_135052_a((String)"gui.drop", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiInfinityButton(203, this.field_146294_l / 2 - 30, this.field_146295_m - 35, 60, 20, I18n.func_135052_a((String)"gui.reset", (Object[])new Object[0])));
        this.updateMob();
    }

    public void func_146281_b() {
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.lastScreen);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == 103) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiEntityTags(this, this.getStack(), MobTag.ENTITY_SPECIFIC));
            return;
        }
        if (button.field_146127_k == 104) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiEntityTags(this, this.getStack(), MobTag.MOB_SPECIFIC));
            return;
        }
        if (button.field_146127_k == 105) {
            MobTag[] specificTags = MonsterPlacerUtils.getSpecificTagsForEntity(this.mob);
            if (specificTags.length > 0) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiEntityTags(this, this.getStack(), specificTags));
                return;
            }
            this.mobSpecificButton.field_146124_l = false;
            return;
        }
        if (button.field_146127_k == this.equipmentButton.field_146127_k) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiEquipment(this, this.getStack()));
            return;
        }
        if (button.field_146127_k == this.tradeButton.field_146127_k) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiVillagerTrades(this, this.stackHolder));
            return;
        }
        if (button.field_146127_k == 101) {
            MonsterPlacerUtils.setEntityID(this.getStack(), MonsterPlacerUtils.getPreviousEntityEgg(ItemMonsterPlacer.func_190908_h((ItemStack)this.getStack())));
            this.updateMob();
            return;
        }
        if (button.field_146127_k == 102) {
            MonsterPlacerUtils.setEntityID(this.getStack(), MonsterPlacerUtils.getNextEntityEgg(ItemMonsterPlacer.func_190908_h((ItemStack)this.getStack())));
            this.updateMob();
            return;
        }
        if (button.field_146127_k == 200) {
            this.field_146297_k.func_147108_a(this.lastScreen);
            return;
        }
        if (button.field_146127_k == 202) {
            HelperGui.dropStack(this.getStack());
            return;
        }
        if (button.field_146127_k != 203) return;
        if (this.getStack().func_77942_o() && this.getStack().func_77978_p().func_150297_b("EntityTag", 10)) {
            String id = null;
            if (this.getStack().func_179543_a("EntityTag").func_74764_b("id")) {
                id = this.getStack().func_179543_a("EntityTag").func_74779_i("id");
            }
            this.getStack().func_77978_p().func_82580_o("EntityTag");
            if (id != null) {
                NBTTagCompound entityTag = new NBTTagCompound();
                entityTag.func_74778_a("id", id);
                this.getStack().func_77978_p().func_74782_a("EntityTag", (NBTBase)entityTag);
            }
        }
        this.updateMob();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        this.field_146296_j.func_180450_b(this.getStack(), this.field_146294_l / 2 - 8, 30);
        GlStateManager.func_179121_F();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 15, InfinityConfig.MAIN_COLOR);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179094_E();
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        this.func_146285_a(this.getStack(), 0, 25);
        this.func_146283_a(this.prettyNBTList, 0, this.field_146295_m / 2);
        GlStateManager.func_179121_F();
        if (this.mob != null) {
            this.drawEntityOnScreen((int)((double)(this.field_146294_l / 3) * 2.5), this.field_146295_m - 20, 70);
        }
    }

    public String getEntityName() {
        if (this.getStack().func_77973_b() == Items.field_151063_bx) {
            return I18n.func_135052_a((String)("entity." + EntityList.func_191302_a((ResourceLocation)ItemMonsterPlacer.func_190908_h((ItemStack)this.getStack())) + ".name"), (Object[])new Object[0]);
        }
        return "Empty";
    }

    public boolean func_73868_f() {
        return false;
    }

    public void updateMob() {
        ResourceLocation id;
        Entity entity;
        if (this.getStack().func_77973_b() instanceof ItemMonsterPlacer && (entity = EntityList.func_188429_b((ResourceLocation)(id = ItemMonsterPlacer.func_190908_h((ItemStack)this.getStack())), (World)this.field_146297_k.field_71441_e)) != null && entity instanceof EntityLiving) {
            this.mob = (EntityLiving)entity;
            this.applyItemDataToMob();
        }
        this.equipmentButton.field_146125_m = this.mob instanceof EntityLiving;
        this.tradeButton.field_146125_m = this.mob instanceof EntityVillager;
        this.mobButton.field_146126_j = this.getEntityName();
        this.mobSpecificButton.field_146126_j = I18n.func_135052_a((String)"gui.spawnegg.mobspecific", (Object[])new Object[]{this.getEntityName()});
        this.mobSpecificButton.field_146124_l = MonsterPlacerUtils.getSpecificTagsForEntity(this.mob).length > 0;
        String s = this.getStack().func_77942_o() && this.getStack().func_77978_p().func_150297_b("EntityTag", 10) ? this.getStack().func_179543_a("EntityTag").toString() : "{}";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(s);
        s = gson.toJson(je);
        this.prettyNBTList.clear();
        for (String str : s.split("\\n")) {
            this.prettyNBTList.add(str);
        }
    }

    public void applyItemDataToMob() {
        NBTTagCompound tag = this.getStack().func_77978_p();
        if (tag != null && tag.func_150297_b("EntityTag", 10)) {
            UUID uuid = this.mob.func_110124_au();
            this.mob.func_184221_a(uuid);
            this.mob.func_70020_e(tag.func_74775_l("EntityTag"));
        }
    }

    public void drawEntityOnScreen(int posX, int posY, int scale) {
        EntityLiving ent = this.mob;
        ent.field_70173_aa = (int)this.field_146297_k.field_71441_e.func_72820_D();
        if (ent instanceof EntityElderGuardian) {
            scale /= 2;
        } else if (ent instanceof EntitySquid) {
            posY -= 100;
        } else if (ent instanceof EntityGhast) {
            posY -= 65;
            scale /= 3;
        } else if (ent instanceof EntitySpider && !(ent instanceof EntityCaveSpider)) {
            posX += 30;
        } else if (ent instanceof EntityBat) {
            scale = 100;
            posY += 30;
        } else if (ent instanceof EntitySlime) {
            scale = (int)((float)scale / ent.field_70131_O);
            scale = (int)((float)scale + ent.field_70131_O / 8.0f);
        }
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = this.field_146297_k.func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)this.mob, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public ItemStack getStack() {
        return this.stackHolder.getStack();
    }
}

