/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruukas.infinity.gui.GuiInfinity;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.nbt.itemstack.tag.infinity.InfinityTextureTag;

@SideOnly(value=Side.CLIENT)
public class GuiPaint
extends GuiInfinity {
    private InfinityTextureTag tag = new InfinityTextureTag(this.getItemStack());
    private int currentColor = 255;

    public GuiPaint(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stackHolder) {
        super(lastScreen, stackHolder);
    }

    public int getPixel(int x, int y) {
        int p = x + y * 16;
        int t = p % 4 * 8;
        int mask = 255;
        return this.tag.getPixels()[p / 4] >>> t & mask;
    }

    public void setPixel(int x, int y, int value) {
        value = Math.min(255, Math.max(0, value));
        int p = x + y * 16;
        int t = p % 4 * 8;
        if (x == 1 && y == 0) {
            System.out.println(t);
        }
        int mask = 255 << t;
        int[] pixels = this.tag.getPixels();
        int pixWo = pixels[p / 4] - (pixels[p / 4] & mask);
        pixels[p / 4] = pixWo + (value << t);
        this.tag.setPixels(pixels);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int half = 256;
        int quarter = half / 2;
        int part = half / 16;
        int left = this.midX - quarter;
        int top = this.midY - quarter;
        if (HelperGui.isMouseInRegion(mouseX, mouseY, left, top, half, half)) {
            int x = (mouseX - left) / part;
            int y = (mouseY - top) / part;
            System.out.println("x: " + x + ", y: " + y);
            System.out.println("pixel: " + this.getPixel(x, y));
            this.setPixel(x, y, this.currentColor);
        } else if (HelperGui.isMouseInRegion(mouseX, mouseY, left, top + half + 20, half, 10)) {
            this.currentColor = (int)((double)(mouseX - left) / (double)half * 255.0);
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int pixel24;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int half = 256;
        int quarter = half / 2;
        int part = half / 16;
        int left = this.midX - quarter;
        int top = this.midY - quarter;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int pixel = this.getPixel(i, j);
                pixel24 = -16777216 + ((pixel & 0xE0) << 16) | (pixel & 0x1C) << 11 | (pixel & 3) << 6;
                GuiPaint.func_73734_a((int)(left + part * i), (int)(top + part * j), (int)(left + part * (i + 1)), (int)(top + part * (j + 1)), (int)pixel24);
            }
        }
        double smallerPart = (double)part / 16.0;
        for (int i = 0; i < 255; ++i) {
            pixel24 = -16777216 + ((i & 0xE0) << 16) | (i & 0x1C) << 11 | (i & 3) << 6;
            GuiPaint.func_73734_a((int)(left + (int)(smallerPart * (double)i)), (int)(top + half + 20), (int)(left + (int)(smallerPart * (double)(i + 1))), (int)(top + half + 30), (int)pixel24);
        }
    }

    @Override
    protected String getNameUnlocalized() {
        return "paint";
    }
}

