/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.NonNullList;
import org.lwjgl.input.Keyboard;
import ruukas.infinity.Infinity;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.data.thevoid.VoidController;
import ruukas.infinity.gui.GuiInfinity;
import ruukas.infinity.gui.HelperGui;

public class GuiPick
extends GuiInfinity {
    private PickList pickList;
    private NonNullList<ItemStack> filteredList = NonNullList.func_191196_a();
    private int currentElement = 0;
    private String filteredString = null;
    private String searchString = "";
    private int maxInRow;
    private int amountInPage;
    public static final PickList realmList = new PickList(){

        @Override
        public NonNullList<ItemStack> getStackList() {
            return Infinity.realmController.getStackList();
        }

        @Override
        public String getName() {
            return I18n.func_135052_a((String)"itemGroup.realm", (Object[])new Object[0]);
        }
    };
    public static final PickList voidList = new PickList(){

        @Override
        public NonNullList<ItemStack> getStackList() {
            NonNullList voidStackList = NonNullList.func_191196_a();
            VoidController.loadVoidToList((NonNullList<ItemStack>)voidStackList);
            return voidStackList;
        }

        @Override
        public String getName() {
            return I18n.func_135052_a((String)"itemGroup.void", (Object[])new Object[0]);
        }
    };
    public static final PickList inventoryList = new PickList(){

        @Override
        public NonNullList<ItemStack> getStackList() {
            InventoryPlayer inv = Minecraft.func_71410_x().field_71439_g.field_71071_by;
            NonNullList invStackList = NonNullList.func_191196_a();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                invStackList.add((Object)stack);
            }
            return invStackList;
        }

        @Override
        public String getName() {
            return Minecraft.func_71410_x().field_71439_g.field_71071_by.func_145748_c_().func_150254_d();
        }
    };

    public GuiPick(GuiScreen lastScreen, GuiInfinity.ItemStackHolder itemStackHolder, PickList pickList) {
        super(lastScreen, itemStackHolder);
        this.pickList = pickList;
    }

    public GuiPick(GuiScreen lastScreen, GuiInfinity.ItemStackHolder itemStackHolder) {
        this(lastScreen, itemStackHolder, realmList);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.resetButton.field_146124_l = false;
        Keyboard.enableRepeatEvents((boolean)true);
        this.setRenderStack(true, this.midX, 35, 1.0f);
        if (!this.searchString.equals(this.filteredString)) {
            this.filteredList.clear();
            for (ItemStack s : this.pickList.getStackList()) {
                if (!s.func_82833_r().toLowerCase().contains(this.searchString.toLowerCase())) continue;
                this.filteredList.add((Object)s);
            }
            this.currentElement = 0;
            this.filteredString = this.searchString;
        }
        this.maxInRow = 8;
        this.amountInPage = this.maxInRow * 10;
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.lastScreen);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (keyCode == 14) {
            this.searchString = this.searchString.substring(0, Math.max(this.searchString.length() - 1, 0));
            if (this.searchString.length() < 1 && !this.searchString.equals(this.filteredString)) {
                this.func_73866_w_();
            }
        } else if (!(keyCode != 28 && keyCode != 156 || this.searchString.equals(this.filteredString))) {
            this.func_73866_w_();
        } else if (ChatAllowedCharacters.func_71566_a((char)typedChar) && this.searchString.length() < 20) {
            this.searchString = this.searchString + typedChar;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton != 0) {
            return;
        }
        int space = (this.field_146294_l - this.maxInRow * 16) / 2;
        int nextPageW = this.field_146289_q.func_78256_a("-->");
        int topbar = 20;
        int currentPage = this.currentElement / this.amountInPage;
        int amountPages = (int)Math.ceil(this.filteredList.size() / this.amountInPage) + 1;
        int searchW = this.field_146289_q.func_78256_a(this.searchString);
        if (this.searchString.length() > 0 && !this.searchString.equals(this.filteredString) && HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - searchW / 2, 56, searchW, 8)) {
            this.func_73866_w_();
        } else {
            if (currentPage + 1 < amountPages && HelperGui.isMouseInRegion(mouseX, mouseY, this.midX + 10, 70 + topbar + 168, nextPageW, 8)) {
                this.currentElement = Math.min(this.filteredList.size() - 1, (currentPage + 1) * this.amountInPage);
                return;
            }
            if (currentPage > 0 && HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - 10 - nextPageW, 70 + topbar + 168, nextPageW, 8)) {
                this.currentElement = Math.max(0, (currentPage - 1) * this.amountInPage);
                return;
            }
            if (mouseX < space) {
                if (this.pickList != realmList && HelperGui.isMouseInRegion(mouseX, mouseY, space - this.field_146289_q.func_78256_a(realmList.getName()) - 10, 100, this.field_146289_q.func_78256_a(realmList.getName()), 8)) {
                    this.pickList = realmList;
                    this.filteredString = null;
                    this.func_73866_w_();
                } else if (this.pickList != voidList && HelperGui.isMouseInRegion(mouseX, mouseY, space - this.field_146289_q.func_78256_a(voidList.getName()) - 10, 120, this.field_146289_q.func_78256_a(voidList.getName()), 8)) {
                    this.pickList = voidList;
                    this.filteredString = null;
                    this.func_73866_w_();
                } else if (this.pickList != inventoryList && HelperGui.isMouseInRegion(mouseX, mouseY, space - this.field_146289_q.func_78256_a(inventoryList.getName()) - 10, 140, this.field_146289_q.func_78256_a(inventoryList.getName()), 8)) {
                    this.pickList = inventoryList;
                    this.filteredString = null;
                    this.func_73866_w_();
                }
                return;
            }
        }
        if (this.filteredList.size() > 0) {
            for (int i = Math.min(this.filteredList.size() - 1, currentPage * this.amountInPage); i < Math.min(this.filteredList.size(), (currentPage + 1) * this.amountInPage); ++i) {
                int x = space + 16 * (i % this.maxInRow);
                int y = 70 + topbar + 16 * (i % this.amountInPage / this.maxInRow);
                if (mouseX <= x || mouseX >= x + 16 || mouseY <= y || mouseY >= y + 16) continue;
                this.stackHolder.setStack((ItemStack)this.filteredList.get(i));
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int topbar = 20;
        int space = (this.field_146294_l - (this.maxInRow * 16 + 3)) / 2;
        int currentPage = this.currentElement / this.amountInPage;
        int blandColor = HelperGui.getColorFromRGB(255, 150, 200, 255);
        int amountPages = (int)Math.ceil(this.filteredList.size() / this.amountInPage) + 1;
        this.func_73732_a(this.field_146289_q, this.pickList.getName(), this.midX, 60, InfinityConfig.CONTRAST_COLOR);
        this.func_73732_a(this.field_146289_q, this.searchString.length() > 0 ? this.searchString : I18n.func_135052_a((String)"gui.headcollection.typesearch", (Object[])new Object[0]), this.midX, 73, blandColor);
        this.func_73731_b(this.field_146289_q, realmList.getName(), space - this.field_146289_q.func_78256_a(realmList.getName()) - 10, 100, this.pickList == realmList ? InfinityConfig.CONTRAST_COLOR : InfinityConfig.MAIN_COLOR);
        this.func_73731_b(this.field_146289_q, voidList.getName(), space - this.field_146289_q.func_78256_a(voidList.getName()) - 10, 120, this.pickList == voidList ? InfinityConfig.CONTRAST_COLOR : InfinityConfig.MAIN_COLOR);
        this.func_73731_b(this.field_146289_q, inventoryList.getName(), space - this.field_146289_q.func_78256_a(inventoryList.getName()) - 10, 140, this.pickList == inventoryList ? InfinityConfig.CONTRAST_COLOR : InfinityConfig.MAIN_COLOR);
        String nextPage = "-->";
        int nextPageW = this.field_146289_q.func_78256_a(nextPage);
        if (currentPage + 1 < amountPages) {
            boolean selectedN = HelperGui.isMouseInRegion(mouseX, mouseY, this.midX + 10, 70 + topbar + 168, nextPageW, 8);
            this.func_73731_b(this.field_146289_q, nextPage, this.midX + 10, 70 + topbar + 168, selectedN ? InfinityConfig.CONTRAST_COLOR : blandColor);
        }
        this.func_73732_a(this.field_146289_q, "" + (currentPage + 1), this.midX, 70 + topbar + 168, blandColor);
        if (currentPage > 0) {
            String previousPage = "<--";
            boolean selectedP = HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - nextPageW - 10, 70 + topbar + 168, nextPageW, 8);
            this.func_73731_b(this.field_146289_q, previousPage, this.midX - nextPageW - 10, 70 + topbar + 168, selectedP ? InfinityConfig.CONTRAST_COLOR : blandColor);
        }
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        ItemStack hovered = null;
        if (this.filteredList.size() > 0) {
            GlStateManager.func_179145_e();
            this.field_146296_j.field_77023_b = 100.0f;
            for (int i = Math.min(this.filteredList.size() - 1, currentPage * this.amountInPage); i < Math.min(this.filteredList.size(), (currentPage + 1) * this.amountInPage); ++i) {
                int x = space + 16 * (i % this.maxInRow);
                int y = 70 + topbar + 16 * (i % this.amountInPage / this.maxInRow);
                this.field_146296_j.func_180450_b((ItemStack)this.filteredList.get(i), x, y);
                this.field_146296_j.func_180453_a(this.field_146289_q, (ItemStack)this.filteredList.get(i), x, y, null);
                if (mouseX <= x || mouseX >= x + 16 || mouseY <= y || mouseY >= y + 16) continue;
                GuiPick.func_73734_a((int)x, (int)y, (int)(x + 16), (int)(y + 16), (int)HelperGui.getColorFromRGB(150, 150, 150, 150));
                hovered = (ItemStack)this.filteredList.get(i);
            }
            GlStateManager.func_179140_f();
        }
        int searchW = this.field_146289_q.func_78256_a(this.searchString);
        if (hovered != null) {
            this.func_146285_a(hovered, mouseX, mouseY);
        } else if (!this.searchString.equals(this.filteredString) && HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - searchW / 2, 56, searchW, 8)) {
            this.func_146279_a(I18n.func_135052_a((String)"gui.headcollection.clicksearch", (Object[])new Object[0]), mouseX, mouseY);
        } else if (HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - 8, 27, 16, 16)) {
            this.func_146285_a(this.getItemStack(), mouseX, mouseY);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    @Override
    protected String getNameUnlocalized() {
        return "pick";
    }

    public static abstract class PickList {
        public abstract NonNullList<ItemStack> getStackList();

        public abstract String getName();
    }
}

