/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.io.IOException;
import java.util.UUID;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.item.ItemArmorStand;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.action.GuiInfinityButton;
import ruukas.infinity.nbt.NBTHelper;

@SideOnly(value=Side.CLIENT)
public class GuiPose
extends GuiScreen {
    private ItemStack stack = ItemStack.field_190927_a;
    private EntityArmorStand armorStand = null;
    private final GuiScreen lastScreen;
    private GuiInfinityButton backButton;
    private GuiInfinityButton resetButton;
    private GuiInfinityButton dropButton;
    protected String title = I18n.func_135052_a((String)"gui.armorstand.pose", (Object[])new Object[0]);

    public GuiPose(GuiScreen lastScreen, ItemStack stack) {
        this.lastScreen = lastScreen;
        this.stack = stack;
    }

    public void func_73866_w_() {
        this.backButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(200, this.field_146294_l / 2 - 90, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0])));
        this.resetButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(201, this.field_146294_l / 2 - 30, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.reset", (Object[])new Object[0])));
        this.dropButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(202, this.field_146294_l / 2 + 30, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.drop", (Object[])new Object[0])));
        int sliders = 0;
        int vertical = 1;
        for (final NBTHelper.EnumPosePart part : NBTHelper.EnumPosePart.values()) {
            this.func_189646_b((GuiButton)new GuiSlider(300 + sliders++, 10, 5 + 25 * vertical, 120, 20, part.getKey() + "-x ", "", 0.0, 359.0, (double)NBTHelper.ArmorStandNBTHelper.getX(this.stack, part), false, true, new GuiSlider.ISlider(){

                public void onChangeSliderValue(GuiSlider slider) {
                    NBTHelper.ArmorStandNBTHelper.setX(GuiPose.this.stack, part, (float)Math.floor(slider.getValue()));
                    GuiPose.this.updateArmorStand();
                }
            }));
            this.func_189646_b((GuiButton)new GuiSlider(300 + sliders++, 135, 5 + 25 * vertical, 120, 20, part.getKey() + "-y ", "", 0.0, 359.0, (double)NBTHelper.ArmorStandNBTHelper.getY(this.stack, part), false, true, new GuiSlider.ISlider(){

                public void onChangeSliderValue(GuiSlider slider) {
                    NBTHelper.ArmorStandNBTHelper.setY(GuiPose.this.stack, part, (float)Math.floor(slider.getValue()));
                    GuiPose.this.updateArmorStand();
                }
            }));
            this.func_189646_b((GuiButton)new GuiSlider(300 + sliders++, 260, 5 + 25 * vertical, 120, 20, part.getKey() + "-z ", "", 0.0, 359.0, (double)NBTHelper.ArmorStandNBTHelper.getZ(this.stack, part), false, true, new GuiSlider.ISlider(){

                public void onChangeSliderValue(GuiSlider slider) {
                    NBTHelper.ArmorStandNBTHelper.setZ(GuiPose.this.stack, part, (float)Math.floor(slider.getValue()));
                    GuiPose.this.updateArmorStand();
                }
            }));
            ++vertical;
        }
        this.updateArmorStand();
    }

    public void func_146281_b() {
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a(this.backButton);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.backButton.field_146127_k) {
            this.field_146297_k.func_147108_a(this.lastScreen);
        } else if (button.field_146127_k == this.resetButton.field_146127_k) {
            NBTHelper.getEntityTag(this.stack).func_82580_o("Pose");
            NBTHelper.removeEntityTagIfEmpty(this.stack);
            this.updateArmorStand();
        } else if (button.field_146127_k == this.dropButton.field_146127_k) {
            HelperGui.dropStack(this.stack);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        if (this.armorStand != null) {
            this.drawEntityOnScreen((int)((double)(this.field_146294_l / 3) * 2.5), this.field_146295_m - 50, 120);
        }
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 15, InfinityConfig.MAIN_COLOR);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        HelperGui.addTooltipTranslated(this.resetButton, mouseX, mouseY, "gui.armorstand.pose.reset");
    }

    public boolean func_73868_f() {
        return false;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public void updateArmorStand() {
        EntityArmorStand entity;
        if (this.stack.func_77973_b() instanceof ItemArmorStand && (entity = new EntityArmorStand((World)this.field_146297_k.field_71441_e)) != null && entity instanceof EntityArmorStand) {
            this.armorStand = entity;
            this.applyItemDataToMob();
        }
    }

    public void applyItemDataToMob() {
        NBTTagCompound tag = this.stack.func_77978_p();
        if (tag != null && tag.func_150297_b("EntityTag", 10)) {
            UUID uuid = this.armorStand.func_110124_au();
            this.armorStand.func_184221_a(uuid);
            this.armorStand.func_70020_e(tag.func_74775_l("EntityTag"));
        }
    }

    public void drawEntityOnScreen(int posX, int posY, int scale) {
        EntityArmorStand ent = this.armorStand;
        ent.field_70173_aa = (int)this.field_146297_k.field_71441_e.func_72820_D();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)40.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = this.field_146297_k.func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)this.armorStand, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }
}

