/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.io.IOException;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.gui.GuiColor;
import ruukas.infinity.gui.GuiInfinity;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.action.GuiInfinityButton;
import ruukas.infinity.gui.action.GuiNumberField;
import ruukas.infinity.nbt.itemstack.tag.InfinityCustomPotionEffectList;
import ruukas.infinity.nbt.itemstack.tag.custompotioneffects.InfinityPotionEffectTag;

@SideOnly(value=Side.CLIENT)
public class GuiPotion
extends GuiInfinity {
    private GuiNumberField level;
    private GuiNumberField time;
    private GuiInfinityButton colorButton;
    private GuiInfinityButton particleButton;
    private boolean showParticles = true;
    private int rotOff = 0;
    private int mouseDist = 0;
    private ItemStack potionIcon;

    public GuiPotion(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stackHolder) {
        super(lastScreen, stackHolder);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.level = new GuiNumberField(100, this.field_146289_q, 15, this.field_146295_m - 33, 40, 18, 3);
        this.level.minValue = 1;
        this.level.maxValue = 127;
        this.level.setValue(1);
        this.time = new GuiNumberField(101, this.field_146289_q, 15, this.field_146295_m - 60, 40, 18, 5);
        this.time.minValue = 1;
        this.time.maxValue = 99999;
        this.time.setValue(1);
        this.colorButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(150, 15, this.field_146295_m - 120, 80, 20, I18n.func_135052_a((String)"gui.color", (Object[])new Object[0])));
        this.particleButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(151, 15, this.field_146295_m - 90, 80, 20, I18n.func_135052_a((String)("gui.potion.showparticles." + (this.showParticles ? "1" : "0")), (Object[])new Object[0])));
        this.potionIcon = new ItemStack((Item)Items.field_151068_bn);
        PotionUtils.func_185188_a((ItemStack)this.potionIcon, (PotionType)((PotionType)PotionType.field_185176_a.func_148754_a(0)));
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.level.updateCursorCounter();
        this.time.updateCursorCounter();
        if (Math.abs(this.mouseDist - this.field_146295_m / 3) >= 16) {
            ++this.rotOff;
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a(this.backButton);
        } else {
            this.level.textboxKeyTyped(typedChar, keyCode);
            this.time.textboxKeyTyped(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.level.mouseClicked(mouseX, mouseY, mouseButton);
        this.time.mouseClicked(mouseX, mouseY, mouseButton);
        InfinityCustomPotionEffectList list = new InfinityCustomPotionEffectList(this.getItemStack());
        InfinityPotionEffectTag[] activeEffects = list.getAll();
        int start = this.midY - 5 * activeEffects.length;
        if (activeEffects.length > 0 && HelperGui.isMouseInRegion(mouseX, mouseY, 0, start, 5 + this.field_146289_q.func_78256_a("Unbreaking 32767"), 10 * activeEffects.length)) {
            list.removePotionEffect((mouseY - start) / 10);
            return;
        }
        int r = this.field_146295_m / 3;
        if (Math.abs(this.mouseDist - r) < 16) {
            Set keyset = Potion.field_188414_b.func_148742_b();
            double angle = Math.PI * 2 / (double)keyset.size();
            int lowDist = Integer.MAX_VALUE;
            Potion type = null;
            int i = 0;
            for (ResourceLocation key : keyset) {
                int y;
                int distY;
                double angleI;
                int x;
                int distX;
                int dist;
                if ((dist = (int)Math.sqrt((distX = (x = (int)((double)this.midX + (double)r * Math.cos(angleI = (double)this.rotOff / 60.0 + angle * (double)i++))) - mouseX) * distX + (distY = (y = (int)((double)this.midY + (double)r * Math.sin(angleI))) - mouseY) * distY)) >= 10 || dist >= lowDist) continue;
                lowDist = dist;
                type = (Potion)Potion.field_188414_b.func_82594_a((Object)key);
            }
            if (type != null) {
                new InfinityCustomPotionEffectList(this.getItemStack()).set(new PotionEffect(type, this.time.getIntValue() * 20, this.level.getIntValue() - 1, false, this.showParticles));
            }
        } else if (mouseX > this.midX - 15 && mouseX < this.midX + 15 && mouseY > this.midY - 15 && mouseY < this.midY + 15) {
            Set keyset = Potion.field_188414_b.func_148742_b();
            for (ResourceLocation key : keyset) {
                new InfinityCustomPotionEffectList(this.getItemStack()).set(new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)key), this.time.getIntValue() * 20, this.level.getIntValue() - 1));
            }
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k == this.colorButton.field_146127_k) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiColor(Minecraft.func_71410_x().field_71462_r, this.getItemStack()));
        } else if (button.field_146127_k == this.particleButton.field_146127_k) {
            this.showParticles = !this.showParticles;
            this.func_73866_w_();
        }
        super.func_146284_a(button);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        InfinityPotionEffectTag[] potionTags = new InfinityCustomPotionEffectList(this.getItemStack()).getAll();
        for (int i = 0; i < potionTags.length; ++i) {
            InfinityPotionEffectTag e = potionTags[i];
            PotionEffect effect = e.getEffect();
            if (effect != null) {
                int ampli = effect.func_76458_c();
                this.func_73731_b(this.field_146289_q, (effect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.BLUE) + I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) + " (" + (ampli + 1) + ")" + (ampli > 1 ? " " + I18n.func_135052_a((String)("potion.potency." + ampli), (Object[])new Object[0]).trim() : "") + (effect.func_188418_e() ? " P:S" : " P:H"), 5, this.midY + i * 10 - potionTags.length * 5, InfinityConfig.MAIN_COLOR);
                continue;
            }
            this.func_73731_b(this.field_146289_q, "Unknown ID (" + e.getId() + ")", 5, this.midY + i * 10 - potionTags.length * 5, 16007778);
        }
        this.level.drawTextBox();
        this.time.drawTextBox();
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.potion.time", (Object[])new Object[0]), 62, this.field_146295_m - 56, InfinityConfig.MAIN_COLOR);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"gui.potion.level", (Object[])new Object[0]), 62, this.field_146295_m - 29, InfinityConfig.MAIN_COLOR);
        int distX = this.midX - mouseX;
        int distY = this.midY - mouseY;
        this.mouseDist = (int)Math.sqrt(distX * distX + distY * distY);
        int r = this.field_146295_m / 3;
        Set keyset = Potion.field_188414_b.func_148742_b();
        double angle = Math.PI * 2 / (double)keyset.size();
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        GlStateManager.func_179152_a((float)5.0f, (float)5.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(this.field_146294_l / 10), (float)(this.field_146295_m / 10), (float)0.0f);
        GlStateManager.func_179114_b((float)(this.rotOff * 3), (float)0.0f, (float)0.0f, (float)-1.0f);
        this.field_146296_j.func_180450_b(this.getItemStack(), -8, -8);
        GlStateManager.func_179114_b((float)(this.rotOff * 3), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(-(this.field_146294_l / 10)), (float)(-(this.field_146295_m / 10)), (float)0.0f);
        GlStateManager.func_179139_a((double)0.2, (double)0.2, (double)1.0);
        int i = 0;
        for (ResourceLocation key : keyset) {
            double angleI = ((double)this.rotOff + (Math.abs(this.mouseDist - r) >= 16 ? (double)partialTicks : 0.0)) / 60.0 + angle * (double)i++;
            int x = (int)((double)this.midX + (double)r * Math.cos(angleI));
            int y = (int)((double)this.midY + (double)r * Math.sin(angleI));
            PotionEffect potEff = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)key), 20, this.level.getIntValue() - 1);
            String displayString = (potEff.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.BLUE) + I18n.func_135052_a((String)potEff.func_76453_d(), (Object[])new Object[0]);
            if (potEff.func_76458_c() > 0) {
                displayString = displayString + " " + I18n.func_135052_a((String)("potion.potency." + potEff.func_76458_c()), (Object[])new Object[0]).trim();
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            this.func_73732_a(this.field_146289_q, displayString, x, y - 17, InfinityConfig.MAIN_COLOR);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
            this.field_146296_j.func_180450_b(this.potionIcon, x - 8, y - 8);
            GuiPotion.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 1), (int)(y + 1), (int)HelperGui.getColorFromRGB(255, 255, 255, 255));
        }
        if (mouseX > this.midX - 15 && mouseX < this.midX + 15 && mouseY > this.midY - 15 && mouseY < this.midY + 15) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)300.0f);
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.enchanting.addall", (Object[])new Object[0]), this.midX, this.midY, InfinityConfig.CONTRAST_COLOR);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-300.0f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    @Override
    protected String getNameUnlocalized() {
        return "potion";
    }
}

