/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui;

import java.net.URI;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import ruukas.infinity.Infinity;

public class HelperGui {
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SWORD = new ResourceLocation("infinity", "items/empty_armor_slot_sword");
    public static final int GOOD_GREEN = 5420856;
    public static final int BAD_RED = 16007778;

    @Nullable
    public static GuiScreen getCurrentScreen() {
        return Minecraft.func_71410_x().field_71462_r;
    }

    public static boolean isMouseInRegion(int mouseX, int mouseY, int xPos, int yPos, int width, int height) {
        return mouseX >= xPos && mouseY >= yPos && mouseX < xPos + width && mouseY < yPos + height;
    }

    public static void addTooltipTranslated(GuiButton button, int mouseX, int mouseY, String str) {
        if (button != null && button.field_146124_l && button.field_146125_m) {
            HelperGui.addTooltipTranslated(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g, mouseX, mouseY, str);
        }
    }

    public static void addTooltip(GuiButton button, int mouseX, int mouseY, String ... str) {
        if (button != null && button.field_146124_l && button.field_146125_m) {
            HelperGui.addToolTip(button.field_146128_h, button.field_146129_i, button.field_146120_f, button.field_146121_g, mouseX, mouseY, str);
        }
    }

    public static void addTooltipTranslated(int xPos, int yPos, int width, int height, int mouseX, int mouseY, String str) {
        String s;
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 1; i < 10 && I18n.func_188566_a((String)(s = str + "." + i)); ++i) {
            strings.add(I18n.func_135052_a((String)s, (Object[])new Object[0]));
        }
        if (!strings.isEmpty()) {
            HelperGui.addToolTip(xPos, yPos, width, height, mouseX, mouseY, strings.toArray(new String[strings.size()]));
        } else {
            HelperGui.addToolTip(xPos, yPos, width, height, mouseX, mouseY, "missing localization: " + str);
        }
    }

    public static void addToolTip(int xPos, int yPos, int width, int height, int mouseX, int mouseY, String ... str) {
        if (HelperGui.isMouseInRegion(mouseX, mouseY, xPos, yPos, width, height)) {
            ArrayList<String> strings = new ArrayList<String>();
            for (String s : str) {
                strings.add(s);
            }
            GuiUtils.drawHoveringText(strings, (int)mouseX, (int)mouseY, (int)width, (int)height, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }

    public static InventoryPlayer getInventoryPlayerCopy(InventoryPlayer source) {
        InventoryPlayer dest = new InventoryPlayer(source.field_70458_d);
        for (int i = 0; i < source.func_70302_i_(); ++i) {
            dest.func_70299_a(i, source.func_70301_a(i).func_77946_l());
        }
        dest.field_70461_c = source.field_70461_c;
        return dest;
    }

    public static void dropStack(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70458_d.func_71019_a(stack, true);
            Minecraft.func_71410_x().field_71442_b.func_78752_a(stack);
        }
    }

    public static int getColorFromRGB(int alpha, int red, int green, int blue) {
        int color = alpha << 24;
        color += red << 16;
        color += green << 8;
        return color += blue;
    }

    public static void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            Infinity.logger.error("Couldn't open link: {}", new Object[]{throwable == null ? "<UNKNOWN>" : throwable.getMessage()});
        }
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, Entity ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.1f, (float)0.0f, (float)1.0f);
        float f1 = ent.field_70177_z;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 25.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a(ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70177_z = f1;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
    }

    public static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.1f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 25.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 25.0f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public static void renderBanner(int posX, int posY, int scale, float mouseX, float mouseY, TileEntityBanner banner) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseX / 40.0f)) * 20.5f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 2.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178633_a(false);
        TileEntityRendererDispatcher.field_147556_a.func_147549_a((TileEntity)banner, 0.0, 0.0, 0.0, Minecraft.func_71410_x().func_184121_ak());
        rendermanager.func_178633_a(true);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }
}

