/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui.armorstand;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import ruukas.infinity.nbt.NBTHelper;

public class InventoryArmorStandEquipment
implements IInventory {
    public final NonNullList<ItemStack> armor = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    public final NonNullList<ItemStack> hands = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private ItemStack armorStandStack;
    public EntityArmorStand entityStand;

    public InventoryArmorStandEquipment(ItemStack armorstand) {
        this.armorStandStack = armorstand;
        this.entityStand = new EntityArmorStand((World)Minecraft.func_71410_x().field_71441_e);
        this.applyItemDataToMob();
    }

    public void applyItemDataToMob() {
        NBTTagCompound tag = this.armorStandStack.func_77978_p();
        if (tag != null && tag.func_150297_b("EntityTag", 10)) {
            UUID uuid = this.entityStand.func_110124_au();
            this.entityStand.func_184221_a(uuid);
            this.entityStand.func_70020_e(tag.func_74775_l("EntityTag"));
        }
    }

    public static NonNullList<ItemStack> getStackList(ItemStack stack, boolean hands) {
        NonNullList stackList = NonNullList.func_191197_a((int)(hands ? 2 : 4), (Object)ItemStack.field_190927_a);
        if (!NBTHelper.hasEntityTag(stack)) {
            return stackList;
        }
        NBTTagCompound entityTag = NBTHelper.getEntityTag(stack);
        NBTTagList nbttaglist = entityTag.func_150295_c(hands ? "HandItems" : "ArmorItems", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            int j;
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            if (nbttagcompound.func_82582_d() || (j = nbttagcompound.func_74771_c("Slot") & 0xFF) < 0 || j >= stackList.size()) continue;
            stackList.set(j, (Object)new ItemStack(nbttagcompound));
        }
        return stackList;
    }

    public void saveToNBT(NonNullList<ItemStack> stackList, boolean hands) {
        NBTTagCompound tag = NBTHelper.getEntityTag(this.armorStandStack);
        NBTTagList nbttaglist = new NBTTagList();
        int empty = 0;
        for (int i = 0; i < stackList.size(); ++i) {
            ItemStack itemstack = (ItemStack)stackList.get(i);
            if (!itemstack.func_190926_b()) {
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                nbttagcompound.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(nbttagcompound);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound);
                continue;
            }
            nbttaglist.func_74742_a((NBTBase)new NBTTagCompound());
            ++empty;
        }
        if (empty == stackList.size()) {
            tag.func_82580_o(hands ? "HandItems" : "ArmorItems");
        } else {
            tag.func_74782_a(hands ? "HandItems" : "ArmorItems", (NBTBase)nbttaglist);
        }
        NBTHelper.removeEntityTagIfEmpty(this.armorStandStack);
        this.applyItemDataToMob();
    }

    public String func_70005_c_() {
        return this.armorStandStack.func_82833_r() + " " + I18n.func_135052_a((String)"tag.armorstand.inventory", (Object[])new Object[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70302_i_() {
        return 6;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : InventoryArmorStandEquipment.getStackList(this.armorStandStack, true)) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        for (ItemStack itemstack : InventoryArmorStandEquipment.getStackList(this.armorStandStack, false)) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (index >= this.func_70302_i_() || index < 0) {
            return ItemStack.field_190927_a;
        }
        if (index < 2) {
            return (ItemStack)InventoryArmorStandEquipment.getStackList(this.armorStandStack, true).get(index);
        }
        return (ItemStack)InventoryArmorStandEquipment.getStackList(this.armorStandStack, false).get(index - 2);
    }

    public ItemStack func_70298_a(int index, int count) {
        boolean hands = index < 2;
        NonNullList<ItemStack> stackList = InventoryArmorStandEquipment.getStackList(this.armorStandStack, hands);
        ItemStack itemstack = ItemStackHelper.func_188382_a(stackList, (int)(hands ? index : index - 2), (int)count);
        this.saveToNBT(stackList, hands);
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        boolean hands = index < 2;
        NonNullList<ItemStack> stackList = InventoryArmorStandEquipment.getStackList(this.armorStandStack, hands);
        ItemStack stack = (ItemStack)stackList.remove(hands ? index : index - 2);
        this.saveToNBT(stackList, hands);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean hands = index < 2;
        NonNullList<ItemStack> stackList = InventoryArmorStandEquipment.getStackList(this.armorStandStack, hands);
        stackList.set(hands ? index : index - 2, (Object)stack);
        this.saveToNBT(stackList, hands);
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.saveToNBT((NonNullList<ItemStack>)NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a), true);
        this.saveToNBT((NonNullList<ItemStack>)NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a), false);
    }
}

