/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui.monsteregg;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ruukas.infinity.gui.monsteregg.GuiTagButton;
import ruukas.infinity.gui.monsteregg.GuiTagButtonString;
import ruukas.infinity.gui.monsteregg.GuiTagSlider;
import ruukas.infinity.gui.monsteregg.MobTag;
import ruukas.infinity.gui.monsteregg.MobTagSlider;
import ruukas.infinity.gui.monsteregg.MobTagString;
import ruukas.infinity.gui.monsteregg.MobTagToggle;
import ruukas.infinity.gui.monsteregg.MonsterPlacerUtils;

@SideOnly(value=Side.CLIENT)
public class GuiTagRowList
extends GuiListExtended {
    private final List<Row> rows = Lists.newArrayList();
    public final ItemStack stack;
    public final GuiScreen parentScreen;

    public GuiTagRowList(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn, GuiScreen parentScreen, ItemStack stack, MobTag ... mobTags) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
        this.field_148163_i = false;
        this.stack = stack;
        this.parentScreen = parentScreen;
        for (int i = 0; i < mobTags.length; i += 2) {
            MobTag tags = mobTags[i];
            MobTag tags1 = i < mobTags.length - 1 ? mobTags[i + 1] : null;
            GuiButton guibutton = this.createButton(i + 1, widthIn / 2 - 155, 0, tags);
            GuiButton guibutton1 = this.createButton(i + 2, widthIn / 2 - 155 + 160, 0, tags1);
            this.rows.add(new Row(guibutton, guibutton1, this));
        }
    }

    private GuiButton createButton(int id, int x, int y, MobTag mobTag) {
        if (mobTag == null) {
            return null;
        }
        if (mobTag instanceof MobTagSlider) {
            return new GuiTagSlider(id, x, y, (MobTagSlider)mobTag, this.stack);
        }
        if (mobTag instanceof MobTagToggle) {
            return new GuiTagButton(id, x, y, mobTag, MonsterPlacerUtils.getButtonText(mobTag, this.stack));
        }
        if (mobTag instanceof MobTagString) {
            return new GuiTagButtonString(id, x, y, (MobTagString)mobTag, this.parentScreen, this.stack);
        }
        return new GuiTagButton(id, x, y, mobTag, MonsterPlacerUtils.getButtonText(mobTag, this.stack));
    }

    public Row getListEntry(int index) {
        return this.rows.get(index);
    }

    protected int func_148127_b() {
        return this.rows.size();
    }

    public int func_148139_c() {
        return 400;
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 32;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Row
    implements GuiListExtended.IGuiListEntry {
        private final Minecraft client = Minecraft.func_71410_x();
        private final GuiButton buttonA;
        private final GuiButton buttonB;
        private final GuiTagRowList listOn;
        private int releasedAmount = 0;

        public Row(GuiButton buttonAIn, GuiButton buttonBIn, GuiTagRowList list) {
            this.buttonA = buttonAIn;
            this.buttonB = buttonBIn;
            this.listOn = list;
        }

        public void func_180790_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            if (this.buttonA != null) {
                this.buttonA.field_146129_i = y;
                this.buttonA.func_146112_a(this.client, mouseX, mouseY);
            }
            if (this.buttonB != null) {
                this.buttonB.field_146129_i = y;
                this.buttonB.func_146112_a(this.client, mouseX, mouseY);
            }
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            if (this.buttonA.func_146116_c(this.client, mouseX, mouseY)) {
                if (this.buttonA instanceof GuiTagButton) {
                    MobTag tag = ((GuiTagButton)this.buttonA).returnMobTag();
                    MonsterPlacerUtils.setOptionValue(tag, this.listOn.stack, 1);
                    this.buttonA.field_146126_j = MonsterPlacerUtils.getButtonText(tag, this.listOn.stack);
                }
                return true;
            }
            if (this.buttonB != null && this.buttonB.func_146116_c(this.client, mouseX, mouseY)) {
                if (this.buttonB instanceof GuiTagButton) {
                    MobTag tag = ((GuiTagButton)this.buttonB).returnMobTag();
                    MonsterPlacerUtils.setOptionValue(tag, this.listOn.stack, 1);
                    this.buttonB.field_146126_j = MonsterPlacerUtils.getButtonText(tag, this.listOn.stack);
                }
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.releasedAmount > 0) {
                if (this.buttonA != null) {
                    this.buttonA.func_146118_a(x, y);
                }
                if (this.buttonB != null) {
                    this.buttonB.func_146118_a(x, y);
                }
            }
            ++this.releasedAmount;
        }

        public void updatePosition(int p_192633_1_, int p_192633_2_, int p_192633_3_, float p_192633_4_) {
        }

        public void func_178011_a(int p_178011_1_, int p_178011_2_, int p_178011_3_) {
        }
    }
}

