/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui.monsteregg;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import ruukas.infinity.gui.monsteregg.MobTag;
import ruukas.infinity.gui.monsteregg.MobTagList;
import ruukas.infinity.gui.monsteregg.MobTagSlider;
import ruukas.infinity.gui.monsteregg.MobTagString;
import ruukas.infinity.gui.monsteregg.MobTagToggle;

public class MonsterPlacerUtils {
    public static void setEntityID(ItemStack stack, ResourceLocation loc) {
        if (loc != null && stack.func_77973_b() instanceof ItemMonsterPlacer) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (!stack.func_77978_p().func_150297_b("EntityTag", 10)) {
                stack.func_77978_p().func_74782_a("EntityTag", (NBTBase)new NBTTagCompound());
            }
            stack.func_179543_a("EntityTag").func_74778_a("id", loc.toString());
        }
    }

    public static ResourceLocation getPreviousEntityEgg(ResourceLocation res) {
        if (res != null) {
            Object[] array;
            int i = 0;
            for (Object otherRes : array = EntityList.field_75627_a.keySet().toArray()) {
                if (res.equals(otherRes)) {
                    return i != 0 ? (ResourceLocation)array[i - 1] : (ResourceLocation)array[array.length - 1];
                }
                ++i;
            }
        }
        return new ResourceLocation("minecraft", "bat");
    }

    public static ResourceLocation getNextEntityEgg(ResourceLocation res) {
        if (res != null) {
            boolean returnNext = false;
            for (ResourceLocation otherRes : EntityList.field_75627_a.keySet()) {
                if (res.equals((Object)otherRes)) {
                    returnNext = true;
                    continue;
                }
                if (!returnNext) continue;
                return otherRes;
            }
        }
        return (ResourceLocation)EntityList.field_75627_a.keySet().toArray()[0];
    }

    public static String getButtonText(MobTag tag, ItemStack stack) {
        if (tag instanceof MobTagSlider) {
            MobTagSlider tagSlider = (MobTagSlider)tag;
            float value = tagSlider.getFloat(stack);
            if (value <= tagSlider.min) {
                return I18n.func_135052_a((String)(tag.getName() + ".off"), (Object[])new Object[]{(int)value});
            }
            return I18n.func_135052_a((String)(tag.getName() + ".on"), (Object[])new Object[]{(int)value});
        }
        if (tag instanceof MobTagToggle) {
            MobTagToggle tagToggle = (MobTagToggle)tag;
            boolean isEnabled = tagToggle.getValue(stack);
            return isEnabled ? I18n.func_135052_a((String)(tag.getName() + ".on"), (Object[])new Object[0]) : I18n.func_135052_a((String)(tag.getName() + ".off"), (Object[])new Object[0]);
        }
        if (tag instanceof MobTagString) {
            return tag.getTranslatedName();
        }
        if (tag instanceof MobTagList) {
            MobTagList tagList = (MobTagList)tag;
            return I18n.func_135052_a((String)(tag.getName() + "." + tagList.getValue(stack)), (Object[])new Object[0]);
        }
        return "No button text found for " + tag.getTranslatedName();
    }

    public static void setOptionValue(MobTag tag, ItemStack stack, int value) {
        if (tag instanceof MobTagToggle) {
            MobTagToggle tagToggle = (MobTagToggle)tag;
            tagToggle.switchToggle(stack);
        } else if (tag instanceof MobTagList) {
            MobTagList tagList = (MobTagList)tag;
            tagList.nextValue(stack);
        }
    }

    public static MobTag[] getSpecificTagsForEntity(EntityLiving ent) {
        if (ent instanceof EntityChicken) {
            return MobTag.CHICKEN_SPECIFIC;
        }
        if (ent instanceof EntityCreeper) {
            return MobTag.CREEPER_SPECIFIC;
        }
        if (ent instanceof EntityEndermite) {
            return MobTag.ENDERMITE_SPECIFIC;
        }
        if (ent instanceof EntityPig) {
            return MobTag.PIG_SPECIFIC;
        }
        if (ent instanceof EntitySheep) {
            return MobTag.SHEEP_SPECIFIC;
        }
        if (ent instanceof EntityShulker) {
            return MobTag.SHULKER_SPECIFIC;
        }
        if (ent instanceof EntitySlime) {
            return MobTag.SLIME_SPECIFIC;
        }
        if (ent instanceof EntityVindicator) {
            return MobTag.VINDICATOR_SPECIFIC;
        }
        if (ent instanceof EntityVillager) {
            return MobTag.VILLAGER_SPECIFIC;
        }
        if (ent instanceof EntityZombie) {
            if (ent instanceof EntityZombieVillager) {
                return MobTag.ZOMBIEVILLAGER_SPECIFIC;
            }
            if (ent instanceof EntityPigZombie) {
                return MobTag.ZOMBIEPIGMAN_SPECIFIC;
            }
            return MobTag.ZOMBIE_SPECIFIC;
        }
        return new MobTag[0];
    }
}

