/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.gui.nbt;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import ruukas.infinity.gui.HelperGui;
import ruukas.infinity.gui.nbt.NBTListCompound;
import ruukas.infinity.gui.nbt.NBTListRoot;
import ruukas.infinity.gui.nbt.NBTOption;

public class NBTListElement
extends Gui {
    protected String key = null;
    protected NBTBase tag;
    protected ItemStack icon = ItemStack.field_190927_a;
    protected NBTListCompound parent = null;
    private int x;
    private int y;

    public NBTListElement(String key, NBTBase tag, ItemStack iconStack, int x, int y) {
        this.key = key;
        this.tag = tag;
        this.icon = iconStack;
        this.x = x;
        this.y = y;
    }

    public String getKey() {
        return this.key;
    }

    public String getText() {
        return this.getKey() + " : " + this.tag.toString();
    }

    public String getTypeName() {
        return "Base";
    }

    public String getValue() {
        return this.getTag() != null ? this.getTag().toString() : null;
    }

    public NBTBase getTag() {
        return this.tag;
    }

    public ItemStack getIconStack() {
        return this.icon;
    }

    public void drawIcon(RenderItem itemRender) {
        itemRender.func_180450_b(this.getIconStack(), this.x - 8, this.y - 9);
    }

    public void draw(Minecraft mc, int mouseX, int mouseY) {
        boolean over = this.isMouseOver(mouseX, mouseY);
        this.func_73731_b(mc.field_71466_p, mc.field_71466_p.func_78269_a(this.getText(), 300), this.x + 15, this.y - 5, over ? HelperGui.getColorFromRGB(255, 230, 115, 30) : 0xFFFFFF);
    }

    protected static void drawVerticalStructureLine(int x, int y, int length) {
        NBTListElement.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + 1), (int)(y + length + 1), (int)HelperGui.getColorFromRGB(255, 30, 200, 255));
    }

    protected static void drawHorizontalStructureLine(int x, int y, int length) {
        NBTListElement.func_73734_a((int)(x - 1), (int)(y - 1), (int)(x + length + 1), (int)(y + 1), (int)HelperGui.getColorFromRGB(255, 160, 0, 255));
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        if (this.getRootAsRoot().getSelected() != null) {
            return false;
        }
        int left = this.x - 9;
        int textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(this.getText());
        int right = left + 25 + textWidth;
        int top = this.y - 8;
        int bottom = this.y + 7;
        return mouseX > left && mouseX < right && mouseY > top && mouseY < bottom;
    }

    public void mouseClicked(int x, int y, int mouseButton) {
        if (this.isMouseOver(x, y)) {
            if (mouseButton == 1) {
                NBTListRoot root = (NBTListRoot)this.getRoot();
                root.setSelected(this, x, y);
            } else {
                ((NBTListRoot)this.getRoot()).setFocus(this);
            }
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setPos(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public NBTListElement getRoot() {
        return this.parent != null ? this.parent.getRoot() : this;
    }

    public NBTListRoot getRootAsRoot() {
        NBTListElement root = this.getRoot();
        return root != null && root instanceof NBTListRoot ? (NBTListRoot)root : null;
    }

    public NBTOption[] getOptions() {
        ArrayList<NBTOption> options = new ArrayList<NBTOption>();
        options.add(new NBTOption(){

            @Override
            public String getText() {
                return "Change value";
            }

            @Override
            public void action() {
            }
        });
        options.add(new NBTOption(){

            @Override
            public String getText() {
                return "Remove";
            }

            @Override
            public void action() {
                if (NBTListElement.this.parent != null && NBTListElement.this.parent.children != null) {
                    for (NBTListElement e : NBTListElement.this.parent.children) {
                        if (!e.equals((Object)NBTListElement.this)) continue;
                        NBTListElement.this.parent.children.remove((Object)e);
                        break;
                    }
                    NBTListElement.this.parent.getTagCompound().func_82580_o(NBTListElement.this.getKey());
                }
                NBTListRoot root = NBTListElement.this.getRootAsRoot();
                root.clearSelected();
                root.redoPositions();
            }
        });
        NBTOption[] optionsArray = new NBTOption[options.size()];
        options.toArray(optionsArray);
        return optionsArray;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NBTListElement)) {
            return false;
        }
        NBTListElement other = (NBTListElement)((Object)obj);
        return this.icon.func_77969_a(other.icon) && this.getKey().equals(other.getKey()) && this.getTag().equals((Object)other.getTag()) && this.parent.equals((Object)other.parent);
    }
}

