/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.nbt.itemstack.tag.blockentitytag;

import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.ClickEvent;
import ruukas.infinity.nbt.itemstack.tag.InfinityBlockEntityTag;

public class InfinitySignTag {
    private final InfinityBlockEntityTag tileTag;

    public InfinitySignTag(InfinityBlockEntityTag tileTag) {
        this.tileTag = tileTag;
    }

    public InfinitySignTag(ItemStack stack) {
        this(new InfinityBlockEntityTag(stack));
    }

    public InfinitySignTag setLine(int line, String text) {
        if (text == null || text.length() < 1) {
            this.tileTag.getTag().func_82580_o("Text" + (line + 1));
            this.tileTag.checkEmpty();
        } else {
            this.tileTag.getTag().func_74778_a("Text" + (line + 1), text);
        }
        return this;
    }

    public InfinitySignTag setLine(int line, ITextComponent text) {
        if (text.func_150254_d().length() < 1 && text.func_150256_b().func_150235_h() == null) {
            return this.setLine(line, (String)null);
        }
        return this.setLine(line, ITextComponent.Serializer.func_150696_a((ITextComponent)text));
    }

    public InfinitySignTag setLineUnformatted(int line, String text) {
        if (text.length() < 1 && !this.hasCommand()) {
            return this.setLine(line, (String)null);
        }
        TextComponentString comp = new TextComponentString(text);
        Style style = null;
        if (this.hasLine(line)) {
            style = this.getLineComponent(line).func_150256_b();
        }
        return this.setLine(line, comp.func_150255_a(style));
    }

    public String getLine(int line) {
        return this.tileTag.getTag().func_74779_i("Text" + (line + 1));
    }

    public String getLineFormatted(int line) {
        return this.getLineComponent(line).func_150254_d();
    }

    public ITextComponent getLineComponent(int line) {
        return ITextComponent.Serializer.func_186877_b((String)this.getLine(line));
    }

    public boolean hasLine(int line) {
        return this.tileTag.exists() && this.tileTag.getTag().func_150297_b("Text" + (line + 1), 8);
    }

    public boolean hasCommand() {
        return this.hasLine(0) && this.getLineComponent(0) != null && this.getLineComponent(0).func_150256_b().func_150235_h() != null && this.getLineComponent(0).func_150256_b().func_150235_h().func_150669_a() == ClickEvent.Action.RUN_COMMAND;
    }

    public InfinitySignTag setCommand(String command) {
        boolean noLine;
        boolean remove = command == null || command.length() < 1;
        boolean bl = noLine = !this.hasLine(0);
        if (noLine && remove) {
            return this;
        }
        TextComponentString comp = noLine ? new TextComponentString("") : this.getLineComponent(0);
        this.setLine(0, comp.func_150255_a(remove ? null : comp.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command))));
        return this;
    }

    public String getCommand() {
        ClickEvent clickevent;
        if (!this.hasLine(0)) {
            return null;
        }
        Style style = this.getLineComponent(0).func_150256_b();
        if (style != null && style.func_150235_h() != null && (clickevent = style.func_150235_h()).func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
            return clickevent.func_150668_b();
        }
        return null;
    }
}

