/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelHumanoidHead;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntityHeadRenderer
extends TileEntitySpecialRenderer<TileEntitySkull> {
    public static TileEntityHeadRenderer instance;
    private final ModelSkeletonHead skeletonHead = new ModelSkeletonHead(0, 0, 64, 32);
    private final ModelSkeletonHead humanoidHead = new ModelHumanoidHead();
    private final Map<GameProfile, ResourceLocation> rlCache = new ConcurrentHashMap<GameProfile, ResourceLocation>();
    private final AtomicInteger atoi = new AtomicInteger(0);

    public void render(TileEntitySkull te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)(te.func_145832_p() & 7));
        float f = te.func_184295_a(partialTicks);
        this.renderSkull((float)x, (float)y, (float)z, enumfacing, (float)(te.func_145906_b() * 360) / 16.0f, te.func_145904_a(), te.func_152108_a(), destroyStage, f);
    }

    public void func_147497_a(TileEntityRendererDispatcher rendererDispatcherIn) {
        super.func_147497_a(rendererDispatcherIn);
        instance = this;
    }

    public void renderSkull(float x, float y, float z, EnumFacing facing, float rotationIn, int skullType, final @Nullable GameProfile profile, int destroyStage, float animateTicks) {
        if (skullType != 3) {
            TileEntitySkullRenderer.field_147536_b.func_188190_a(x, y, z, facing, rotationIn, skullType, profile, destroyStage, animateTicks);
            return;
        }
        ModelSkeletonHead modelbase = this.skeletonHead;
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)4.0f, (float)2.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.func_179128_n((int)5888);
        } else {
            modelbase = this.humanoidHead;
            ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
            if (profile != null) {
                Minecraft mc = Minecraft.func_71410_x();
                if (this.atoi.get() <= 3) {
                    if (this.rlCache.containsKey(profile)) {
                        resourcelocation = this.rlCache.get(profile);
                    } else {
                        this.rlCache.put(profile, resourcelocation);
                        this.atoi.incrementAndGet();
                        mc.func_152342_ad().func_152790_a(profile, new SkinManager.SkinAvailableCallback(){

                            public void func_180521_a(MinecraftProfileTexture.Type typeIn, ResourceLocation location, MinecraftProfileTexture profileTexture) {
                                if (typeIn == MinecraftProfileTexture.Type.SKIN) {
                                    TileEntityHeadRenderer.this.rlCache.put(profile, location);
                                    TileEntityHeadRenderer.this.atoi.decrementAndGet();
                                }
                            }
                        }, false);
                    }
                }
            }
            this.func_147499_a(resourcelocation);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        if (facing == EnumFacing.UP) {
            GlStateManager.func_179109_b((float)(x + 0.5f), (float)y, (float)(z + 0.5f));
        } else {
            switch (facing) {
                case NORTH: {
                    GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.74f));
                    break;
                }
                case SOUTH: {
                    GlStateManager.func_179109_b((float)(x + 0.5f), (float)(y + 0.25f), (float)(z + 0.26f));
                    rotationIn = 180.0f;
                    break;
                }
                case WEST: {
                    GlStateManager.func_179109_b((float)(x + 0.74f), (float)(y + 0.25f), (float)(z + 0.5f));
                    rotationIn = 270.0f;
                    break;
                }
                default: {
                    GlStateManager.func_179109_b((float)(x + 0.26f), (float)(y + 0.25f), (float)(z + 0.5f));
                    rotationIn = 90.0f;
                }
            }
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        if (skullType == 3) {
            GlStateManager.func_187408_a((GlStateManager.Profile)GlStateManager.Profile.PLAYER_SKIN);
        }
        modelbase.func_78088_a((Entity)null, animateTicks, 0.0f, 0.0f, rotationIn, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        if (destroyStage >= 0) {
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
        }
    }
}

