/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinity.tab;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import ruukas.infinity.Infinity;
import ruukas.infinity.data.InfinityConfig;
import ruukas.infinity.data.thevoid.VoidController;
import ruukas.infinity.tab.InfinityTabBanners;
import ruukas.infinity.tab.InfinityTabFireworks;
import ruukas.infinity.tab.InfinityTabRealm;
import ruukas.infinity.tab.InfinityTabSkulls;
import ruukas.infinity.tab.InfinityTabThief;

public abstract class InfinityTab
extends CreativeTabs {
    public InfinityTab(String label) {
        super(label);
    }

    public InfinityTab(int index, String label) {
        super(index, label);
    }

    public static void initTabs() {
        Infinity.REALM = new InfinityTabRealm(InfinityTab.getNextID(), "realm");
        if (InfinityConfig.getIsUnavailableTabEnabled()) {
            Infinity.UNAVAILABLE = new InfinityTab(InfinityTab.getNextID(), "unavailable"){

                public ItemStack func_78016_d() {
                    return new ItemStack(Blocks.field_180401_cv);
                }

                public void func_78018_a(NonNullList<ItemStack> stackList) {
                    super.func_78018_a(stackList);
                    stackList.add((Object)new ItemStack(Items.field_151063_bx));
                    stackList.add((Object)new ItemStack((Item)Items.field_151068_bn));
                    stackList.add((Object)new ItemStack((Item)Items.field_185155_bH));
                    stackList.add((Object)new ItemStack((Item)Items.field_185156_bI));
                    stackList.add((Object)new ItemStack(Items.field_185167_i));
                    stackList.add((Object)new ItemStack((Item)Items.field_151134_bR));
                }
            };
        }
        if (InfinityConfig.getIsBannerTabEnabled()) {
            Infinity.BANNERS = new InfinityTabBanners(InfinityTab.getNextID());
        }
        if (InfinityConfig.getIsHeadTabEnabled()) {
            Infinity.SKULLS = new InfinityTabSkulls(InfinityTab.getNextID());
        }
        if (InfinityConfig.getIsThiefTabEnabled()) {
            Infinity.THIEF = new InfinityTabThief(InfinityTab.getNextID());
        }
        if (InfinityConfig.getIsFireworkTabEnabled()) {
            Infinity.FIREWORKS = new InfinityTabFireworks(InfinityTab.getNextID());
        }
        if (InfinityConfig.getIsVoidEnabled()) {
            Infinity.VOID = new InfinityTab(InfinityTab.getNextID(), "void"){

                public ItemStack func_78016_d() {
                    return new ItemStack((Block)Blocks.field_150399_cn, 1, 15);
                }

                public void func_78018_a(NonNullList<ItemStack> stackList) {
                    super.func_78018_a(stackList);
                    VoidController.loadVoidToList(stackList);
                }

                public boolean hasSearchBar() {
                    return true;
                }
            };
        }
    }
}

