/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.data.thevoid;

import java.io.File;
import java.util.Objects;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import ruukas.infinityeditor.InfinityEditor;
import ruukas.infinityeditor.data.InfinityConfig;
import ruukas.infinityeditor.data.thevoid.VoidElement;
import ruukas.infinityeditor.util.ItemStackUtil;

@SideOnly(value=Side.CLIENT)
public class VoidController {
    public static final String VERSION = "0.2";
    private static final Logger LOGGER = InfinityEditor.logger;
    private final File dataFile;
    private final NonNullList<VoidElement> elementList = NonNullList.func_191196_a();

    public VoidController(ItemStack stack) {
        this.dataFile = new File(InfinityEditor.dataDir.getAbsolutePath() + File.separatorChar + "void", stack.func_77973_b().getRegistryName().toString().replace(':', '.') + ".nbt");
        this.read();
    }

    private VoidController(File dataFile) {
        this.dataFile = dataFile;
        this.read();
    }

    public void read() {
        if (!this.dataFile.exists()) {
            return;
        }
        try {
            NBTTagCompound root = CompressedStreamTools.func_74797_a((File)this.dataFile);
            if (root == null || !root.func_74764_b("elements")) {
                if (root != null && root.func_74764_b("stacks")) {
                    for (NBTBase tag : root.func_150295_c("stacks", 10)) {
                        this.elementList.add((Object)VoidElement.readFromNBT((NBTTagCompound)tag));
                    }
                }
                return;
            }
            for (NBTBase tag : root.func_150295_c("elements", 10)) {
                this.elementList.add((Object)VoidElement.readFromNBT((NBTTagCompound)tag));
            }
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load void for: " + this.dataFile.getName(), (Throwable)exception);
        }
    }

    public void write() {
        try {
            NBTTagCompound root = new NBTTagCompound();
            root.func_74782_a("elements", (NBTBase)new NBTTagList());
            NBTTagList elements = root.func_150295_c("elements", 10);
            for (VoidElement voidElement : this.elementList) {
                elements.func_74742_a((NBTBase)voidElement.writeToNBT(new NBTTagCompound()));
            }
            CompressedStreamTools.func_74795_b((NBTTagCompound)root, (File)this.dataFile);
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save void for: " + this.dataFile.getName(), (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemStack(EntityPlayerSP player, ItemStack stack, String from) {
        if (stack == null || stack.func_190926_b() || !stack.func_77942_o() || stack.func_77973_b() instanceof ItemMonsterPlacer && stack.func_77978_p().func_150296_c().size() == 1) {
            return;
        }
        stack.func_190920_e(1);
        if (stack.func_77973_b().func_77645_m()) {
            stack.func_77964_b(0);
        }
        for (VoidElement e : this.elementList) {
            if (!ItemStackUtil.isSameStack(e.getStack(), stack)) continue;
            if (e.addUUID(from, true)) {
                File file = InfinityEditor.dataDir;
                synchronized (file) {
                    this.write();
                }
            }
            return;
        }
        if (InfinityConfig.voidAddNotification) {
            player.func_145747_a(new TextComponentString("Added ").func_150257_a(stack.func_151000_E()).func_150258_a(" to Infinity Void."));
        }
        VoidElement e = new VoidElement(stack);
        e.addUUID(from, false);
        this.elementList.add((Object)e);
        File file = InfinityEditor.dataDir;
        synchronized (file) {
            this.write();
        }
    }

    public NonNullList<VoidElement> getElementList() {
        return this.elementList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadVoidToList(NonNullList<ItemStack> list) {
        File dataFile = new File(InfinityEditor.dataDir.getAbsolutePath() + File.separatorChar + "void");
        for (File file : Objects.requireNonNull(dataFile.listFiles())) {
            VoidController control;
            File file2 = InfinityEditor.dataDir;
            synchronized (file2) {
                control = new VoidController(file);
            }
            NonNullList<VoidElement> eList = control.getElementList();
            if (eList.isEmpty() || InfinityConfig.voidTabHideHeads && ((VoidElement)eList.get(0)).getStack().func_77973_b() instanceof ItemSkull) continue;
            for (VoidElement voidElement : eList) {
                list.add((Object)voidElement.getStack());
            }
        }
    }
}

