/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.CreativeCrafting;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import ruukas.infinityeditor.gui.HelperGui;
import ruukas.qualityorder.util.itemstack.QualityBanner;
import ruukas.qualityorder.util.nbt.tileentity.TileEntityTagBanner;

public class GuiBannerMaker
extends InventoryEffectRenderer {
    private static final ResourceLocation background = new ResourceLocation("qualityorder", "textures/gui/bannermaker.png");
    private static final InventoryBasic bannerInventory = new InventoryBasic("tmp", true, 8);
    private static final InventoryBasic dyeInventory = new InventoryBasic("tmp2", true, 17);
    private static final InventoryBasic bannerResult = new InventoryBasic("tmp3", true, 2);
    protected final GuiScreen lastScreen;
    private Slot destroyItemSlot;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private CreativeCrafting listener;
    private GuiTextField nbtTextField;

    public GuiBannerMaker(GuiScreen lastScreen, EntityPlayer player) {
        super((Container)new ContainerBanner(player));
        this.lastScreen = lastScreen;
        player.field_71070_bA = this.field_147002_h;
        this.field_146291_p = true;
        this.field_147000_g = 136;
        this.field_146999_f = 195;
    }

    public void func_73876_c() {
        this.nbtTextField.func_146178_a();
    }

    private void updateBannerNBT() {
        if (this.nbtTextField.func_146179_b().length() == 0) {
            this.setCurrentBanner(ItemStack.field_190927_a, false);
        } else {
            try {
                this.nbtTextField.func_146193_g(6422272);
                TileEntityTagBanner teTag = new TileEntityTagBanner(JsonToNBT.func_180713_a((String)this.nbtTextField.func_146179_b()));
                this.setCurrentBanner(new QualityBanner(teTag, this.getCurrentBanner().func_77973_b() == Items.field_185159_cQ).getItemStack(), false);
            }
            catch (NBTException nbtexception) {
                this.nbtTextField.func_146193_g(0xFF0000);
                try {
                    throw nbtexception;
                }
                catch (NBTException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void updateBanners(List<ItemStack> stackList) {
        ItemStack currentBanner = this.getCurrentBanner();
        ItemStack currentDyeStack = this.getCurrentDye();
        if (currentBanner == null || currentBanner == ItemStack.field_190927_a) {
            for (EnumDyeColor dye : EnumDyeColor.values()) {
                new QualityBanner(new TileEntityTagBanner(dye)).addToList(stackList);
            }
        } else {
            EnumDyeColor currentDye = EnumDyeColor.func_176766_a((int)currentDyeStack.func_77952_i());
            boolean isShield = currentBanner.func_77973_b() == Items.field_185159_cQ;
            boolean hasCompound = currentBanner.func_77942_o() && currentBanner.func_77978_p().func_150297_b("BlockEntityTag", 10) && currentBanner.func_77978_p().func_74775_l("BlockEntityTag").func_150297_b("Base", 3);
            for (BannerPattern pat : BannerPattern.values()) {
                if (pat == BannerPattern.BASE) continue;
                QualityBanner newBanner = new QualityBanner((NBTTagCompound)(hasCompound ? currentBanner.func_77978_p().func_74737_b() : new TileEntityTagBanner(EnumDyeColor.WHITE)), !hasCompound, isShield);
                newBanner.getTileEntityTagBanner().addPattern(new TileEntityTagBanner.Pattern(currentDye, pat));
                newBanner.addToList(stackList);
            }
        }
    }

    private void updateList(boolean shouldReloadTextField) {
        ContainerBanner bannerContainer = (ContainerBanner)this.field_147002_h;
        if (this.destroyItemSlot == null) {
            this.destroyItemSlot = new Slot((IInventory)dyeInventory, 0, 173, 112);
        }
        if (!bannerContainer.field_75151_b.contains(this.destroyItemSlot)) {
            bannerContainer.field_75151_b.add(this.destroyItemSlot);
        }
        this.field_147008_s.clear();
        bannerContainer.itemList.clear();
        this.updateBanners(bannerContainer.itemList);
        if (shouldReloadTextField) {
            this.nbtTextField.func_146193_g(0xFFFFFF);
            if (this.getCurrentBanner() != null && this.getCurrentBanner() != ItemStack.field_190927_a && this.getCurrentBanner().func_77942_o() && this.getCurrentBanner().func_77978_p().func_150297_b("BlockEntityTag", 10)) {
                this.nbtTextField.func_146180_a(this.getCurrentBanner().func_190925_c("BlockEntityTag").toString());
            } else {
                this.nbtTextField.func_146180_a("");
            }
        }
        bannerContainer.scrollTo(this.currentScroll);
    }

    private void swapBanner() {
        if (this.getCurrentBanner() != null && this.getCurrentBanner() != ItemStack.field_190927_a) {
            QualityBanner swappedBanner = !this.getCurrentBanner().func_77942_o() ? new QualityBanner(new TileEntityTagBanner(EnumDyeColor.WHITE), this.getCurrentBanner().func_77973_b() == Items.field_179564_cE) : new QualityBanner(this.getCurrentBanner().func_77978_p(), false, this.getCurrentBanner().func_77973_b() == Items.field_179564_cE);
            this.setCurrentBanner(swappedBanner.getItemStack(), true);
        }
    }

    private void removeLayerBanner() {
        QualityBanner newBanner;
        if (this.getCurrentBanner() != null && this.getCurrentBanner() != ItemStack.field_190927_a && this.getCurrentBanner().func_77942_o() && (newBanner = new QualityBanner(this.getCurrentBanner().func_77978_p().func_74737_b(), false)).getTileEntityTagBanner() != null && newBanner.getTileEntityTagBanner().getPatterns() != null && !newBanner.getTileEntityTagBanner().getPatterns().func_82582_d()) {
            newBanner.getTileEntityTagBanner().getPatterns().func_74744_a(newBanner.getTileEntityTagBanner().getPatterns().func_74745_c() - 1);
            this.setCurrentBanner(newBanner.getItemStack(), true);
        }
    }

    private void setCurrentyDye(ItemStack dye) {
        bannerResult.func_70299_a(0, dye);
        this.updateList(false);
    }

    private ItemStack getCurrentDye() {
        return bannerResult.func_70301_a(0);
    }

    private void setCurrentBanner(ItemStack banner, boolean shouldUpdateTextField) {
        bannerResult.func_70299_a(1, banner);
        this.updateList(shouldUpdateTextField);
    }

    public ItemStack getCurrentBanner() {
        return bannerResult.func_70301_a(1);
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        this.nbtTextField.func_146201_a(typedChar, keyCode);
        this.updateBannerNBT();
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a(this.lastScreen);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nbtTextField.func_146192_a(mouseX, mouseY, mouseButton);
        if (mouseY < this.field_147009_r + 14 && mouseY > this.field_147009_r) {
            if (mouseX > this.field_147003_i + 168) {
                if (mouseX < this.field_147003_i + 178) {
                    this.removeLayerBanner();
                } else if (mouseX > this.field_147003_i + 180 && mouseX < this.field_147003_i + 190) {
                    Minecraft.func_71410_x().func_147108_a(null);
                }
            }
        } else if (mouseY < this.field_147009_r + 40 && mouseY > this.field_147009_r + 27 && mouseX > this.field_147003_i + 157 && mouseX < this.field_147003_i + 187) {
            this.swapBanner();
        }
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, ClickType type) {
        boolean isShift = type == ClickType.QUICK_MOVE;
        ClickType clickType = type = slotId == -999 && type == ClickType.PICKUP ? ClickType.THROW : type;
        if (slotIn == null && type != ClickType.QUICK_CRAFT) {
            InventoryPlayer inventoryplayer1 = this.field_146297_k.field_71439_g.field_71071_by;
            if (inventoryplayer1.func_70445_o() != null && inventoryplayer1.func_70445_o() != ItemStack.field_190927_a) {
                if (mouseButton == 0) {
                    this.field_146297_k.field_71439_g.func_71019_a(inventoryplayer1.func_70445_o(), true);
                    this.field_146297_k.field_71442_b.func_78752_a(inventoryplayer1.func_70445_o());
                    inventoryplayer1.func_70437_b(ItemStack.field_190927_a);
                }
                if (mouseButton == 1) {
                    ItemStack itemstack5 = inventoryplayer1.func_70445_o().func_77979_a(1);
                    this.field_146297_k.field_71439_g.func_71019_a(itemstack5, true);
                    this.field_146297_k.field_71442_b.func_78752_a(itemstack5);
                    if (inventoryplayer1.func_70445_o().func_190916_E() == 0) {
                        inventoryplayer1.func_70437_b(ItemStack.field_190927_a);
                    }
                }
            }
        } else if (slotIn != null && slotIn == this.destroyItemSlot && isShift) {
            for (int j = 0; j < 9; ++j) {
                this.field_146297_k.field_71442_b.func_78761_a(ItemStack.field_190927_a, j);
                this.field_146297_k.field_71439_g.field_71071_by.func_70299_a(j, ItemStack.field_190927_a);
            }
        } else if (slotIn != null && slotIn == this.destroyItemSlot) {
            this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        } else if (type != ClickType.QUICK_CRAFT && (slotIn.field_75224_c == dyeInventory || slotIn.field_75224_c == bannerInventory || slotIn.field_75224_c == bannerResult)) {
            InventoryPlayer inventoryplayer = this.field_146297_k.field_71439_g.field_71071_by;
            ItemStack handStack = inventoryplayer.func_70445_o();
            ItemStack slotStack = slotIn.func_75211_c();
            if (slotIn.field_75224_c == dyeInventory) {
                if (handStack != ItemStack.field_190927_a) {
                    this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                } else if (slotStack != ItemStack.field_190927_a) {
                    this.setCurrentyDye(slotStack);
                }
            } else if (slotIn.field_75224_c == bannerInventory) {
                if (handStack != ItemStack.field_190927_a) {
                    this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                } else if (slotStack != ItemStack.field_190927_a) {
                    this.setCurrentBanner(slotStack, true);
                }
            } else if (slotIn.field_75224_c == bannerResult && slotIn.getSlotIndex() == 1) {
                if (type == ClickType.SWAP) {
                    if (slotStack != ItemStack.field_190927_a && mouseButton >= 0 && mouseButton < 9) {
                        this.field_146297_k.field_71442_b.func_78761_a(slotStack, mouseButton);
                        this.field_146297_k.field_71439_g.field_71071_by.func_70299_a(mouseButton, slotStack);
                        this.setCurrentBanner(ItemStack.field_190927_a, true);
                        this.field_146297_k.field_71439_g.field_71069_bz.func_75142_b();
                    }
                    return;
                }
                if (type == ClickType.CLONE) {
                    if (inventoryplayer.func_70445_o() == ItemStack.field_190927_a && slotIn.func_75216_d()) {
                        ItemStack itemstack6 = slotIn.func_75211_c().func_77946_l();
                        itemstack6.func_190920_e(itemstack6.func_77976_d());
                        inventoryplayer.func_70437_b(itemstack6);
                    }
                    return;
                }
                if (type == ClickType.THROW) {
                    if (slotStack != ItemStack.field_190927_a) {
                        this.field_146297_k.field_71439_g.func_71019_a(slotStack, true);
                        this.field_146297_k.field_71442_b.func_78752_a(slotStack);
                    }
                    return;
                }
                if (slotStack != ItemStack.field_190927_a && handStack == ItemStack.field_190927_a) {
                    inventoryplayer.func_70437_b(slotStack);
                    handStack = inventoryplayer.func_70445_o();
                    if (isShift) {
                        handStack.func_190920_e(handStack.func_77976_d());
                    }
                    this.setCurrentBanner(ItemStack.field_190927_a, true);
                } else if (handStack != ItemStack.field_190927_a && (handStack.func_77973_b() == Items.field_179564_cE || handStack.func_77973_b() == Items.field_185159_cQ)) {
                    ItemStack old2 = slotStack != null && slotStack != ItemStack.field_190927_a ? slotStack.func_77946_l() : ItemStack.field_190927_a;
                    this.setCurrentBanner(handStack, true);
                    inventoryplayer.func_70437_b(old2);
                }
            }
        } else if (type == ClickType.THROW && slotIn.func_75216_d()) {
            ItemStack itemstack = slotIn.func_75209_a(mouseButton == 0 ? 1 : slotIn.func_75211_c().func_77976_d());
            this.field_146297_k.field_71439_g.func_71019_a(itemstack, true);
            this.field_146297_k.field_71442_b.func_78752_a(itemstack);
        } else if (type == ClickType.THROW && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o() != ItemStack.field_190927_a) {
            this.field_146297_k.field_71439_g.func_71019_a(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o(), true);
            this.field_146297_k.field_71442_b.func_78752_a(this.field_146297_k.field_71439_g.field_71071_by.func_70445_o());
            this.field_146297_k.field_71439_g.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        } else {
            if (isShift) {
                type = ClickType.PICKUP;
            }
            this.field_146297_k.field_71439_g.field_71069_bz.func_184996_a(slotIn.field_75222_d + 10, mouseButton, type, (EntityPlayer)this.field_146297_k.field_71439_g);
            this.field_146297_k.field_71439_g.field_71069_bz.func_75142_b();
        }
    }

    public void func_73866_w_() {
        if (this.field_146297_k.field_71442_b.func_78758_h()) {
            super.func_73866_w_();
            this.field_146292_n.clear();
            this.nbtTextField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 10, this.field_147009_r + 61, 136, 20);
            this.nbtTextField.func_146203_f(500);
            this.nbtTextField.func_146195_b(false);
            this.nbtTextField.func_146193_g(0xFFFFFF);
            this.nbtTextField.func_146185_a(false);
            Keyboard.enableRepeatEvents((boolean)true);
            this.updateList(true);
            this.listener = new CreativeCrafting(this.field_146297_k);
            this.field_146297_k.field_71439_g.field_71069_bz.func_75132_a((IContainerListener)this.listener);
            NonNullList dyes = NonNullList.func_191196_a();
            Items.field_151100_aR.func_150895_a(Objects.requireNonNull(Items.field_151100_aR.func_77640_w()), dyes);
            int i = 1;
            for (ItemStack dye : dyes) {
                dyeInventory.func_70299_a(i++, dye);
            }
        } else {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)this.field_146297_k.field_71439_g));
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.field_146297_k.field_71439_g != null && this.field_146297_k.field_71439_g.field_71071_by != null) {
            this.field_146297_k.field_71439_g.field_71069_bz.func_82847_b((IContainerListener)this.listener);
        }
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GlStateManager.func_179084_k();
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.bannermaker", (Object[])new Object[0]), 8, 6, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74520_c();
        this.field_146297_k.func_110434_K().func_110577_a(background);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.field_147003_i + 9;
        int j = this.field_147009_r + 28;
        int k = i + 142;
        this.func_175174_a((float)i + (float)(k - i - 15) * this.currentScroll, j, 241, 0, 15, 10);
        if (this.getCurrentBanner() == null || this.getCurrentBanner() == ItemStack.field_190927_a) {
            return;
        }
        if (this.getCurrentBanner().func_77973_b() == Items.field_179564_cE) {
            TileEntityBanner bannerTe = new TileEntityBanner();
            bannerTe.func_175112_a(this.getCurrentBanner(), false);
            HelperGui.renderBanner(this.field_147003_i + 164, this.field_147009_r + 103, 20, this.field_147003_i + 175 - mouseX, this.field_147009_r + 103 - 30 - mouseY, bannerTe);
        } else {
            EntityArmorStand armorStand = new EntityArmorStand((World)Minecraft.func_71410_x().field_71441_e);
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                armorStand.func_184201_a(slot, Minecraft.func_71410_x().field_71439_g.func_184582_a(slot));
            }
            armorStand.func_184611_a(EnumHand.OFF_HAND, this.getCurrentBanner());
            armorStand.func_82142_c(false);
            HelperGui.drawEntityOnScreen(this.field_147003_i + 169, this.field_147009_r + 103, 18, (float)(this.field_147003_i + 145 - mouseX), (float)(this.field_147009_r + 103 - 30 - mouseY), (EntityLivingBase)armorStand);
        }
        this.nbtTextField.func_146194_f();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0) {
            int j = ((ContainerBanner)this.field_147002_h).itemList.size() / 8;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.currentScroll = (float)((double)this.currentScroll - (double)i / (double)j);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((ContainerBanner)this.field_147002_h).scrollTo(this.currentScroll);
        }
    }

    protected boolean func_146978_c(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        return (pointX -= i) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= j) >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    private void drawMouseOverButton(int mouseX, int mouseY, int buttonX, int buttonY, int buttonSizeX, int buttonSizeY, String tooltip) {
        if (this.func_146978_c(buttonX, buttonY, buttonSizeX, buttonSizeY, mouseX, mouseY)) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            this.func_73733_a(buttonX, buttonY, buttonX + buttonSizeX, buttonY + buttonSizeY, -2130706433, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            ArrayList<String> list = new ArrayList<String>();
            list.add(tooltip);
            this.func_146283_a(list, mouseX, mouseY);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        boolean flag = Mouse.isButtonDown((int)0);
        int lowScrollXBounding = this.field_147003_i + 9;
        int lowScrollYBounding = this.field_147009_r + 28;
        int highScrollXBounding = lowScrollXBounding + 142;
        int highScrollYBounding = lowScrollYBounding + 10;
        if (!this.wasClicking && flag && mouseX >= lowScrollXBounding && mouseY >= lowScrollYBounding && mouseX < highScrollXBounding && mouseY < highScrollYBounding) {
            this.isScrolling = true;
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseX - lowScrollXBounding) - 7.5f) / ((float)(highScrollXBounding - lowScrollXBounding) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((ContainerBanner)this.field_147002_h).scrollTo(this.currentScroll);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawMouseOverButton(mouseX, mouseY, 168, 4, 10, 10, "Remove a layer");
        this.drawMouseOverButton(mouseX, mouseY, 180, 4, 10, 10, "Close");
        this.drawMouseOverButton(mouseX, mouseY, 157, 27, 30, 13, "Swap to Shield/Banner");
        if (this.destroyItemSlot != null && this.func_146978_c(this.destroyItemSlot.field_75223_e, this.destroyItemSlot.field_75221_f, 16, 16, mouseX, mouseY)) {
            this.func_146279_a(I18n.func_135052_a((String)"inventory.binSlot", (Object[])new Object[0]), mouseX, mouseY);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
    }

    @SideOnly(value=Side.CLIENT)
    static class ContainerBanner
    extends Container {
        public List<ItemStack> itemList = Lists.newArrayList();

        public ContainerBanner(EntityPlayer player) {
            int i;
            InventoryPlayer inventoryplayer = player.field_71071_by;
            this.func_75146_a(new Slot((IInventory)bannerResult, 0, 154, 42));
            this.func_75146_a(new Slot((IInventory)bannerResult, 1, 172, 42));
            for (i = 0; i < 8; ++i) {
                this.func_75146_a(new Slot((IInventory)bannerInventory, i, 9 + i * 18, 42));
            }
            for (i = 0; i < 2; ++i) {
                for (int j = 0; j < 8; ++j) {
                    this.func_75146_a(new Slot((IInventory)dyeInventory, i * 8 + j + 1, 9 + j * 18, 73 + i * 18));
                }
            }
            for (i = 0; i < 9; ++i) {
                this.func_75146_a(new Slot((IInventory)inventoryplayer, i, 9 + i * 18, 112));
            }
            this.scrollTo(0.0f);
        }

        public void scrollTo(float scollTo) {
            int i = this.itemList.size() - 8;
            int j = (int)(scollTo * (float)i);
            if (j < 0) {
                j = 0;
            }
            for (int l = 0; l < 8; ++l) {
                int i1 = l + j;
                if (i1 >= 0 && i1 < this.itemList.size()) {
                    bannerInventory.func_70299_a(l, this.itemList.get(i1));
                    continue;
                }
                bannerInventory.func_70299_a(l, ItemStack.field_190927_a);
            }
        }

        public boolean func_75145_c(EntityPlayer playerIn) {
            return true;
        }

        public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
            Slot slot;
            if (index >= this.field_75151_b.size() - 9 && index < this.field_75151_b.size() && (slot = (Slot)this.field_75151_b.get(index)) != null && slot.func_75216_d()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            return ItemStack.field_190927_a;
        }

        public boolean func_94530_a(ItemStack stack, Slot slotIn) {
            return slotIn.field_75221_f > 90;
        }

        public boolean func_94531_b(Slot slotIn) {
            return slotIn.field_75224_c instanceof InventoryPlayer || slotIn.field_75221_f > 90 && slotIn.field_75223_e <= 162;
        }
    }
}

