/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import ruukas.infinityeditor.data.InfinityConfig;
import ruukas.infinityeditor.gui.HelperGui;
import ruukas.infinityeditor.gui.action.GuiInfinityButton;
import ruukas.infinityeditor.nbt.NBTHelper;

@SideOnly(value=Side.CLIENT)
public class GuiHead
extends GuiScreen {
    private final ItemStack stack;
    private final GuiScreen lastScreen;
    private GuiInfinityButton headButton;
    private GuiInfinityButton saveSkullButton;
    private GuiInfinityButton listButton;
    private GuiInfinityButton backButton;
    private GuiInfinityButton resetButton;
    private GuiInfinityButton dropButton;
    private GuiTextField skullOwnerTextField;
    protected String title = I18n.func_135052_a((String)"gui.head", (Object[])new Object[0]);
    protected ArrayList<String> prettyNBTList = new ArrayList();

    public GuiHead(GuiScreen lastScreen, ItemStack stack) {
        this.lastScreen = lastScreen;
        this.stack = stack;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.headButton = new GuiInfinityButton(100, this.field_146294_l / 2 - 55, 50, 110, 20, I18n.func_135052_a((String)("tag.head." + this.stack.func_77952_i()), (Object[])new Object[0]));
        this.headButton.field_146124_l = false;
        this.func_189646_b(this.headButton);
        this.func_189646_b(new GuiInfinityButton(101, this.field_146294_l / 2 - 75, 50, 20, 20, "<"));
        this.func_189646_b(new GuiInfinityButton(102, this.field_146294_l / 2 + 55, 50, 20, 20, ">"));
        this.skullOwnerTextField = new GuiTextField(103, this.field_146289_q, this.field_146294_l / 2 - 54, 82, 88, 16);
        GameProfile profile = NBTHelper.SkullNBTHelper.getSkullOwner(this.stack);
        this.skullOwnerTextField.func_146180_a(profile != null && profile.getName() != null ? profile.getName() : I18n.func_135052_a((String)"tag.skullowner", (Object[])new Object[0]));
        this.listButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(104, this.field_146294_l / 2 - 75, 80, 20, 20, "[L]"));
        this.listButton.field_146124_l = false;
        this.saveSkullButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(105, this.field_146294_l / 2 + 35, 80, 40, 20, I18n.func_135052_a((String)"gui.save", (Object[])new Object[0])));
        this.backButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(200, this.field_146294_l / 2 - 90, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0])));
        this.resetButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(201, this.field_146294_l / 2 - 30, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.reset", (Object[])new Object[0])));
        this.dropButton = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(202, this.field_146294_l / 2 + 30, this.field_146295_m - 25, 60, 20, I18n.func_135052_a((String)"gui.drop", (Object[])new Object[0])));
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        this.skullOwnerTextField.func_146178_a();
    }

    public void changeHeadType(boolean right) {
        if (right) {
            this.stack.func_77964_b((this.stack.func_77952_i() + 1) % 6);
        } else if (this.stack.func_77952_i() == 0) {
            this.stack.func_77964_b(5);
        } else {
            this.stack.func_77964_b(this.stack.func_77952_i() - 1);
        }
        this.headButton.field_146126_j = I18n.func_135052_a((String)("tag.head." + this.stack.func_77952_i()), (Object[])new Object[0]);
        boolean playerhead = this.stack.func_77952_i() == 3;
        this.skullOwnerTextField.func_146184_c(playerhead);
        this.skullOwnerTextField.func_146189_e(playerhead);
        this.saveSkullButton.field_146124_l = playerhead;
        this.saveSkullButton.field_146125_m = playerhead;
        this.listButton.field_146124_l = false;
        this.listButton.field_146125_m = playerhead;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.func_146284_a(this.backButton);
        } else if (keyCode == 28 || keyCode == 156) {
            this.func_146284_a(this.saveSkullButton);
        } else {
            this.skullOwnerTextField.func_146201_a(typedChar, keyCode);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.skullOwnerTextField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 101) {
            this.changeHeadType(false);
        } else if (button.field_146127_k == 102) {
            this.changeHeadType(true);
        } else if (button.field_146127_k == this.saveSkullButton.field_146127_k) {
            NBTHelper.SkullNBTHelper.setSkullOwner(this.stack, this.skullOwnerTextField.func_146179_b());
        } else if (button.field_146127_k == this.backButton.field_146127_k) {
            this.field_146297_k.func_147108_a(this.lastScreen);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (button.field_146127_k == this.resetButton.field_146127_k) {
            if (this.stack.func_77942_o()) {
                this.stack.func_77982_d(new NBTTagCompound());
            }
        } else if (button.field_146127_k == this.dropButton.field_146127_k) {
            HelperGui.dropStack(this.stack);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179094_E();
        GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
        this.func_146285_a(this.stack, 0, 25);
        String s = this.stack.func_77942_o() ? this.stack.func_77978_p().toString() : "{}";
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(s);
        s = gson.toJson(je);
        this.prettyNBTList.clear();
        for (String str : s.split("\\n")) {
            if (str.trim().startsWith("\"Signature\": ")) {
                this.prettyNBTList.add("          \"Signature:\": (snip)");
                continue;
            }
            if (str.startsWith("          \"Value\": ")) {
                this.prettyNBTList.add("          \"Value:\": (snip)");
                continue;
            }
            this.prettyNBTList.add(str);
        }
        this.func_146283_a(this.prettyNBTList, 0, this.field_146295_m);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        RenderHelper.func_74520_c();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        GlStateManager.func_179145_e();
        this.field_146296_j.func_180450_b(this.stack, this.field_146294_l / 2 - 8, 30);
        GlStateManager.func_179121_F();
        this.func_73732_a(this.field_146289_q, this.title, this.field_146294_l / 2, 15, InfinityConfig.MAIN_COLOR);
        this.skullOwnerTextField.func_146194_f();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        HelperGui.addTooltipTranslated(this.saveSkullButton, mouseX, mouseY, I18n.func_135052_a((String)"gui.head.save.tooltip", (Object[])new Object[0]));
        HelperGui.addTooltipTranslated(this.listButton, mouseX, mouseY, I18n.func_135052_a((String)"gui.head.list.tooltip", (Object[])new Object[0]));
    }

    public boolean func_73868_f() {
        return false;
    }

    public ItemStack getItemStack() {
        return this.stack;
    }
}

