/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import ruukas.infinityeditor.gui.GuiHideFlags;
import ruukas.infinityeditor.gui.GuiInfinity;
import ruukas.infinityeditor.gui.GuiLorePaint;
import ruukas.infinityeditor.gui.HelperGui;
import ruukas.infinityeditor.gui.action.GuiActionLoreField;
import ruukas.infinityeditor.gui.action.GuiActionTextField;
import ruukas.infinityeditor.gui.action.GuiInfinityButton;
import ruukas.infinityeditor.nbt.NBTHelper;

public class GuiLore
extends GuiInfinity {
    private int offset = 0;
    private boolean draggingScroll = false;
    private ArrayList<GuiLoreLine> lines = new ArrayList();
    private GuiInfinityButton[] colorButtons;
    private GuiInfinityButton addLine;
    private GuiInfinityButton copyLore;
    private GuiInfinityButton copyAll;
    private GuiInfinityButton paste;
    private GuiInfinityButton flags;
    private GuiInfinityButton painter;

    public GuiLore(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stackHolder) {
        super(lastScreen, stackHolder);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.setRenderStack(true, this.midX, 35, 1.0f);
        TextFormatting[] formats = TextFormatting.values();
        int colorAmount = 2 + formats.length;
        this.colorButtons = new GuiInfinityButton[colorAmount];
        this.colorButtons[0] = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(130, this.field_146294_l - 1 - 13 * ((colorAmount + 2) / 2) + 13, this.field_146295_m - 30, 13, 15, formats[0].toString().substring(0, 1)));
        this.colorButtons[1] = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(131, this.field_146294_l - 1 - 13 * ((colorAmount + 2) / 2) + 26, this.field_146295_m - 30, 13, 15, TextFormatting.DARK_RED + "%"));
        for (int i = 2; i < colorAmount; ++i) {
            TextFormatting f = formats[i - 2];
            this.colorButtons[i] = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(130 + i, this.field_146294_l - 1 - 13 * ((colorAmount + 2) / 2) + 13 * (i % (colorAmount / 2) + 1), this.field_146295_m - 30 + 15 * (i / (colorAmount / 2)), 13, 15, f.toString() + f.toString().substring(1)));
        }
        NBTTagList lore = this.getLore();
        this.lines.clear();
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            this.lines.add(new GuiLoreLine(i, this.field_146289_q, this));
        }
        int b = 90;
        int x = 100;
        int padding = 2;
        int margins = 6;
        String text = I18n.func_135052_a((String)"gui.lore.addline", (Object[])new Object[0]);
        int bWidth = this.field_146289_q.func_78256_a(text) + margins;
        this.addLine = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(b++, x, 10, bWidth, 20, text));
        x += bWidth + padding;
        text = I18n.func_135052_a((String)"gui.lore.copylore", (Object[])new Object[0]);
        bWidth = this.field_146289_q.func_78256_a(text) + margins;
        this.copyLore = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(b++, x, 10, bWidth, 20, text));
        x += bWidth + padding;
        text = I18n.func_135052_a((String)"gui.lore.copyall", (Object[])new Object[0]);
        bWidth = this.field_146289_q.func_78256_a(text) + margins;
        this.copyAll = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(b++, x, 10, bWidth, 20, text));
        x += bWidth + padding;
        text = I18n.func_135052_a((String)"gui.lore.paste", (Object[])new Object[0]);
        bWidth = this.field_146289_q.func_78256_a(text) + margins;
        this.paste = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(b++, x, 10, bWidth, 20, text));
        x += bWidth + padding;
        text = I18n.func_135052_a((String)"gui.hideflags", (Object[])new Object[0]);
        bWidth = this.field_146289_q.func_78256_a(text) + margins;
        this.flags = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(b++, x, 10, bWidth, 20, text));
        x += bWidth + padding;
        text = I18n.func_135052_a((String)"gui.lorepainter", (Object[])new Object[0]);
        bWidth = this.field_146289_q.func_78256_a(text) + margins;
        this.painter = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(b, x, 10, bWidth, 20, text));
    }

    public NBTTagList getLore() {
        return NBTHelper.getLoreTagList(this.getItemStack());
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiLoreLine line : this.lines) {
            line.field.func_146178_a();
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        int change = Integer.compare(0, delta);
        if (change != 0) {
            this.offset = MathHelper.func_76125_a((int)(this.offset + change), (int)0, (int)Math.max(0, this.lines.size() - this.lineSpaces()));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (GuiLoreLine guiLoreLine : this.lines) {
            guiLoreLine.field.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (mouseButton == 0) {
            block1: for (int i = this.offset; i < this.offset + this.lineSpaces() && i < this.lines.size(); ++i) {
                GuiButton[] guiButtons;
                GuiLoreLine line = this.lines.get(i);
                for (GuiButton guiButton : guiButtons = new GuiButton[]{line.remove, line.up, line.down}) {
                    GuiButton guibutton = guiButton;
                    if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                    GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.field_146292_n);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) continue block1;
                    this.field_146290_a = guibutton = event.getButton();
                    guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                    boolean res = line.actionPerformed(guibutton);
                    if (((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) {
                        MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.field_146292_n));
                    }
                    if (!res) continue;
                    return;
                }
            }
        }
        if (HelperGui.isMouseInRegion(mouseX, mouseY, this.field_146294_l - 15, 50, 11, this.field_146295_m - 99)) {
            this.draggingScroll = true;
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.draggingScroll = false;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        for (int i = this.offset = MathHelper.func_76125_a((int)this.offset, (int)0, (int)Math.max(0, this.lines.size() - this.lineSpaces())); i < this.offset + this.lineSpaces() && i < this.lines.size(); ++i) {
            GuiLoreLine line = this.lines.get(i);
            line.field.func_146201_a(typedChar, keyCode);
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.func_73866_w_();
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 90) {
            NBTTagList lore = this.getLore();
            int i = lore.func_74745_c();
            lore.func_74742_a((NBTBase)new NBTTagString(""));
            this.lines.add(new GuiLoreLine(i, this.field_146289_q, this));
            int size = this.lines.size();
            int space = this.lineSpaces();
            this.offset = MathHelper.func_76125_a((int)(size - space), (int)0, (int)Math.max(0, size - space));
            return;
        }
        if (button.field_146127_k == 91) {
            CharSequence[] lore = new String[this.lines.size()];
            for (int i = 0; i < this.lines.size(); ++i) {
                lore[i] = this.lines.get(i).field.func_146179_b();
            }
            GuiLore.func_146275_d((String)String.join((CharSequence)"\n", lore));
            return;
        }
        if (button.field_146127_k == 92) {
            GuiLore.func_146275_d((String)String.join((CharSequence)"\n", this.getItemStack().func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL)));
            return;
        }
        if (button.field_146127_k == 93) {
            String clipboard = GuiLore.func_146277_j();
            String[] lines = clipboard.split("\\r?\\n");
            NBTTagList list = this.getLore();
            for (String l : lines) {
                String s = l.startsWith(Character.toString('\u00a7')) || l.length() <= 1 ? l : TextFormatting.RESET.toString() + TextFormatting.GRAY + l;
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            this.func_73866_w_();
            return;
        }
        if (button.field_146127_k == 94) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiHideFlags(this, this.stackHolder));
            return;
        }
        if (button.field_146127_k == 95) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLorePaint(this, this.stackHolder));
            return;
        }
        if (button.field_146127_k >= 130 && button.field_146127_k < 130 + this.colorButtons.length) {
            for (int i = this.offset; i < this.offset + this.lineSpaces() && i < this.lines.size(); ++i) {
                GuiLoreLine line = this.lines.get(i);
                GuiActionTextField f = line.field;
                if (!f.func_146206_l()) continue;
                if (button.field_146127_k == 130) {
                    f.func_146180_a(f.func_146179_b().substring(0, f.func_146198_h()) + TextFormatting.values()[0].toString().charAt(0) + f.func_146179_b().substring(f.func_146198_h()));
                } else if (button.field_146127_k == 131) {
                    f.func_146180_a(Objects.requireNonNull(TextFormatting.func_110646_a((String)f.func_146179_b())));
                } else {
                    f.func_146180_a(f.func_146179_b().substring(0, f.func_146198_h()) + TextFormatting.values()[button.field_146127_k - 132] + f.func_146179_b().substring(f.func_146198_h()));
                }
                return;
            }
        } else {
            for (GuiLoreLine line : this.lines) {
                if (!line.actionPerformed(button)) continue;
                return;
            }
        }
    }

    public int lineSpaces() {
        return (this.field_146295_m - 70) / 30 - 1;
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        float div;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int space = this.lineSpaces();
        int size = this.lines.size();
        this.offset = MathHelper.func_76125_a((int)this.offset, (int)0, (int)Math.max(0, size - space));
        int y = 25;
        String tooltip = null;
        for (int i = this.offset; i < this.offset + space && i < size; ++i) {
            GuiLoreLine line = this.lines.get(i);
            y = 55 + 30 * (line.id - this.offset);
            line.render(mouseX, mouseY, partialTicks, y);
            if (!HelperGui.isMouseInRegion(mouseX, mouseY, ((GuiLoreLine)line).field.field_146209_f, ((GuiLoreLine)line).field.field_146210_g, ((GuiLoreLine)line).field.field_146218_h, ((GuiLoreLine)line).field.field_146219_i)) continue;
            tooltip = line.field.func_146179_b().replace('\u00a7', '&');
        }
        this.func_73730_a(this.field_146294_l - 15, this.field_146294_l - 5, 50, -5592406);
        this.func_73730_a(this.field_146294_l - 15, this.field_146294_l - 5, this.field_146295_m - 50, -5592406);
        int scrollHeight = this.field_146295_m - 103;
        float covered = size < space ? 1.0f : (float)space / (float)size;
        int coveredHeight = (int)Math.max(1.0f, (float)scrollHeight * covered);
        if (this.draggingScroll) {
            float perc = (float)(mouseY - 50) / (float)(this.field_146295_m - 99);
            int max = size - space;
            this.offset = MathHelper.func_76125_a((int)Math.round((float)max * perc), (int)0, (int)max);
        }
        float perc = (div = (float)(size - space)) <= 0.0f ? 0.0f : (float)this.offset / div;
        int scrollY = (int)(52.0f + (float)(scrollHeight - coveredHeight) * perc);
        GuiLore.func_73734_a((int)(this.field_146294_l - 14), (int)scrollY, (int)(this.field_146294_l - 5), (int)(scrollY + coveredHeight), (int)-10066330);
        this.addLine.field_146129_i = y + 30;
        this.copyLore.field_146129_i = y + 30;
        this.copyLore.field_146124_l = size > 0;
        this.copyAll.field_146129_i = y + 30;
        this.paste.field_146129_i = y + 30;
        this.flags.field_146129_i = y + 30;
        this.painter.field_146129_i = y + 30;
        if (tooltip != null && tooltip.length() > 0) {
            this.func_146279_a(tooltip, mouseX, mouseY);
        } else {
            List list = this.getItemStack().func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
            String[] array = new String[list.size()];
            list.toArray(array);
            HelperGui.addToolTip(this.midX - 9, 27, 18, 18, mouseX, mouseY, array);
        }
    }

    @Override
    protected String getNameUnlocalized() {
        return "lore";
    }

    private static class GuiLoreLine {
        private GuiLore gui;
        private int id;
        private GuiActionTextField field;
        private GuiInfinityButton remove;
        private GuiInfinityButton up;
        private GuiInfinityButton down;

        private GuiLoreLine(int id, FontRenderer font, GuiLore gui) {
            this.gui = gui;
            this.id = id;
            this.field = new GuiActionLoreField(1000 + id, font, 100, 0, 1000, 20);
            this.field.func_146203_f(500);
            this.refresh();
            this.field.action = () -> gui.getLore().func_150304_a(id, (NBTBase)new NBTTagString(this.field.func_146179_b()));
            this.remove = new GuiInfinityButton(500 + id, gui.field_146294_l, 0, 20, 20, "\u2715");
            this.up = new GuiInfinityButton(600 + id, 100, 0, 20, 20, "\u2b06");
            this.up.field_146124_l = id > 0;
            this.down = new GuiInfinityButton(700 + id, 100, 0, 20, 20, "\u2b07");
        }

        public void refresh() {
            this.field.func_146180_a(this.gui.getLore().func_150307_f(this.id));
        }

        public void swap(GuiLoreLine other) {
            String oS = other.field.func_146179_b();
            other.field.func_146180_a(this.field.func_146179_b());
            this.field.func_146180_a(oS);
        }

        public boolean actionPerformed(GuiButton button) {
            if (button == this.remove) {
                int size = this.gui.lines.size();
                this.gui.lines.remove(size - 1);
                this.gui.getLore().func_74744_a(this.id);
                this.gui.func_73866_w_();
                return true;
            }
            if (button == this.up) {
                if (this.id >= 1) {
                    this.swap((GuiLoreLine)this.gui.lines.get(this.id - 1));
                }
                return true;
            }
            if (button == this.down) {
                if (this.id + 1 < this.gui.lines.size()) {
                    this.swap((GuiLoreLine)this.gui.lines.get(this.id + 1));
                }
                return true;
            }
            return false;
        }

        public void render(int mouseX, int mouseY, float partialTicks, int y) {
            String l = "Line " + (this.id + 1);
            this.gui.func_73731_b(this.gui.field_146289_q, l, this.field.field_146209_f - this.gui.field_146289_q.func_78256_a(l) - 10, y + 6, -1);
            this.field.field_146210_g = y;
            this.field.field_146218_h = this.gui.field_146294_l - this.field.field_146209_f - 100;
            this.field.func_146194_f();
            this.up.field_146128_h = 3 + this.field.field_146209_f + this.field.field_146218_h;
            this.up.field_146129_i = y;
            this.up.func_191745_a(this.gui.field_146297_k, mouseX, mouseY, partialTicks);
            this.down.field_146124_l = this.id < this.gui.lines.size() - 1;
            this.down.field_146128_h = 1 + this.up.field_146128_h + this.up.field_146120_f;
            this.down.field_146129_i = y;
            this.down.func_191745_a(this.gui.field_146297_k, mouseX, mouseY, partialTicks);
            this.remove.field_146128_h = 1 + this.down.field_146128_h + this.down.field_146120_f;
            this.remove.field_146129_i = y;
            this.remove.func_191745_a(this.gui.field_146297_k, mouseX, mouseY, partialTicks);
        }
    }
}

