/*
 * Decompiled with CFR 0.152.
 */
package ruukas.infinityeditor.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.TextFormatting;
import ruukas.infinityeditor.data.InfinityConfig;
import ruukas.infinityeditor.gui.GuiInfinity;
import ruukas.infinityeditor.gui.HelperGui;
import ruukas.infinityeditor.gui.action.GuiInfinityButton;
import ruukas.infinityeditor.nbt.NBTHelper;

public class GuiLorePaint
extends GuiInfinity {
    private boolean dragging = false;
    private boolean preview = false;
    private int x = 3;
    private int y = 3;
    private List<List<LorePixel>> pixelRows;
    private GuiInfinityButton insert;
    private GuiInfinityButton scale;
    private GuiInfinityButton addRow;
    private GuiInfinityButton removeRow;
    private GuiInfinityButton addColumn;
    private GuiInfinityButton removeColumn;
    private GuiInfinityButton previewToggle;
    private final LorePixel currentPixel = new LorePixel();

    public GuiLorePaint(GuiScreen lastScreen, GuiInfinity.ItemStackHolder stackHolder) {
        super(lastScreen, stackHolder);
        this.reset();
    }

    public NBTTagList getLore() {
        return NBTHelper.getLoreTagList(this.getItemStack());
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String insertS = I18n.func_135052_a((String)"gui.lorepainter.insert", (Object[])new Object[0]);
        int insertW = this.field_146289_q.func_78256_a(insertS) + 5;
        this.insert = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(500, this.midX - insertW / 2, this.field_146295_m - 55, insertW, 20, insertS));
        String scaleS = I18n.func_135052_a((String)"gui.lorepainter.scale", (Object[])new Object[0]);
        int scaleW = this.field_146289_q.func_78256_a(scaleS) + 5;
        this.scale = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(501, this.field_146294_l - scaleW, this.field_146295_m - 20, scaleW, 20, scaleS));
        this.addRow = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(502, this.midX - 20, this.field_146295_m - 50, 20, 20, "+"));
        this.removeRow = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(503, this.midX, this.field_146295_m - 50, 20, 20, "-"));
        this.addColumn = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(504, this.field_146294_l - 50, this.midY - 20, 20, 20, "+"));
        this.removeColumn = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(505, this.field_146294_l - 50, this.midY, 20, 20, "-"));
        String previewS = I18n.func_135052_a((String)"gui.lorepainter.preview", (Object[])new Object[0]);
        this.previewToggle = (GuiInfinityButton)this.func_189646_b(new GuiInfinityButton(506, 0, this.field_146295_m - 20, this.field_146289_q.func_78256_a(previewS) + 5, 20, previewS));
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 500) {
            NBTTagList lore = this.getLore();
            for (List<LorePixel> row : this.pixelRows) {
                StringBuilder s = new StringBuilder();
                for (LorePixel pixel : row) {
                    s.append(pixel);
                }
                lore.func_74742_a((NBTBase)new NBTTagString(s.toString()));
            }
            return;
        }
        if (button.field_146127_k == 501) {
            this.field_146297_k.field_71474_y.func_74306_a(GameSettings.Options.GUI_SCALE, 1);
            ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
            int j = scaledresolution.func_78326_a();
            int k = scaledresolution.func_78328_b();
            this.func_146280_a(this.field_146297_k, j, k);
            return;
        }
        if (button.field_146127_k == 502) {
            ArrayList<LorePixel> row = new ArrayList<LorePixel>();
            for (int i = 0; i < this.x; ++i) {
                row.add(this.currentPixel.copy());
            }
            this.pixelRows.add(row);
            ++this.y;
            return;
        }
        if (button.field_146127_k == 503) {
            if (this.y <= 1) {
                return;
            }
            this.pixelRows.remove(this.y - 1);
            --this.y;
            return;
        }
        if (button.field_146127_k == 504) {
            for (List<LorePixel> row : this.pixelRows) {
                row.add(this.currentPixel.copy());
            }
            ++this.x;
            return;
        }
        if (button.field_146127_k == 505) {
            if (this.x <= 1) {
                return;
            }
            for (List<LorePixel> row : this.pixelRows) {
                row.remove(this.x - 1);
            }
            --this.x;
            return;
        }
        if (button.field_146127_k == 506) {
            this.preview = !this.preview;
        }
    }

    @Override
    protected void reset() {
        this.pixelRows = new ArrayList<List<LorePixel>>();
        for (int i = 0; i < this.y; ++i) {
            ArrayList<LorePixel> row = new ArrayList<LorePixel>();
            for (int j = 0; j < this.x; ++j) {
                row.add(this.currentPixel.copy());
            }
            this.pixelRows.add(row);
        }
    }

    public int getSizeX() {
        return 9 * this.x;
    }

    public int getSizeY() {
        return 9 * this.y;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.dragging = true;
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.dragging = false;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int xi;
        int xPos;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.field_146289_q, this.x + "x" + this.y, this.midX, this.midY - this.getSizeY() / 2 - 15, InfinityConfig.MAIN_COLOR);
        int yPos = 0;
        for (List<LorePixel> row : this.pixelRows) {
            LoreSymbol[] s = new StringBuilder();
            for (LorePixel pixel : row) {
                s.append(pixel);
            }
            this.field_146289_q.func_175065_a(s.toString(), (float)(this.midX - this.getSizeX() / 2), (float)(this.midY - this.getSizeY() / 2 + yPos), -1, false);
            yPos += 9;
        }
        this.addRow.field_146129_i = yPos = this.midY - this.getSizeY() / 2 + yPos + 9;
        this.removeRow.field_146129_i = yPos;
        this.removeRow.field_146124_l = this.y > 1;
        this.addColumn.field_146128_h = xPos = this.midX - this.getSizeX() / 2 + this.getSizeX() + 9;
        this.removeColumn.field_146128_h = xPos;
        this.removeColumn.field_146124_l = this.x > 1;
        StringBuilder symbols = new StringBuilder();
        for (LoreSymbol symbol : LoreSymbol.values()) {
            if (symbol != LoreSymbol.fullspace) {
                symbols.append(new LorePixel(this.currentPixel.color, symbol));
                continue;
            }
            symbols.append(TextFormatting.ITALIC).append(TextFormatting.BOLD).append("E");
        }
        this.func_73731_b(this.field_146289_q, symbols.toString(), 0, 0, -1);
        this.func_73731_b(this.field_146289_q, TextFormatting.func_175744_a((int)this.currentPixel.color.func_176767_b()) + this.currentPixel.symbol.getTranslatedName(), 2, 10, -1);
        StringBuilder colors = new StringBuilder();
        for (EnumDyeColor color : EnumDyeColor.values()) {
            colors.append(new LorePixel(color, this.currentPixel.symbol));
        }
        int colorX = this.field_146294_l - this.field_146289_q.func_78256_a(colors.toString());
        this.func_73731_b(this.field_146289_q, colors.toString(), colorX, 0, -1);
        String colorS = TextFormatting.func_175744_a((int)this.currentPixel.color.func_176767_b()) + TextFormatting.func_175744_a((int)this.currentPixel.color.func_176767_b()).func_96297_d();
        this.func_73731_b(this.field_146289_q, colorS, this.field_146294_l - this.field_146289_q.func_78256_a(colorS) - 2, 10, -1);
        if (this.dragging && HelperGui.isMouseInRegion(mouseX, mouseY, this.midX - this.getSizeX() / 2, this.midY - this.getSizeY() / 2, this.getSizeX() - 1, this.getSizeY() - 1)) {
            xi = (mouseX - (this.midX - this.getSizeX() / 2)) / 9;
            int yi = (mouseY - (this.midY - this.getSizeY() / 2)) / 9;
            this.pixelRows.get(yi).set(xi, this.currentPixel.copy());
        } else if (this.dragging && HelperGui.isMouseInRegion(mouseX, mouseY, 0, 0, LoreSymbol.values().length * 9, 9)) {
            xi = mouseX / 9;
            if (xi < LoreSymbol.values().length) {
                this.currentPixel.symbol = LoreSymbol.values()[xi];
            }
        } else if (this.dragging && HelperGui.isMouseInRegion(mouseX, mouseY, colorX, 0, EnumDyeColor.values().length * 9, 9) && (xi = (mouseX - colorX) / 9) < EnumDyeColor.values().length) {
            this.currentPixel.color = EnumDyeColor.values()[xi];
        }
        HelperGui.addTooltip(this.scale, mouseX, mouseY, String.valueOf(this.field_146297_k.field_71474_y.field_74335_Z));
        if (this.preview || HelperGui.isMouseInRegion(mouseX, mouseY, this.previewToggle.field_146128_h, this.previewToggle.field_146129_i, this.previewToggle.field_146120_f, this.previewToggle.field_146121_g)) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add(this.title);
            for (List<LorePixel> row : this.pixelRows) {
                StringBuilder s = new StringBuilder();
                for (LorePixel pixel : row) {
                    s.append(pixel);
                }
                lines.add(s.toString());
            }
            this.func_146283_a(lines, mouseX, mouseY);
        }
    }

    @Override
    protected String getNameUnlocalized() {
        return "lorepainter";
    }

    private static enum LoreSymbol {
        fullblock("fullblock", "\u2588"),
        mediumshade("mediumshade", "\u2592"),
        darkshade("darkshade", "\u2593"),
        fullspace("fullspace", TextFormatting.BOLD.toString() + ' ' + TextFormatting.RESET.toString() + ' ', true);

        private String symbol;
        private String name;
        private boolean whitespace;

        private LoreSymbol(String name, String symbol) {
            this(name, symbol, false);
        }

        private LoreSymbol(String name, String symbol, boolean whitespace) {
            this.symbol = symbol;
            this.name = name;
            this.whitespace = whitespace;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String getName() {
            return this.name;
        }

        public boolean isWhitespace() {
            return this.whitespace;
        }

        public String getTranslatedName() {
            return I18n.func_135052_a((String)("gui.lorepainter.symbol." + this.name), (Object[])new Object[0]);
        }

        public String toString() {
            return this.symbol;
        }
    }

    private static class LorePixel {
        private EnumDyeColor color;
        private LoreSymbol symbol;

        private LorePixel(EnumDyeColor color, LoreSymbol symbol) {
            this.color = color;
            this.symbol = symbol;
        }

        private LorePixel() {
            this(EnumDyeColor.WHITE, LoreSymbol.fullblock);
        }

        public TextFormatting getFormat() {
            return TextFormatting.func_175744_a((int)this.color.func_176767_b());
        }

        protected LorePixel copy() {
            return new LorePixel(this.color, this.symbol);
        }

        public String toString() {
            if (this.symbol.isWhitespace()) {
                return this.symbol.toString();
            }
            return this.getFormat().toString() + (Object)((Object)this.symbol);
        }
    }
}

